/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.axis.InteractAxisTracing;
import fr.neatmonster.nocheatplus.utilities.ds.map.BlockCoord;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class CollisionUtil {
    public static final double COLLISION_EPSILON = 1.0E-7;
    private static final boolean ServerIsAtLeast1_8 = ServerVersion.isAtLeast("1.8");
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static boolean isHorizontalCollisionNegligible(Vector collisionVector, PlayerLocation to, double strafeImpulse, double forwardImpulse) {
        float radYaw = to.getYaw() * ((float)Math.PI / 180);
        double sinYaw = TrigUtil.sin(radYaw);
        double cosYaw = TrigUtil.cos(radYaw);
        double var7 = strafeImpulse * cosYaw - forwardImpulse * sinYaw;
        double var9 = forwardImpulse * cosYaw + strafeImpulse * sinYaw;
        double var11 = MathUtil.square(var7) + MathUtil.square(var9);
        double var13 = MathUtil.square(collisionVector.getX()) + MathUtil.square(collisionVector.getZ());
        if (!(var11 < (double)1.0E-5f) && !(var13 < (double)1.0E-5f)) {
            double var15 = var7 * collisionVector.getX() + var9 * collisionVector.getZ();
            double collisionAngle = Math.acos(var15 / Math.sqrt(var11 * var13));
            return collisionAngle < 0.13962633907794952;
        }
        return false;
    }

    public static double directionCheck(Player player, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        Location loc = player.getLocation(useLoc);
        Vector dir = loc.getDirection();
        double res = CollisionUtil.directionCheck(loc.getX(), loc.getY() + MovingUtil.getEyeHeight(player), loc.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
        useLoc.setWorld(null);
        return res;
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision) {
        return CollisionUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision);
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        return CollisionUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
    }

    public static double directionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        double targetDist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + precision), 0.0);
        off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + precision), 0.0);
        if ((off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + precision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision, double anglePrecision, boolean isPlayer) {
        return CollisionUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision, anglePrecision, isPlayer);
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision, double anglePrecision) {
        return CollisionUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision, anglePrecision, true);
    }

    public static double combinedDirectionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double blockPrecision, double anglePrecision, boolean isPlayer) {
        double minDist;
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        double targetDist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double d = minDist = isPlayer ? Math.max(targetHeight, targetWidth) / 2.0 : Math.max(targetHeight, targetWidth);
        if (targetDist > minDist && TrigUtil.angle(sourceX, sourceY, sourceZ, dirX, dirY, dirZ, targetX, targetY, targetZ) * 57.29577951308232 > anglePrecision) {
            return targetDist - minDist;
        }
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0);
        off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + blockPrecision), 0.0);
        if ((off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static boolean intersectsBlock(double min, double max, int block) {
        double db = block;
        return db + 1.0 > min && db < max;
    }

    public static double getMinTimeIncludeEdges(double pos, double dir, double minPos, double maxPos) {
        if (pos >= minPos && pos <= maxPos) {
            return 0.0;
        }
        if (dir == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (dir < 0.0) {
            return pos < minPos ? Double.POSITIVE_INFINITY : Math.abs(pos - maxPos) / Math.abs(dir);
        }
        return pos > maxPos ? Double.POSITIVE_INFINITY : Math.abs(pos - minPos) / dir;
    }

    public static double getMaxTimeIncludeEdges(double pos, double dir, double minPos, double maxPos, double minTime) {
        if (Double.isInfinite(minTime)) {
            return Double.NaN;
        }
        if (dir == 0.0) {
            return pos < minPos || pos > maxPos ? Double.NaN : Double.POSITIVE_INFINITY;
        }
        if (dir < 0.0) {
            return pos < minPos ? Double.NaN : Math.abs(pos - minPos) / Math.abs(dir);
        }
        return pos > maxPos ? Double.NaN : Math.abs(pos - maxPos) / dir;
    }

    public static double getMaxAxisDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Math.max(CollisionUtil.axisDistance(x, minX, maxX), Math.max(CollisionUtil.axisDistance(y, minY, maxY), CollisionUtil.axisDistance(z, minZ, maxZ)));
    }

    public static double getManhattanDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return CollisionUtil.axisDistance(x, minX, maxX) + CollisionUtil.axisDistance(y, minY, maxY) + CollisionUtil.axisDistance(z, minZ, maxZ);
    }

    public static double getSquaredDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double dX = CollisionUtil.axisDistance(x, minX, maxX);
        double dY = CollisionUtil.axisDistance(y, minY, maxY);
        double dZ = CollisionUtil.axisDistance(z, minZ, maxZ);
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static double axisDistance(double pos, double minPos, double maxPos) {
        return pos < minPos ? Math.abs(pos - minPos) : (pos > maxPos ? Math.abs(pos - maxPos) : 0.0);
    }

    public static boolean isCollidingWithEntities(Player p, double xMargin, double yMargin, double zMargin, boolean shouldFilter) {
        if (shouldFilter) {
            List entities = p.getNearbyEntities(xMargin, yMargin, zMargin);
            entities.removeIf(e -> e.getType() == EntityType.MINECART || e.getType() == EntityType.ARMOR_STAND || !e.isValid() || MaterialUtil.isBoat(e.getType()) || !(e instanceof LivingEntity));
            return !entities.isEmpty();
        }
        return !p.getNearbyEntities(xMargin, yMargin, zMargin).isEmpty();
    }

    public static boolean exertsPushingForce(Entity e) {
        if (!GenericVersion.isAtLeast(e, "1.9")) {
            return false;
        }
        if (!e.isValid()) {
            return false;
        }
        if (e instanceof Player) {
            if (((Player)e).isSleeping() || !((Player)e).isOnline()) {
                return false;
            }
            if (((Player)e).getGameMode() == BridgeMisc.GAME_MODE_SPECTATOR) {
                return false;
            }
            Scoreboard playerScoreboard = ((Player)e).getScoreboard();
            Team team = playerScoreboard.getEntryTeam(((Player)e).getName());
            if (team == null) {
                Scoreboard mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                team = mainScoreboard.getEntryTeam(((Player)e).getName());
            }
            if (team != null) {
                Team.OptionStatus collisionRule = team.getOption(Team.Option.COLLISION_RULE);
                return collisionRule == Team.OptionStatus.ALWAYS || collisionRule == Team.OptionStatus.FOR_OTHER_TEAMS;
            }
            return true;
        }
        return e instanceof LivingEntity && ((LivingEntity)e).isCollidable() && e.getType() != EntityType.MINECART && e.getType() != EntityType.ARMOR_STAND && !MaterialUtil.isBoat(e.getType());
    }

    public static List<Location> getCollidingEntitiesLocations(Entity relEntity) {
        ArrayList<Location> collidingEntities = new ArrayList<Location>();
        for (Entity collidingEntity : relEntity.getNearbyEntities(1.0E-4, 0.0, 1.0E-4)) {
            if (!CollisionUtil.exertsPushingForce(collidingEntity)) continue;
            collidingEntities.add(collidingEntity.getLocation());
        }
        return collidingEntities;
    }

    public static boolean correctDir(int neighbor, int block, int eyeBlock) {
        int d = eyeBlock - block;
        return !(d > 0 ? neighbor > eyeBlock : (d < 0 ? neighbor < eyeBlock : neighbor < eyeBlock || neighbor > eyeBlock));
    }

    public static boolean correctDir(int neighbor, int block, int eyeBlock, int min, int max) {
        if (MathUtil.inRange(min, neighbor, max)) {
            return true;
        }
        return CollisionUtil.correctDir(neighbor, block, eyeBlock);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canPassThrough(InteractAxisTracing rayTracing, BlockCache blockCache, BlockCoord lastBlock, int x, int y, int z, Vector direction, double eyeX, double eyeY, double eyeZ, double eyeHeight, BlockCoord sCollidingBox, BlockCoord eCollidingBox, boolean mightEdgeInteraction, Axis.RichAxisData axisData) {
        double[] nextBlockBB = blockCache.getBounds(x, y, z);
        Material nextMat = blockCache.getType(x, y, z);
        long nextFlags = BlockFlags.getBlockFlags(nextMat);
        if (nextBlockBB == null) return true;
        if (CollisionUtil.canPassThroughWorkAround(blockCache, x, y, z, direction, eyeX, eyeY, eyeZ, eyeHeight)) {
            return true;
        }
        int dy = y - lastBlock.getY();
        int dx = x - lastBlock.getX();
        int dz = z - lastBlock.getZ();
        mightEdgeInteraction |= (BlockFlags.getBlockFlags(blockCache.getType(lastBlock.getX(), lastBlock.getY(), lastBlock.getZ())) & BlockFlags.F_LIQUID) != 0L;
        double[] lastBlockBB = blockCache.getBounds(lastBlock.getX(), lastBlock.getY(), lastBlock.getZ());
        double minX = nextBlockBB[0];
        double minY = nextBlockBB[1];
        double minZ = nextBlockBB[2];
        double maxX = nextBlockBB[3];
        double maxY = nextBlockBB[4];
        double maxZ = nextBlockBB[5];
        double lastMinX = lastBlockBB[0];
        double lastMinY = lastBlockBB[1];
        double lastMinZ = lastBlockBB[2];
        double lastMaxX = lastBlockBB[3];
        double lastMaxY = lastBlockBB[4];
        double lastMaxZ = lastBlockBB[5];
        if (lastBlockBB != null && axisData != null) {
            if ((double)dy != 0.0) {
                if (minY == 0.0 && maxY == 1.0 && minZ == 0.0 && maxZ == 1.0 && lastMinY == 0.0 && lastMaxY == 1.0 && lastMinZ == 0.0 && lastMaxZ == 1.0 && MathUtil.rangeContains(minX, lastMinX, maxX, lastMaxX)) {
                    BlockChangeTracker.Direction direction2 = minX == 0.0 ? BlockChangeTracker.Direction.X_NEG : (axisData.dirExclusion = maxX == 1.0 ? BlockChangeTracker.Direction.X_POS : BlockChangeTracker.Direction.NONE);
                }
                if (minY == 0.0 && maxY == 1.0 && minX == 0.0 && maxX == 1.0 && lastMinY == 0.0 && lastMaxY == 1.0 && lastMinX == 0.0 && lastMaxX == 1.0 && MathUtil.rangeContains(minZ, lastMinZ, maxZ, lastMaxZ)) {
                    BlockChangeTracker.Direction direction3 = minZ == 0.0 ? BlockChangeTracker.Direction.Z_NEG : (axisData.dirExclusion = maxZ == 1.0 ? BlockChangeTracker.Direction.Z_POS : BlockChangeTracker.Direction.NONE);
                }
            }
            if ((double)dx != 0.0) {
                if (minX == 0.0 && maxX == 1.0 && minZ == 0.0 && maxZ == 1.0 && lastMinX == 0.0 && lastMaxX == 1.0 && lastMinZ == 0.0 && lastMaxZ == 1.0 && MathUtil.rangeContains(minY, lastMinY, maxY, lastMaxY)) {
                    BlockChangeTracker.Direction direction4 = minY == 0.0 ? BlockChangeTracker.Direction.Y_NEG : (axisData.dirExclusion = maxY == 1.0 ? BlockChangeTracker.Direction.Y_POS : BlockChangeTracker.Direction.NONE);
                }
                if (minY == 0.0 && maxY == 1.0 && minX == 0.0 && maxX == 1.0 && lastMinY == 0.0 && lastMaxY == 1.0 && lastMinX == 0.0 && lastMaxX == 1.0 && MathUtil.rangeContains(minZ, lastMinZ, maxZ, lastMaxZ)) {
                    BlockChangeTracker.Direction direction5 = minZ == 0.0 ? BlockChangeTracker.Direction.Z_NEG : (axisData.dirExclusion = maxZ == 1.0 ? BlockChangeTracker.Direction.Z_POS : BlockChangeTracker.Direction.NONE);
                }
            }
            if ((double)dz != 0.0) {
                if (minX == 0.0 && maxX == 1.0 && minZ == 0.0 && maxZ == 1.0 && lastMinX == 0.0 && lastMaxX == 1.0 && lastMinZ == 0.0 && lastMaxZ == 1.0 && MathUtil.rangeContains(minY, lastMinY, maxY, lastMaxY)) {
                    BlockChangeTracker.Direction direction6 = minY == 0.0 ? BlockChangeTracker.Direction.Y_NEG : (axisData.dirExclusion = maxY == 1.0 ? BlockChangeTracker.Direction.Y_POS : BlockChangeTracker.Direction.NONE);
                }
                if (minY == 0.0 && maxY == 1.0 && minZ == 0.0 && maxZ == 1.0 && lastMinY == 0.0 && lastMaxY == 1.0 && lastMinZ == 0.0 && lastMaxZ == 1.0 && MathUtil.rangeContains(minX, lastMinX, maxX, lastMaxX)) {
                    BlockChangeTracker.Direction direction7 = minX == 0.0 ? BlockChangeTracker.Direction.X_NEG : (axisData.dirExclusion = maxX == 1.0 ? BlockChangeTracker.Direction.X_POS : BlockChangeTracker.Direction.NONE);
                }
            }
        }
        if (sCollidingBox != null && eCollidingBox != null && AxisAlignedBBUtils.isInsideAABBIncludeEdges(x, y, z, sCollidingBox.getX(), sCollidingBox.getY(), sCollidingBox.getZ(), eCollidingBox.getX(), eCollidingBox.getY(), eCollidingBox.getZ())) {
            return true;
        }
        double stepX = (double)dx * 0.99;
        double stepY = (double)dy * 0.99;
        double stepZ = (double)dz * 0.99;
        rayTracing.set(lastBlock.getX(), lastBlock.getY(), lastBlock.getZ(), (double)x + stepX, (double)y + stepY, (double)z + stepZ);
        rayTracing.setIgnoreInitiallyColliding(true);
        rayTracing.loop();
        rayTracing.setIgnoreInitiallyColliding(false);
        if (!rayTracing.collides()) {
            return true;
        }
        if ((nextFlags & BlockFlags.F_STAIRS) != 0L) {
            int i;
            if ((double)dy == 0.0) {
                int eyeBlockY = Location.locToBlock((double)eyeY);
                if (eyeBlockY > y && maxY == 1.0) {
                    return false;
                }
                if (eyeBlockY < y && minY == 0.0) {
                    return false;
                }
            }
            if ((double)dx != 0.0) {
                for (i = 2; i <= nextBlockBB.length / 6; ++i) {
                    if (nextBlockBB[i * 6 - 4] != 0.0 || nextBlockBB[i * 6 - 1] != 1.0 || !(dx < 0 ? nextBlockBB[i * 6 - 3] == 1.0 : nextBlockBB[i * 6 - 6] == 0.0)) continue;
                    return false;
                }
            }
            if ((double)dz != 0.0) {
                for (i = 2; i <= nextBlockBB.length / 6; ++i) {
                    if (nextBlockBB[i * 6 - 6] != 0.0 || nextBlockBB[i * 6 - 3] != 1.0 || !(dz < 0 ? nextBlockBB[i * 6 - 1] == 1.0 : nextBlockBB[i * 6 - 4] == 0.0)) continue;
                    return false;
                }
            }
        }
        if ((double)dy != 0.0) {
            if (minX == 0.0 && maxX == 1.0 && minZ == 0.0 && maxZ == 1.0) {
                if (axisData != null && ((double)dy > 0.0 ? minY != 0.0 : maxY != 1.0)) {
                    axisData.dirExclusion = (double)dy > 0.0 ? BlockChangeTracker.Direction.Y_POS : BlockChangeTracker.Direction.Y_NEG;
                    return true;
                }
                if (rayTracing.getCollidingAxis() == Axis.Y_AXIS) return false;
                return true;
            }
            if (mightEdgeInteraction) return true;
            if (lastBlockBB == null) return true;
            if (dy > 0) {
                if (lastMaxY != 1.0) return true;
                if (minY != 0.0) {
                    return true;
                }
            } else {
                if (lastMinY != 0.0) return true;
                if (maxY != 1.0) return true;
            }
            if (minX == 0.0 && lastMinX == 0.0 && maxX == 1.0 && lastMaxX == 1.0) {
                if (MathUtil.equal(MathUtil.getCoveredSpace(lastMinZ, lastMaxZ, minZ, maxZ), 1.0, 0.001)) return false;
            }
            if (minZ != 0.0) return true;
            if (lastMinZ != 0.0) return true;
            if (maxZ != 1.0) return true;
            if (lastMaxZ != 1.0) return true;
            if (MathUtil.equal(MathUtil.getCoveredSpace(lastMinX, lastMaxX, minX, maxX), 1.0, 0.001)) return false;
            return true;
        }
        if ((double)dx != 0.0) {
            if (nextBlockBB[1] == 0.0 && nextBlockBB[4] == 1.0 && nextBlockBB[2] == 0.0 && nextBlockBB[5] == 1.0) {
                if (axisData != null && (dx > 0 ? nextBlockBB[0] != 0.0 : nextBlockBB[3] != 1.0)) {
                    axisData.dirExclusion = dx > 0 ? BlockChangeTracker.Direction.X_POS : BlockChangeTracker.Direction.X_NEG;
                    return true;
                }
                if (rayTracing.getCollidingAxis() == Axis.X_AXIS) return false;
                return true;
            }
            if (mightEdgeInteraction) return true;
            if (lastBlockBB == null) return true;
            if (dx > 0) {
                if (lastBlockBB[3] != 1.0) return true;
                if (nextBlockBB[0] != 0.0) return true;
            } else {
                if (lastBlockBB[0] != 0.0) return true;
                if (nextBlockBB[3] != 1.0) return true;
            }
            if (nextBlockBB[1] == 0.0 && lastBlockBB[1] == 0.0 && nextBlockBB[4] == 1.0 && lastBlockBB[4] == 1.0) {
                if (MathUtil.equal(MathUtil.getCoveredSpace(lastBlockBB[2], lastBlockBB[5], nextBlockBB[2], nextBlockBB[5]), 1.0, 0.001)) return false;
            }
            if (nextBlockBB[2] != 0.0) return true;
            if (lastBlockBB[2] != 0.0) return true;
            if (nextBlockBB[5] != 1.0) return true;
            if (lastBlockBB[5] != 1.0) return true;
            if (!MathUtil.equal(MathUtil.getCoveredSpace(lastBlockBB[1], lastBlockBB[4], nextBlockBB[1], nextBlockBB[4]), 1.0, 0.001)) return true;
            return false;
        }
        if (dz == 0) return false;
        if (nextBlockBB[0] == 0.0 && nextBlockBB[3] == 1.0 && nextBlockBB[1] == 0.0 && nextBlockBB[4] == 1.0) {
            if (axisData != null && (dz > 0 ? nextBlockBB[2] != 0.0 : nextBlockBB[5] != 1.0)) {
                axisData.dirExclusion = dz > 0 ? BlockChangeTracker.Direction.Z_POS : BlockChangeTracker.Direction.Z_NEG;
                return true;
            }
            if (rayTracing.getCollidingAxis() == Axis.Z_AXIS) return false;
            return true;
        }
        if (mightEdgeInteraction) return true;
        if (lastBlockBB == null) return true;
        if (dz > 0) {
            if (lastBlockBB[5] != 1.0) return true;
            if (nextBlockBB[2] != 0.0) return true;
        } else {
            if (lastBlockBB[2] != 0.0) return true;
            if (nextBlockBB[5] != 1.0) return true;
        }
        if (nextBlockBB[1] == 0.0 && lastBlockBB[1] == 0.0 && nextBlockBB[4] == 1.0 && lastBlockBB[4] == 1.0) {
            if (MathUtil.equal(MathUtil.getCoveredSpace(lastBlockBB[0], lastBlockBB[3], nextBlockBB[0], nextBlockBB[3]), 1.0, 0.001)) return false;
        }
        if (nextBlockBB[0] != 0.0) return true;
        if (lastBlockBB[0] != 0.0) return true;
        if (nextBlockBB[3] != 1.0) return true;
        if (lastBlockBB[3] != 1.0) return true;
        if (!MathUtil.equal(MathUtil.getCoveredSpace(lastBlockBB[1], lastBlockBB[4], nextBlockBB[1], nextBlockBB[4]), 1.0, 0.001)) return true;
        return false;
    }

    private static boolean canPassThroughWorkAround(BlockCache blockCache, int blockX, int blockY, int blockZ, Vector direction, double eyeX, double eyeY, double eyeZ, double eyeHeight) {
        Material mat = blockCache.getType(blockX, blockY, blockZ);
        long flags = BlockFlags.getBlockFlags(mat);
        if ((flags & (BlockFlags.F_LIQUID | BlockFlags.F_IGN_PASSABLE)) != 0L) {
            return true;
        }
        if ((flags & (BlockFlags.F_THICK_FENCE | BlockFlags.F_THIN_FENCE)) != 0L) {
            int entityBlockY = Location.locToBlock((double)(eyeY - eyeHeight));
            return direction.getY() > 0.76 && entityBlockY > blockY || direction.getY() < -0.76 && entityBlockY < blockY;
        }
        return false;
    }

    public static Vector collideBoundingBox(Vector toCollide, double[] AABB, List<double[]> collisionBoxes) {
        boolean prioritizeZ;
        double[] tAABB = (double[])AABB.clone();
        double x = toCollide.getX();
        double y = toCollide.getY();
        double z = toCollide.getZ();
        if (y != 0.0) {
            for (double[] cb : collisionBoxes) {
                y = AxisAlignedBBUtils.collideY(cb, tAABB, y);
            }
            tAABB[1] = tAABB[1] + y;
            tAABB[4] = tAABB[4] + y;
        }
        boolean bl = prioritizeZ = Math.abs(x) < Math.abs(z);
        if (prioritizeZ && z != 0.0) {
            for (double[] cb : collisionBoxes) {
                z = AxisAlignedBBUtils.collideZ(cb, tAABB, z);
            }
            tAABB[2] = tAABB[2] + z;
            tAABB[5] = tAABB[5] + z;
        }
        if (x != 0.0) {
            for (double[] cb : collisionBoxes) {
                x = AxisAlignedBBUtils.collideX(cb, tAABB, x);
            }
            tAABB[0] = tAABB[0] + x;
            tAABB[3] = tAABB[3] + x;
        }
        if (!prioritizeZ && z != 0.0) {
            for (double[] cb : collisionBoxes) {
                z = AxisAlignedBBUtils.collideZ(cb, tAABB, z);
            }
            tAABB[2] = tAABB[2] + z;
            tAABB[5] = tAABB[5] + z;
        }
        return new Vector(x, y, z);
    }

    public static boolean getCollisionBoxes(BlockCache blockCache, Entity entity, double[] AABB, List<double[]> collisionBoxes, boolean onlyCheckCollide) {
        boolean collided = CollisionUtil.addWorldBorder(entity, AABB, collisionBoxes, onlyCheckCollide);
        if (onlyCheckCollide && collided) {
            return true;
        }
        int minBlockX = (int)Math.floor(AABB[0] - 1.0E-7) - 1;
        int maxBlockX = (int)Math.floor(AABB[3] + 1.0E-7) + 1;
        int minBlockY = (int)Math.floor(AABB[1] - 1.0E-7) - 1;
        int maxBlockY = (int)Math.floor(AABB[4] + 1.0E-7) + 1;
        int minBlockZ = (int)Math.floor(AABB[2] - 1.0E-7) - 1;
        int maxBlockZ = (int)Math.floor(AABB[5] + 1.0E-7) + 1;
        for (int y = minBlockY; y < maxBlockY; ++y) {
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                    int edgeCount;
                    Material mat = blockCache.getType(x, y, z);
                    if (BlockProperties.isAir(mat) || BlockProperties.isPassable(mat) || (edgeCount = (x == minBlockX || x == maxBlockX ? 1 : 0) + (y == minBlockY || y == maxBlockY ? 1 : 0) + (z == minBlockZ || z == maxBlockZ ? 1 : 0)) == 3 || edgeCount == 1 && (BlockFlags.getBlockFlags(mat) & BlockFlags.F_HEIGHT150) == 0L || edgeCount == 2 && mat != BridgeMaterial.MOVING_PISTON) continue;
                    if (!onlyCheckCollide) {
                        double[] multiAABB = AxisAlignedBBUtils.move(blockCache.fetchBounds(x, y, z), x, y, z);
                        collisionBoxes.addAll(AxisAlignedBBUtils.splitIntoSingle(multiAABB));
                        continue;
                    }
                    if (!AxisAlignedBBUtils.isCollided(blockCache.getBounds(x, y, z), x, y, z, AABB, true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEmpty(BlockCache blockCache, Entity entity, double[] AABB) {
        return !CollisionUtil.getCollisionBoxes(blockCache, entity, AABB, null, true);
    }

    public static boolean addWorldBorder(Entity entity, double[] AABB, List<double[]> collisionBoxes, boolean onlyCheckCollide) {
        if (ServerIsAtLeast1_8) {
            double toMaxZ;
            double toMinZ;
            double minimumInZDirection;
            double toMaxX;
            WorldBorder border = entity.getWorld().getWorldBorder();
            Location tloc = border.getCenter();
            double centerX = tloc.getX();
            double centerZ = tloc.getZ();
            double size = border.getSize() / 2.0;
            double absoluteMaxSize = 2.9999984E7;
            double minX = Math.floor(MathUtil.clamp(centerX - size, -absoluteMaxSize, absoluteMaxSize));
            double minZ = Math.floor(MathUtil.clamp(centerZ - size, -absoluteMaxSize, absoluteMaxSize));
            double maxX = Math.ceil(MathUtil.clamp(centerX + size, -absoluteMaxSize, absoluteMaxSize));
            double maxZ = Math.ceil(MathUtil.clamp(centerZ + size, -absoluteMaxSize, absoluteMaxSize));
            Location lastPlayerLoc = entity.getLocation(tloc);
            double toMinX = lastPlayerLoc.getX() - minX;
            double minimumInXDirection = Math.min(toMinX, toMaxX = maxX - lastPlayerLoc.getX());
            double distanceToBorder = Math.min(minimumInXDirection, minimumInZDirection = Math.min(toMinZ = lastPlayerLoc.getZ() - minZ, toMaxZ = maxZ - lastPlayerLoc.getZ()));
            if (distanceToBorder < 16.0 && lastPlayerLoc.getX() > minX && lastPlayerLoc.getX() < maxX && lastPlayerLoc.getZ() > minZ && lastPlayerLoc.getZ() < maxZ) {
                if (collisionBoxes == null) {
                    collisionBoxes = new ArrayList<double[]>();
                }
                collisionBoxes.add(new double[]{minX - 10.0, Double.NEGATIVE_INFINITY, maxZ, maxX + 10.0, Double.POSITIVE_INFINITY, maxZ});
                collisionBoxes.add(new double[]{minX - 10.0, Double.NEGATIVE_INFINITY, minZ, maxX + 10.0, Double.POSITIVE_INFINITY, minZ});
                collisionBoxes.add(new double[]{maxX, Double.NEGATIVE_INFINITY, minZ - 10.0, maxX, Double.POSITIVE_INFINITY, maxZ + 10.0});
                collisionBoxes.add(new double[]{minX, Double.NEGATIVE_INFINITY, minZ - 10.0, minX, Double.POSITIVE_INFINITY, maxZ + 10.0});
            }
        }
        return false;
    }

    public static float[] collectCandidateStepUpHeights(double[] AABB, List<double[]> collisionsBoxes, float stepHeight, float collideY) {
        HashSet<Float> stepHeights = new HashSet<Float>();
        double minY = AABB[1];
        block0: for (double[] collision : collisionsBoxes) {
            List<Double> yPoints = AxisAlignedBBUtils.getYPointPositions(collision);
            for (double possibleStepY : yPoints) {
                float yDiff = (float)(possibleStepY - minY);
                if (!(yDiff >= 0.0f) || yDiff == collideY) continue;
                if (yDiff > stepHeight) continue block0;
                stepHeights.add(Float.valueOf(yDiff));
            }
        }
        ArrayList sortedStepHeights = new ArrayList(stepHeights);
        Collections.sort(sortedStepHeights);
        float[] stepHeightArray = new float[sortedStepHeights.size()];
        for (int i = 0; i < sortedStepHeights.size(); ++i) {
            stepHeightArray[i] = ((Float)sortedStepHeights.get(i)).floatValue();
        }
        return stepHeightArray;
    }

    public static double postCorrect(int blockC, int bdC, double collideC) {
        int ref;
        int n = ref = bdC < 0 ? blockC + 1 : blockC;
        if (Location.locToBlock((double)collideC) == ref) {
            return collideC;
        }
        return ref;
    }

    public static double getMinTime(double eye, int eyeBlock, double dir, int blockDiff) {
        if (blockDiff == 0) {
            return 0.0;
        }
        double eyeOffset = Math.abs(eye - (double)eyeBlock);
        return ((dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) + (double)(Math.abs(blockDiff) - 1)) / Math.abs(dir);
    }

    public static double getMaxTime(double eye, int eyeBlock, double dir, double tMin) {
        if (dir == 0.0) {
            return Double.MAX_VALUE;
        }
        if (tMin == 0.0) {
            double eyeOffset = Math.abs(eye - (double)eyeBlock);
            return (dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) / Math.abs(dir);
        }
        return tMin + 1.0 / Math.abs(dir);
    }

    public static double toBlock(double coord, int block) {
        int blockDiff = block - Location.locToBlock((double)coord);
        if (blockDiff == 0) {
            return coord;
        }
        return Math.round(coord);
    }
}

