/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.utilities.Validate;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;

public class AxisAlignedBBUtils {
    private static final IGenericInstanceHandle<MCAccess> mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(MCAccess.class);

    public static int getNumberOfAABBs(double[] array) {
        Validate.validateAABB(array);
        return array.length / 6;
    }

    public static boolean isSimpleShape(double[] array) {
        return AxisAlignedBBUtils.getNumberOfAABBs(array) == 1;
    }

    public static double[] toArray(BoundingBox box) {
        if (box == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
        return new double[]{box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()};
    }

    public static double[] extractBoundingBox(double[] multiAABB, int boxNumber) {
        int numberOfAABBs = AxisAlignedBBUtils.getNumberOfAABBs(multiAABB);
        if (boxNumber < 1 || boxNumber > numberOfAABBs) {
            throw new IllegalArgumentException("boxNumber is out of bounds. Valid indices are between 1 and " + numberOfAABBs);
        }
        if (AxisAlignedBBUtils.isSimpleShape(multiAABB)) {
            return multiAABB;
        }
        int start = (boxNumber - 1) * 6;
        return new double[]{multiAABB[start], multiAABB[start + 1], multiAABB[start + 2], multiAABB[start + 3], multiAABB[start + 4], multiAABB[start + 5]};
    }

    public static List<double[]> splitIntoSingle(double[] multiAABB) {
        int numberOfAABBs = AxisAlignedBBUtils.getNumberOfAABBs(multiAABB);
        if (AxisAlignedBBUtils.isSimpleShape(multiAABB)) {
            return Collections.singletonList(multiAABB);
        }
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (int i = 1; i <= numberOfAABBs; ++i) {
            list.add(AxisAlignedBBUtils.extractBoundingBox(multiAABB, i));
        }
        return list;
    }

    public static double[] createBoundingBoxFor(Entity entity) {
        double halfWidth = mcAccess.getHandle().getWidth(entity) / 2.0;
        double height = mcAccess.getHandle().getHeight(entity);
        Location center = entity.getLocation();
        return new double[]{center.getX() - halfWidth, center.getY(), center.getZ() - halfWidth, center.getX() + halfWidth, center.getY() + height, center.getZ() + halfWidth};
    }

    public static double[] createBoundingBoxAtWidthResolutionFor(Entity entity, Location refLoc) {
        double widthRes = (double)Math.round(mcAccess.getHandle().getWidth(entity) * 500.0) / 1000.0;
        double height = mcAccess.getHandle().getHeight(entity);
        Location center = refLoc;
        if (center == null) {
            center = entity.getLocation();
        }
        return new double[]{center.getX() - widthRes, center.getY(), center.getZ() - widthRes, center.getX() + widthRes, center.getY() + height, center.getZ() + widthRes};
    }

    public static double[] move(double[] AABB, double x, double y, double z) {
        double[] tAABB = (double[])AABB.clone();
        for (int i = 1; i <= AxisAlignedBBUtils.getNumberOfAABBs(AABB); ++i) {
            int n = i * 6 - 6;
            tAABB[n] = tAABB[n] + x;
            int n2 = i * 6 - 3;
            tAABB[n2] = tAABB[n2] + x;
            int n3 = i * 6 - 5;
            tAABB[n3] = tAABB[n3] + y;
            int n4 = i * 6 - 2;
            tAABB[n4] = tAABB[n4] + y;
            int n5 = i * 6 - 4;
            tAABB[n5] = tAABB[n5] + z;
            int n6 = i * 6 - 1;
            tAABB[n6] = tAABB[n6] + z;
        }
        return tAABB;
    }

    public static double[] expandTowards(double[] AABB, double x, double y, double z) {
        double[] tAABB = (double[])AABB.clone();
        if (x < 0.0) {
            tAABB[0] = tAABB[0] + x;
        } else {
            tAABB[3] = tAABB[3] + x;
        }
        if (y < 0.0) {
            tAABB[1] = tAABB[1] + y;
        } else {
            tAABB[4] = tAABB[4] + y;
        }
        if (z < 0.0) {
            tAABB[2] = tAABB[2] + z;
        } else {
            tAABB[5] = tAABB[5] + z;
        }
        return tAABB;
    }

    public static double collideX(double[] AABB, double[] other, double offsetX) {
        if (offsetX != 0.0 && other[1] - AABB[4] < -1.0E-7 && other[4] - AABB[1] > 1.0E-7 && other[2] - AABB[5] < -1.0E-7 && other[5] - AABB[2] > 1.0E-7) {
            if (offsetX >= 0.0) {
                double max_move = AABB[0] - other[3];
                if (max_move < -1.0E-7) {
                    return offsetX;
                }
                return Math.min(max_move, offsetX);
            }
            double max_move = AABB[3] - other[0];
            if (max_move > 1.0E-7) {
                return offsetX;
            }
            return Math.max(max_move, offsetX);
        }
        return offsetX;
    }

    public static double collideY(double[] AABB, double[] other, double offsetY) {
        if (offsetY != 0.0 && other[0] - AABB[3] < -1.0E-7 && other[3] - AABB[0] > 1.0E-7 && other[2] - AABB[5] < -1.0E-7 && other[5] - AABB[2] > 1.0E-7) {
            if (offsetY >= 0.0) {
                double max_move = AABB[1] - other[4];
                if (max_move < -1.0E-7) {
                    return offsetY;
                }
                return Math.min(max_move, offsetY);
            }
            double max_move = AABB[4] - other[1];
            if (max_move > 1.0E-7) {
                return offsetY;
            }
            return Math.max(max_move, offsetY);
        }
        return offsetY;
    }

    public static double collideZ(double[] AABB, double[] other, double offsetZ) {
        if (offsetZ != 0.0 && other[0] - AABB[3] < -1.0E-7 && other[3] - AABB[0] > 1.0E-7 && other[1] - AABB[4] < -1.0E-7 && other[4] - AABB[1] > 1.0E-7) {
            if (offsetZ >= 0.0) {
                double max_move = AABB[2] - other[5];
                if (max_move < -1.0E-7) {
                    return offsetZ;
                }
                return Math.min(max_move, offsetZ);
            }
            double max_move = AABB[5] - other[2];
            if (max_move > 1.0E-7) {
                return offsetZ;
            }
            return Math.max(max_move, offsetZ);
        }
        return offsetZ;
    }

    public static boolean isIntersected(double[] multiAABB, double[] singleAABB) {
        for (int i = 0; i < AxisAlignedBBUtils.getNumberOfAABBs(multiAABB); ++i) {
            int index = i * 6;
            if (!(singleAABB[3] - 1.0E-7 > multiAABB[index]) || !(singleAABB[0] + 1.0E-7 < multiAABB[index + 3]) || !(singleAABB[4] - 1.0E-7 > multiAABB[index + 1]) || !(singleAABB[1] + 1.0E-7 < multiAABB[index + 4]) || !(singleAABB[5] - 1.0E-7 > multiAABB[index + 2]) || !(singleAABB[2] + 1.0E-7 < multiAABB[index + 5])) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollided(double[] blockAABB, int x, int y, int z, double[] sAABB, boolean allowEdge, int startIndex) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex cannot be less than 1. Index: " + startIndex);
        }
        if (blockAABB != null && sAABB != null) {
            for (int i = startIndex; i <= AxisAlignedBBUtils.getNumberOfAABBs(blockAABB); ++i) {
                if (sAABB[0] > blockAABB[i * 6 - 3] + (double)x || sAABB[3] < blockAABB[i * 6 - 6] + (double)x || sAABB[1] > blockAABB[i * 6 - 2] + (double)y || sAABB[4] < blockAABB[i * 6 - 5] + (double)y || sAABB[2] > blockAABB[i * 6 - 1] + (double)z || sAABB[5] < blockAABB[i * 6 - 4] + (double)z || sAABB[0] == blockAABB[i * 6 - 3] + (double)x && (blockAABB[i * 6 - 3] < 1.0 || allowEdge) || sAABB[1] == blockAABB[i * 6 - 2] + (double)y && (blockAABB[i * 6 - 2] < 1.0 || allowEdge) || sAABB[2] == blockAABB[i * 6 - 1] + (double)z && (blockAABB[i * 6 - 1] < 1.0 || allowEdge)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollided(double[] blockAABB, int x, int y, int z, double[] sAABB, boolean allowEdge) {
        return AxisAlignedBBUtils.isCollided(blockAABB, x, y, z, sAABB, allowEdge, 1);
    }

    public static boolean isFullBounds(double[] bounds) {
        if (bounds == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] == 0.0 && bounds[i + 3] == 1.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDegenerate(double[] AABB) {
        Validate.validateAABB(AABB);
        return AABB[0] == 0.0 || AABB[2] == 0.0 || AABB[3] == 0.0 || AABB[5] == 0.0;
    }

    public static boolean isZero(double[] bounds) {
        Validate.validateAABB(bounds);
        for (double bound : bounds) {
            if (bound == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameShape(double[] bounds1, double[] bounds2) {
        if (bounds1 == null || bounds2 == null) {
            return bounds1 == bounds2;
        }
        for (int i = 0; i < 6; ++i) {
            if (bounds1[i] == bounds2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isInsideAABBIncludeEdges(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return !(x < minX || x > maxX || z < minZ || z > maxZ || y < minY || y > maxY);
    }

    public static boolean isInsideAABBIncludeEdges(double x, double y, double z, double[] AABB) {
        Validate.validateAABB(AABB);
        double minX = AABB[0];
        double minY = AABB[1];
        double minZ = AABB[2];
        double maxX = AABB[3];
        double maxY = AABB[4];
        double maxZ = AABB[5];
        return AxisAlignedBBUtils.isInsideAABBIncludeEdges(x, y, z, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static List<Double> getYPointPositions(double[] AABB) {
        return AxisAlignedBBUtils.getYPointPositions(AABB[0], AABB[1], AABB[2], AABB[3], AABB[4], AABB[5]);
    }

    private static List<Double> getYPointPositions(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int xBitPrecision = MathUtil.findBits(minX, maxX);
            int yBitPrecision = MathUtil.findBits(minY, maxY);
            int zBitPrecision = MathUtil.findBits(minZ, maxZ);
            if (xBitPrecision < 0 || yBitPrecision < 0 || zBitPrecision < 0) {
                ArrayList<Double> result = new ArrayList<Double>();
                result.add(minY);
                result.add(maxY);
                return result;
            }
            if (xBitPrecision == 0 && yBitPrecision == 0 && zBitPrecision == 0) {
                ArrayList<Double> result = new ArrayList<Double>();
                result.add(0.0);
                result.add(1.0);
                return result;
            }
            int subdivisions = 1 << yBitPrecision;
            ArrayList<Double> result = new ArrayList<Double>();
            for (int index = 0; index <= subdivisions; ++index) {
                result.add((double)index / (double)subdivisions);
            }
            return result;
        }
        return new ArrayList<Double>();
    }
}

