/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.components.concurrent.IPrimaryThreadContextTester;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CheckUtils {
    public static final IPrimaryThreadContextTester primaryServerThreadContextTester = new IPrimaryThreadContextTester(){

        @Override
        public boolean isPrimaryThread() {
            return Bukkit.isPrimaryThread();
        }
    };

    public static void improperAsynchronousAPIAccess(CheckType checkType) {
        String trace = Arrays.toString(Thread.currentThread().getStackTrace());
        StaticLog.logOnce(Streams.STATUS, Level.SEVERE, "Off primary thread processing for " + (Object)((Object)checkType), trace);
    }

    public static boolean demandPrimaryThread(CheckType checkType) {
        if (Bukkit.isPrimaryThread()) {
            return true;
        }
        CheckUtils.improperAsynchronousAPIAccess(checkType);
        return false;
    }

    public static void kickIllegalMove(Player player, MovingConfig cc) {
        player.kickPlayer(cc.msgKickIllegalMove);
        StaticLog.logWarning("[NoCheatPlus] Disconnect " + player.getName() + " due to illegal move!");
    }

    public static final long guessKeepAliveTime(Player player, long now, long maxAge, IPlayerData pData) {
        int tick = TickTask.getTick();
        long ref = Long.MIN_VALUE;
        FightData fData = pData.getGenericInstance(FightData.class);
        ref = Math.max(ref, now - 50L * (long)(tick - fData.lastAttackTick));
        ref = Math.max(ref, fData.regainHealthTime);
        ref = Math.max(ref, pData.getGenericInstance(CombinedData.class).lastMoveTime);
        InventoryData iData = pData.getGenericInstance(InventoryData.class);
        ref = Math.max(ref, iData.lastClickTime);
        ref = Math.max(ref, iData.fastConsumeInteract);
        BlockBreakData bbData = pData.getGenericInstance(BlockBreakData.class);
        ref = Math.max(ref, bbData.frequencyBuckets.lastUpdate());
        if ((ref = Math.max(ref, bbData.fastBreakfirstDamage)) > now || ref < now - maxAge) {
            return Long.MIN_VALUE;
        }
        return ref;
    }

    public static void debug(Player player, CheckType checkType, String message) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, checkType) + message);
    }

    public static String getLogMessagePrefix(Player player, CheckType checkType) {
        return CheckUtils.getLogMessagePrefix(player == null ? null : player.getName(), checkType);
    }

    public static String getLogMessagePrefix(String playerName, CheckType checkType) {
        String base = "[" + (Object)((Object)checkType) + "] ";
        if (playerName != null) {
            base = base + "[" + playerName + "] ";
        }
        return base;
    }
}

