/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.versions.BukkitVersion;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.config.ICheckConfig;
import fr.neatmonster.nocheatplus.components.config.IConfig;
import fr.neatmonster.nocheatplus.components.data.ICanHandleTimeRunningBackwards;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.data.IDataOnJoin;
import fr.neatmonster.nocheatplus.components.data.IDataOnLeave;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldChange;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldUnload;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.factory.RichFactoryRegistry;
import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.components.registry.feature.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.components.registry.feature.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.registry.feature.INeedConfig;
import fr.neatmonster.nocheatplus.components.registry.feature.IRemoveData;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.permissions.PermissionPolicy;
import fr.neatmonster.nocheatplus.permissions.PermissionRegistry;
import fr.neatmonster.nocheatplus.permissions.PermissionSettings;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.IPlayerDataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.players.PlayerMap;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.corw.DualSet;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.WorldDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldUnloadEvent;

@RegistrationOrder.RegisterWithOrder(tag="system.nocheatplus.datamanager", beforeTag="(^feature.*)", basePriority="-80")
public class PlayerDataManager
implements IPlayerDataManager,
ComponentWithName,
INeedConfig,
ConsistencyChecker,
IDisableListener {
    private int foundInconsistencies = 0;
    private final HashMapLOW<UUID, PlayerData> playerData = new HashMapLOW(100);
    private final Set<UUID> bulkPlayerDataRemoval = new LinkedHashSet<UUID>();
    private final DualSet<UUID> frequentPlayerTasks = new DualSet();
    private final Map<UUID, Long> lastLogout = new LinkedHashMap<UUID, Long>(50, 0.75f, true);
    private final PlayerMap playerMap;
    private final ArrayList<IRemoveData> iRemoveData = new ArrayList();
    private final Map<CheckType, Map<String, ExecutionHistory>> executionHistories = new HashMap<CheckType, Map<String, ExecutionHistory>>();
    private boolean doExpireData = false;
    private long durExpireData = 0L;
    private boolean deleteData = true;
    private boolean deleteHistory = false;
    private final PermissionRegistry permissionRegistry;
    private WorldDataManager worldDataManager;
    private final Lock lock = new ReentrantLock();
    private final RichFactoryRegistry<PlayerFactoryArgument> factoryRegistry = new RichFactoryRegistry(this.lock);
    private final TickListener tickListener = new TickListener(){
        private int delayRareTasks = 0;

        @Override
        public void onTick(int tick, long timeLast) {
            if (PlayerDataManager.this.rareTasks(tick, timeLast)) {
                this.delayRareTasks = 10;
            } else if (this.delayRareTasks != 0) {
                --this.delayRareTasks;
            }
            PlayerDataManager.this.frequentTasks(tick, timeLast);
        }
    };
    private final MiniListener<?>[] miniListeners = new MiniListener[]{new MiniListener<PlayerQuitEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", afterTag=".*")
        public void onEvent(PlayerQuitEvent event) {
            PlayerDataManager.this.playerLeaves(event.getPlayer());
        }
    }, new MiniListener<PlayerKickEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", afterTag="feature.*")
        public void onEvent(PlayerKickEvent event) {
            PlayerDataManager.this.playerLeaves(event.getPlayer());
        }
    }, new MiniListener<AsyncPlayerPreLoginEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", beforeTag=".*")
        public void onEvent(AsyncPlayerPreLoginEvent event) {
            if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                PlayerDataManager.this.onAsyncPlayerPreLogin(event);
            }
        }
    }, new MiniListener<PlayerLoginEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", beforeTag=".*")
        public void onEvent(PlayerLoginEvent event) {
            if (event.getResult() == PlayerLoginEvent.Result.ALLOWED) {
                PlayerDataManager.this.onPlayerLogin(event);
            } else {
                PlayerDataManager.this.onPlayerLoginDenied(event);
            }
        }
    }, new MiniListener<PlayerJoinEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", beforeTag=".*")
        public void onEvent(PlayerJoinEvent event) {
            PlayerDataManager.this.playerJoins(event);
        }
    }, new MiniListener<PlayerChangedWorldEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", beforeTag=".*")
        public void onEvent(PlayerChangedWorldEvent event) {
            PlayerDataManager.this.playerChangedWorld(event);
        }
    }, new MiniListener<WorldUnloadEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.datamanager", beforeTag=".*")
        public void onEvent(WorldUnloadEvent event) {
            PlayerDataManager.this.onWorldUnload(event);
        }
    }};

    public PlayerDataManager(WorldDataManager worldDataManager, PermissionRegistry permissionRegistry) {
        String version;
        DataManager.instance = this;
        if (ServerVersion.isMinecraftVersionUnknown()) {
            BukkitVersion.init();
        }
        this.playerMap = GenericVersion.compareVersions(version = ServerVersion.getMinecraftVersion(), "1.8") >= 0 || version.equals("1.7.10") && Bukkit.getServer().getVersion().toLowerCase().indexOf("spigot") != -1 ? new PlayerMap(false) : new PlayerMap(true);
        this.permissionRegistry = permissionRegistry;
        this.worldDataManager = worldDataManager;
        this.factoryRegistry.createAutoGroup(IDataOnReload.class);
        this.factoryRegistry.createAutoGroup(IDataOnWorldUnload.class);
        this.factoryRegistry.createAutoGroup(IDataOnJoin.class);
        this.factoryRegistry.createAutoGroup(IDataOnLeave.class);
        this.factoryRegistry.createAutoGroup(IDataOnWorldChange.class);
        this.factoryRegistry.createAutoGroup(IDataOnRemoveSubCheckData.class);
        this.factoryRegistry.createAutoGroup(IData.class);
        this.factoryRegistry.createAutoGroup(IConfig.class);
        this.factoryRegistry.createAutoGroup(ICheckData.class);
        this.factoryRegistry.createAutoGroup(ICheckConfig.class);
    }

    public void checkExpiration() {
        Map.Entry<UUID, Long> entry;
        long ts;
        if (!this.doExpireData || this.durExpireData <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        Set<Map.Entry<UUID, Long>> entries = this.lastLogout.entrySet();
        Iterator<Map.Entry<UUID, Long>> iterator = entries.iterator();
        while (iterator.hasNext() && now - (ts = (entry = iterator.next()).getValue().longValue()) > this.durExpireData) {
            UUID playerId = entry.getKey();
            this.legacyPlayerDataExpirationRemovalByName(playerId, this.deleteData);
            this.bulkPlayerDataRemoval.add(playerId);
            iterator.remove();
        }
        if (!this.bulkPlayerDataRemoval.isEmpty()) {
            this.doBulkPlayerDataRemoval();
        }
    }

    private final void legacyPlayerDataExpirationRemovalByName(UUID playerId, boolean deleteData) {
        String playerName = DataManager.getPlayerName(playerId);
        if (playerName == null) {
            return;
        }
        if (deleteData) {
            PlayerData pData = this.playerData.get(playerId);
            if (pData != null) {
                pData.removeData(false);
            }
            this.clearComponentData(CheckType.ALL, playerName);
        }
        if (deleteData || this.deleteHistory) {
            this.removeExecutionHistory(CheckType.ALL, playerName);
        }
        if (this.deleteHistory) {
            ViolationHistory.removeHistory(playerName);
        }
    }

    private final boolean rareTasks(int tick, long timeLast) {
        boolean something = false;
        if (!this.bulkPlayerDataRemoval.isEmpty()) {
            this.doBulkPlayerDataRemoval();
            something = true;
        }
        return something;
    }

    private final void frequentTasks(int tick, long timeLast) {
        this.frequentPlayerTasks.mergePrimaryThread();
        Iterator it = this.frequentPlayerTasks.iteratorPrimaryThread();
        while (it.hasNext()) {
            PlayerData pData = this.getPlayerData((UUID)it.next(), null, false, null);
            if (pData != null && !pData.processTickFrequent(tick, timeLast)) continue;
            it.remove();
        }
    }

    private final void doBulkPlayerDataRemoval() {
        int size = this.bulkPlayerDataRemoval.size();
        if (size > 0) {
            Iterator<UUID> it = this.bulkPlayerDataRemoval.iterator();
            while (it.hasNext()) {
                UUID playerId = it.next();
                boolean skip = !this.lastLogout.containsKey(playerId);
                if (!skip) continue;
                it.remove();
                --size;
                PlayerData data = this.playerData.get(playerId);
                if (data == null) continue;
                data.removeData(true);
            }
            if (size > 0) {
                this.playerData.remove(this.bulkPlayerDataRemoval);
                this.bulkPlayerDataRemoval.clear();
                if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.STATUS, "Bulk PlayerData removal: " + size);
                }
            }
        }
    }

    public boolean removeData(String playerName, CheckType checkType) {
        boolean somethingFound;
        UUID playerId;
        PlayerData pData = this.getPlayerData(playerName);
        UUID uUID = playerId = pData == null ? this.getUUID(playerName) : pData.getPlayerId();
        if (pData == null && playerId != null) {
            pData = this.playerData.get(playerId);
        }
        boolean bl = somethingFound = pData != null || playerId != null;
        if (checkType == null) {
            checkType = CheckType.ALL;
        }
        somethingFound |= this.clearComponentData(checkType, playerName);
        if (pData != null) {
            boolean hasSub;
            RichFactoryRegistry.CheckRemovalSpec removalSpec = new RichFactoryRegistry.CheckRemovalSpec(checkType, true, this);
            boolean hasComplete = !removalSpec.completeRemoval.isEmpty();
            boolean bl2 = hasSub = !removalSpec.subCheckRemoval.isEmpty();
            if (hasComplete || hasSub) {
                if (hasComplete) {
                    pData.removeAllGenericInstances(removalSpec.completeRemoval);
                }
                if (hasSub) {
                    pData.removeSubCheckData(removalSpec.subCheckRemoval, removalSpec.checkTypes);
                }
            }
            if (checkType == CheckType.ALL && playerId != null) {
                this.bulkPlayerDataRemoval.add(playerId);
            }
            if (pData.isDebugActive(checkType)) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(playerName, checkType) + "Removed data.");
            }
        }
        return somethingFound;
    }

    public boolean storesPlayerInstances() {
        return this.playerMap.storesPlayerInstances();
    }

    @Override
    public boolean addComponent(IRemoveData obj) {
        if (this.iRemoveData.contains(obj)) {
            return false;
        }
        this.iRemoveData.add(obj);
        return true;
    }

    @Override
    public void removeComponent(IRemoveData obj) {
        this.iRemoveData.remove(obj);
    }

    public void onEnable() {
        TickTask.addTickListener(this.tickListener);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        for (MiniListener<?> miniListener : this.miniListeners) {
            api.addComponent(miniListener, false);
        }
        for (MiniListener<?> miniListener : BridgeMisc.getOnlinePlayers()) {
            this.addOnlinePlayer((Player)miniListener);
        }
    }

    @Override
    public void onDisable() {
        this.clearData(CheckType.ALL);
        this.playerData.clear();
        this.iRemoveData.clear();
        this.lastLogout.clear();
        this.executionHistories.clear();
        this.playerMap.clear();
        if (this.foundInconsistencies > 0) {
            StaticLog.logWarning("DataMan found " + this.foundInconsistencies + " inconsistencies (warnings suppressed).");
            this.foundInconsistencies = 0;
        }
    }

    public void onWorldUnload(WorldUnloadEvent event) {
        Collection<Class<? extends IDataOnWorldUnload>> types = this.factoryRegistry.getGroupedTypes(IDataOnWorldUnload.class);
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().onWorldUnload(event.getWorld(), types);
        }
    }

    private void addOnlinePlayer(Player player) {
        this.playerMap.updatePlayer(player);
    }

    private void removeOnlinePlayer(Player player) {
        this.playerMap.remove(player);
    }

    private void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        UUID playerId = event.getUniqueId();
        if (this.playerData.containsKey(playerId)) {
            return;
        }
        this.getPlayerData(playerId, event.getName(), true, this.worldDataManager.getDefaultWorldData()).addTag("optimistic_create");
    }

    private void onPlayerLoginDenied(PlayerLoginEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        PlayerData pData = this.getPlayerData(playerId);
        if (pData != null && pData.hasTag("optimistic_create")) {
            this.bulkPlayerDataRemoval.add(playerId);
        }
    }

    private void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        PlayerData pData = this.getPlayerData(playerId);
        if (pData == null) {
            this.getPlayerData(player);
        } else {
            String playerName = pData.getPlayerName();
            if (!playerName.equals(player.getName())) {
                this.updatePlayerName(playerId, playerName, pData, "login");
            }
            pData.updateCurrentWorld(this.worldDataManager.getWorldData(player.getWorld()));
        }
        pData.removeTag("optimistic_create");
    }

    private void updatePlayerName(UUID playerId, String playerName, PlayerData pData, String tag) {
        pData.updatePlayerName(playerName);
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, CheckUtils.getLogMessagePrefix(playerName, null) + " Update player name for id " + playerId + ": " + playerName + "(" + tag + (pData.hasTag("optimistic_create") ? ", optimistically created data" : "") + ")");
    }

    private void playerJoins(PlayerJoinEvent event) {
        long timeNow = System.currentTimeMillis();
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.lastLogout.remove(playerId);
        this.addOnlinePlayer(player);
        PlayerData pData = this.getPlayerData(player, true);
        String playerName = pData.getPlayerName();
        if (!playerName.equals(player.getName())) {
            this.updatePlayerName(playerId, playerName, pData, "login");
        }
        Collection<Class<? extends IDataOnJoin>> types = this.factoryRegistry.getGroupedTypes(IDataOnJoin.class);
        pData.onPlayerJoin(player, player.getWorld(), timeNow, this.worldDataManager, types);
        pData.getGenericInstance(CombinedData.class).lastJoinTime = timeNow;
    }

    private void playerLeaves(Player player) {
        long timeNow = System.currentTimeMillis();
        UUID playerId = player.getUniqueId();
        this.lastLogout.put(playerId, timeNow);
        PlayerData pData = this.playerData.get(playerId);
        if (pData != null) {
            Collection<Class<? extends IDataOnLeave>> types = this.factoryRegistry.getGroupedTypes(IDataOnLeave.class);
            pData.onPlayerLeave(player, timeNow, types);
            pData.getGenericInstance(CombinedData.class).lastLogoutTime = timeNow;
        }
        this.removeOnlinePlayer(player);
    }

    private void playerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        PlayerData pData = this.getPlayerData(player, true);
        Collection<Class<? extends IDataOnWorldChange>> types = this.factoryRegistry.getGroupedTypes(IDataOnWorldChange.class);
        pData.onPlayerChangedWorld(player, event.getFrom(), player.getWorld(), this.worldDataManager, types);
    }

    private void adjustSettings() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.doExpireData = config.getBoolean("data.expiration.active");
        this.durExpireData = config.getLong("data.expiration.duration", 1L, 1000000L, 60L) * 60000L;
        this.deleteData = config.getBoolean("data.expiration.data", true);
        this.deleteHistory = config.getBoolean("data.expiration.history");
        Set<RegisteredPermission> changedPermissions = null;
        try {
            changedPermissions = this.permissionRegistry.updateSettings(PermissionSettings.fromConfig((ConfigurationSection)config, "permissions.policy.default", "permissions.policy.rules"));
        }
        catch (Exception e) {
            StaticLog.logSevere("Failed to read the permissions setup. Relay to ALWAYS policy.");
            StaticLog.logSevere(e);
            this.permissionRegistry.updateSettings(new PermissionSettings(null, null, new PermissionPolicy()));
        }
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().adjustSettings(changedPermissions);
        }
    }

    @Override
    public void onReload() {
        this.adjustSettings();
        Collection<Class<? extends IDataOnReload>> types = this.factoryRegistry.getGroupedTypes(IDataOnReload.class);
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().onReload(types);
        }
    }

    @Override
    public String getComponentName() {
        return "NoCheatPlus_DataManager";
    }

    @Override
    public void checkConsistency(Player[] onlinePlayers) {
        int missing = 0;
        int changed = 0;
        for (int i = 0; i < onlinePlayers.length; ++i) {
            Player player = onlinePlayers[i];
            UUID id = player.getUniqueId();
            if (!this.playerMap.hasPlayerInfo(id)) {
                ++missing;
            }
            if (!this.playerMap.storesPlayerInstances() || player == this.playerMap.getPlayer(id)) continue;
            ++changed;
            this.addOnlinePlayer(player);
        }
        int storedSize = this.playerMap.size();
        if (missing != 0 || changed != 0 || onlinePlayers.length != storedSize) {
            ++this.foundInconsistencies;
            if (!ConfigManager.getConfigFile().getBoolean("data.consistency-checks.suppress-warnings")) {
                LinkedList<String> details = new LinkedList<String>();
                if (missing != 0) {
                    details.add("missing online players (" + missing + ")");
                }
                if (onlinePlayers.length != storedSize) {
                    details.add("wrong number of online players (" + storedSize + " instead of " + onlinePlayers.length + ")");
                }
                if (changed != 0) {
                    details.add("changed player instances (" + changed + ")");
                }
                StaticLog.logWarning("DataMan inconsistencies: " + StringUtil.join(details, " | "));
            }
        }
    }

    void registerFrequentPlayerTaskPrimaryThread(UUID playerId) {
        this.frequentPlayerTasks.addPrimaryThread(playerId);
    }

    void registerFrequentPlayerTaskAsynchronous(UUID playerId) {
        this.frequentPlayerTasks.addAsynchronous(playerId);
    }

    boolean isFrequentPlayerTaskScheduled(UUID playerId) {
        if (Bukkit.isPrimaryThread()) {
            return this.frequentPlayerTasks.containsPrimaryThread(playerId);
        }
        return this.frequentPlayerTasks.containsAsynchronous(playerId);
    }

    public boolean clearComponentData(CheckType checkType, String PlayerName) {
        boolean removed = false;
        for (IRemoveData rmd : this.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                if (rmd.removeData(PlayerName) == null) continue;
                removed = true;
                continue;
            }
            if (!(rmd instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)rmd)).getCheckType()) != checkType && !CheckTypeUtil.isAncestor(checkType, refType) || rmd.removeData(PlayerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    public void handleSystemTimeRanBackwards() {
        for (CheckType type : CheckTypeUtil.getWithDescendants(CheckType.ALL)) {
            Map<String, ExecutionHistory> map = this.executionHistories.get((Object)type);
            if (map == null) continue;
            map.clear();
        }
        for (IRemoveData rmd : this.iRemoveData) {
            if (rmd instanceof ICanHandleTimeRunningBackwards) {
                ((ICanHandleTimeRunningBackwards)((Object)rmd)).handleTimeRanBackwards();
                continue;
            }
            rmd.removeAllData();
        }
        ViolationHistory.clear(CheckType.ALL);
        Collection<Class<? extends IData>> dataTypes = this.factoryRegistry.getGroupedTypes(IData.class);
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().handleTimeRanBackwards(dataTypes);
        }
    }

    PlayerData getPlayerData(UUID playerId, String playerName, boolean create, IWorldData worldData) {
        PlayerData data = this.playerData.get(playerId);
        if (!create || data != null) {
            return data;
        }
        PlayerData newData = new PlayerData(playerId, playerName, this.permissionRegistry);
        PlayerData oldData = this.playerData.putIfAbsent(playerId, newData);
        PlayerData usedData = oldData == null ? newData : oldData;
        usedData.updateCurrentWorld(worldData == null ? this.worldDataManager.getDefaultWorldData() : worldData);
        return usedData;
    }

    @Override
    public PlayerData getPlayerData(Player player, boolean create) {
        try {
            return this.getPlayerData(player.getUniqueId(), player.getName(), create, create ? this.worldDataManager.getWorldDataSafe(player) : null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public PlayerData getPlayerData(Player player) {
        return this.getPlayerData(player, true);
    }

    @Override
    public PlayerData getPlayerData(String playerName) {
        UUID playerId = DataManager.getUUID(playerName);
        return playerId == null ? null : this.playerData.get(playerId);
    }

    @Override
    public PlayerData getPlayerData(UUID playerId) {
        return this.playerData.get(playerId);
    }

    @Override
    public Player getPlayerExact(String playerName) {
        return this.playerMap.getPlayerExact(playerName);
    }

    @Override
    public UUID getUUID(String input) {
        Player player = this.getPlayer(input);
        if (player != null) {
            return player.getUniqueId();
        }
        return IdUtil.UUIDFromStringSafe(input);
    }

    @Override
    public String getPlayerName(UUID playerId) {
        PlayerMap.PlayerInfo info = this.playerMap.getPlayerInfo(playerId);
        if (info != null && info.exactName != null) {
            return info.exactName;
        }
        PlayerData data = this.playerData.get(playerId);
        if (data != null) {
            return data.getPlayerName();
        }
        return null;
    }

    @Override
    public Player getPlayer(UUID id) {
        return this.playerMap.getPlayer(id);
    }

    @Override
    public Player getPlayer(String playerName) {
        return this.playerMap.getPlayer(playerName);
    }

    @Override
    public void restoreDefaultDebugFlags() {
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().resetDebug();
        }
    }

    @Override
    public void clearAllExemptions() {
        Iterator<Map.Entry<UUID, PlayerData>> it = this.playerData.iterator();
        while (it.hasNext()) {
            it.next().getValue().clearAllExemptions();
        }
    }

    @Override
    public <T> void removeGenericInstance(Class<T> registeredFor) {
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
            entry.getValue().removeGenericInstance(registeredFor);
        }
    }

    @Override
    public void clearData(CheckType checkType) {
        boolean hasSub;
        RichFactoryRegistry.CheckRemovalSpec removalSpec = new RichFactoryRegistry.CheckRemovalSpec(checkType, true, this);
        boolean hasComplete = !removalSpec.completeRemoval.isEmpty();
        boolean bl = hasSub = !removalSpec.subCheckRemoval.isEmpty();
        if (hasComplete || hasSub) {
            for (Map.Entry entry : this.playerData.iterable()) {
                IPlayerData pData = (IPlayerData)entry.getValue();
                if (hasComplete) {
                    pData.removeAllGenericInstances(removalSpec.completeRemoval);
                }
                if (!hasSub) continue;
                pData.removeSubCheckData(removalSpec.subCheckRemoval, removalSpec.checkTypes);
            }
        }
        for (IRemoveData iRemoveData : this.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                iRemoveData.removeAllData();
                continue;
            }
            if (!(iRemoveData instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)iRemoveData)).getCheckType()) != checkType && !CheckTypeUtil.isAncestor(checkType, refType)) continue;
            iRemoveData.removeAllData();
        }
        for (CheckType checkType2 : removalSpec.checkTypes) {
            Map<String, ExecutionHistory> map = this.executionHistories.get((Object)checkType2);
            if (map == null) continue;
            map.clear();
        }
        ViolationHistory.clear(checkType);
        if (checkType == CheckType.ALL) {
            this.bulkPlayerDataRemoval.addAll(this.playerData.getKeys());
            this.doBulkPlayerDataRemoval();
        }
    }

    public void registerExecutionHistory(CheckType type, Map<String, ExecutionHistory> histories) {
        this.executionHistories.put(type, histories);
    }

    public ExecutionHistory getExecutionHistory(CheckType type, String playerName) {
        Map<String, ExecutionHistory> map = this.executionHistories.get((Object)type);
        if (map != null) {
            return map.get(playerName);
        }
        return null;
    }

    public boolean removeExecutionHistory(CheckType type, String playerName) {
        boolean removed = false;
        for (CheckType refType : CheckTypeUtil.getWithDescendants(type)) {
            Map<String, ExecutionHistory> map = this.executionHistories.get((Object)refType);
            if (map == null || map.remove(playerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    public <T> void registerFactory(Class<T> registerFor, IFactoryOne<PlayerFactoryArgument, T> factory) {
        this.factoryRegistry.registerFactory(registerFor, factory);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType) {
        return this.factoryRegistry.getGroupedTypes(groupType);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType, CheckType checkType) {
        return this.factoryRegistry.getGroupedTypes(groupType, checkType);
    }

    @Override
    public <I> void addToGroups(Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(itemType, groupTypes);
    }

    @Override
    public <I> void addToGroups(CheckType checkType, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(checkType, itemType, groupTypes);
    }

    @Override
    public void addToExistingGroups(Class<?> itemType) {
        this.factoryRegistry.addToExistingGroups(itemType);
    }

    @Override
    public <I> void addToExistingGroups(CheckType checkType, Class<I> itemType) {
        this.factoryRegistry.addToExistingGroups(checkType, itemType);
    }

    @Override
    public <G> void createGroup(Class<G> groupType) {
        this.factoryRegistry.createGroup(groupType);
    }

    @Override
    public <G> void createAutoGroup(Class<G> groupType) {
        this.factoryRegistry.createAutoGroup(groupType);
    }

    @Override
    public <I> void addToGroups(Collection<CheckType> checkTypes, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(checkTypes, itemType, groupTypes);
    }

    @Override
    public <I> void addToExistingGroups(Collection<CheckType> checkTypes, Class<I> itemType) {
        this.factoryRegistry.addToExistingGroups(checkTypes, itemType);
    }

    @Override
    public <T> T getNewInstance(Class<T> registeredFor, PlayerFactoryArgument arg) {
        return this.factoryRegistry.getNewInstance(registeredFor, arg);
    }

    @Override
    public void removeCachedConfigs() {
        LinkedHashSet types = new LinkedHashSet(this.factoryRegistry.getGroupedTypes(IConfig.class));
        if (!types.isEmpty()) {
            for (Map.Entry<UUID, PlayerData> entry : this.playerData.iterable()) {
                entry.getValue().removeAllGenericInstances(types);
            }
        }
    }
}

