/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public class RegisteredPermission {
    private final Integer id;
    private final String stringRepresentation;
    private final String lowerCaseStringRepresentation;
    private final String description;
    private Permission bukkitPermission = null;

    public static final String toLowerCaseStringRepresentation(String stringRepresentation) {
        return stringRepresentation.toLowerCase(Locale.ENGLISH);
    }

    public RegisteredPermission(Integer id, String stringRepresentation) {
        this(id, stringRepresentation, null);
    }

    public RegisteredPermission(Integer id, String stringRepresentation, String description) {
        if (id == null) {
            throw new NullPointerException("Can't have a null id.");
        }
        if (stringRepresentation == null) {
            throw new NullPointerException("Can't have a null stringRepresentation.");
        }
        this.id = id;
        this.stringRepresentation = stringRepresentation;
        this.lowerCaseStringRepresentation = RegisteredPermission.toLowerCaseStringRepresentation(stringRepresentation);
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public String getLowerCaseStringRepresentation() {
        return this.lowerCaseStringRepresentation;
    }

    public String getDescription() {
        return this.description;
    }

    public Permission getBukkitPermission() {
        return this.bukkitPermission == null ? this.fetchBukkitPermission() : this.bukkitPermission;
    }

    private Permission fetchBukkitPermission() {
        PluginManager pm = Bukkit.getPluginManager();
        Permission permission = pm.getPermission(this.lowerCaseStringRepresentation);
        if (permission == null) {
            permission = new Permission(this.lowerCaseStringRepresentation, "Auto-generated permission (NoCheatPlus).", PermissionDefault.FALSE);
            pm.addPermission(permission);
        }
        return permission;
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Integer) {
            return this.id.intValue() == ((Integer)obj).intValue();
        }
        if (obj instanceof RegisteredPermission) {
            return this.id.intValue() == ((RegisteredPermission)obj).getId().intValue();
        }
        return false;
    }
}

