/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import fr.neatmonster.nocheatplus.components.registry.exception.AlreadyRegisteredException;
import fr.neatmonster.nocheatplus.components.registry.exception.NotRegisteredException;
import fr.neatmonster.nocheatplus.permissions.PermissionInfo;
import fr.neatmonster.nocheatplus.permissions.PermissionPolicy;
import fr.neatmonster.nocheatplus.permissions.PermissionSettings;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PermissionRegistry {
    private int nextId;
    private final Lock lock = new ReentrantLock();
    private PermissionSettings settings = new PermissionSettings(null, null, new PermissionPolicy());
    private final HashMapLOW<Integer, PermissionInfo> infosInt = new HashMapLOW(this.lock, 100);
    private final HashMapLOW<String, PermissionInfo> infosString = new HashMapLOW(this.lock, 100);
    private final LinkedHashSet<RegisteredPermission> preferKeepUpdated = new LinkedHashSet();
    private RegisteredPermission[] preferKeepUpdatedWorld = new RegisteredPermission[0];
    private RegisteredPermission[] preferKeepUpdatedOffline = new RegisteredPermission[0];

    public PermissionRegistry(int nextId) {
        this.nextId = nextId;
    }

    private PermissionInfo internalPut(RegisteredPermission registeredPermission) {
        PermissionInfo info = new PermissionInfo(registeredPermission);
        info.set(this.settings.getPermissionPolicy(registeredPermission));
        this.infosInt.put(registeredPermission.getId(), info);
        this.infosString.put(registeredPermission.getLowerCaseStringRepresentation(), info);
        return info;
    }

    public void addRegisteredPermission(RegisteredPermission registeredPermission) {
        this.lock.lock();
        if (this.infosString.containsKey(registeredPermission.getLowerCaseStringRepresentation())) {
            this.lock.unlock();
            throw new AlreadyRegisteredException("String representation already registered: " + registeredPermission.getLowerCaseStringRepresentation());
        }
        if (this.infosInt.containsKey(registeredPermission.getId())) {
            this.lock.unlock();
            throw new AlreadyRegisteredException("Id already registered: " + registeredPermission.getId());
        }
        this.internalPut(registeredPermission);
        this.lock.unlock();
    }

    public Integer getId(String stringRepresentation) {
        return this.getOrCreatePermissionInfo(stringRepresentation).getRegisteredPermission().getId();
    }

    public PermissionInfo getPermissionInfo(Integer id) {
        return this.infosInt.get(id);
    }

    public PermissionInfo getOrCreatePermissionInfo(String stringRepresentation) {
        PermissionInfo info = this.infosString.get(RegisteredPermission.toLowerCaseStringRepresentation(stringRepresentation));
        if (info == null) {
            RegisteredPermission registeredPermission;
            this.lock.lock();
            info = this.infosString.get(RegisteredPermission.toLowerCaseStringRepresentation(stringRepresentation));
            if (info != null) {
                this.lock.unlock();
                return info;
            }
            try {
                registeredPermission = new RegisteredPermission(this.nextId, stringRepresentation);
            }
            catch (NullPointerException e) {
                this.lock.unlock();
                throw e;
            }
            info = this.internalPut(registeredPermission);
            this.lock.unlock();
        }
        return info;
    }

    public RegisteredPermission getOrRegisterPermission(String stringRepresentation) {
        return this.getOrCreatePermissionInfo(stringRepresentation).getRegisteredPermission();
    }

    public Set<RegisteredPermission> updateSettings(PermissionSettings settings) {
        LinkedHashSet<RegisteredPermission> changed = new LinkedHashSet<RegisteredPermission>();
        this.lock.lock();
        this.settings = settings;
        this.lock.unlock();
        Iterator<Map.Entry<Integer, PermissionInfo>> it = this.infosInt.iterator();
        while (it.hasNext()) {
            PermissionPolicy newPolicy;
            PermissionInfo info = it.next().getValue();
            if (!info.isPolicyEquivalent(newPolicy = settings.getPermissionPolicy(info.getRegisteredPermission()))) {
                changed.add(info.getRegisteredPermission());
            }
            info.set(newPolicy);
        }
        this.arrangePreferKeepUpdated();
        return changed;
    }

    public void arrangePreferKeepUpdated() {
        LinkedList<RegisteredPermission> preferKeepUpdatedWorld = new LinkedList<RegisteredPermission>();
        LinkedList<RegisteredPermission> preferKeepUpdatedOffline = new LinkedList<RegisteredPermission>();
        block4: for (RegisteredPermission registeredPermission : this.preferKeepUpdated) {
            PermissionInfo info = this.infosInt.get(registeredPermission.getId());
            switch (info.fetchingPolicy()) {
                case FALSE: 
                case TRUE: {
                    continue block4;
                }
                case ALWAYS: 
                case INTERVAL: {
                    preferKeepUpdatedOffline.add(registeredPermission);
                    preferKeepUpdatedWorld.add(registeredPermission);
                    continue block4;
                }
            }
            if (info.invalidationOffline()) {
                preferKeepUpdatedOffline.add(registeredPermission);
                continue;
            }
            if (!info.invalidationWorld()) continue;
            preferKeepUpdatedOffline.add(registeredPermission);
            preferKeepUpdatedWorld.add(registeredPermission);
        }
        this.preferKeepUpdatedWorld = preferKeepUpdatedWorld.toArray(new RegisteredPermission[preferKeepUpdatedWorld.size()]);
        this.preferKeepUpdatedOffline = preferKeepUpdatedOffline.toArray(new RegisteredPermission[preferKeepUpdatedOffline.size()]);
    }

    public void preferKeepUpdated(RegisteredPermission ... registeredPermissions) {
        for (RegisteredPermission registeredPermission : registeredPermissions) {
            PermissionInfo info = this.infosInt.get(registeredPermission.getId());
            if (info == null) {
                throw new NotRegisteredException("Id not registered: " + registeredPermission.getId());
            }
            if (info.getRegisteredPermission() != registeredPermission) {
                throw new AlreadyRegisteredException("RegisteredPermission instances should be identical.");
            }
            this.preferKeepUpdated.add(info.getRegisteredPermission());
        }
    }

    public RegisteredPermission[] getPreferKeepUpdatedWorld() {
        return this.preferKeepUpdatedWorld;
    }

    public RegisteredPermission[] getPreferKeepUpdatedOffline() {
        return this.preferKeepUpdatedOffline;
    }
}

