/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.List;

public class PermissionPolicy {
    public static final int INVALIDATION_WORLD = 1;
    public static final int INVALIDATION_OFFLINE = 2;
    private FetchingPolicy fetchingPolicy = FetchingPolicy.ALWAYS;
    private long fetchingInterval = 0L;
    private int invalidationFlags = 3;

    public PermissionPolicy() {
    }

    public PermissionPolicy(PermissionPolicy bluePrint) {
        this.set(bluePrint);
    }

    public void set(PermissionPolicy bluePrint) {
        this.fetchingInterval = bluePrint.fetchingInterval;
        this.fetchingPolicy = bluePrint.fetchingPolicy;
        this.invalidationFlags = bluePrint.invalidationFlags;
    }

    public void fetchingPolicyInterval(long fetchingInterval) {
        this.fetchingInterval(fetchingInterval);
        this.fetchingPolicy(FetchingPolicy.INTERVAL);
    }

    public void fetchingPolicy(FetchingPolicy fetchingPolicy) {
        this.fetchingPolicy = fetchingPolicy;
    }

    public FetchingPolicy fetchingPolicy() {
        return this.fetchingPolicy;
    }

    public void fetchingInterval(long fetchingInterval) {
        if (fetchingInterval < 0L) {
            throw new IllegalArgumentException("The fetchingInterval must be greater than or equal to zero.");
        }
        this.fetchingInterval = fetchingInterval;
    }

    public long fetchingInterval() {
        return this.fetchingInterval;
    }

    private boolean hasFlag(int flag) {
        return (this.invalidationFlags & flag) != 0;
    }

    private void setFlag(int flag, boolean state) {
        this.invalidationFlags = state ? this.invalidationFlags | flag : this.invalidationFlags & ~flag;
    }

    public void invalidationWorld(boolean state) {
        this.setFlag(1, state);
    }

    public boolean invalidationWorld() {
        return this.hasFlag(1);
    }

    public void invalidationOffline(boolean state) {
        this.setFlag(2, state);
    }

    public boolean invalidationOffline() {
        return this.hasFlag(2);
    }

    public PermissionPolicy setPolicyFromConfigLine(String input) {
        FetchingPolicy fetchingPolicy;
        List<String> split = StringUtil.getNonEmpty(StringUtil.splitChars(input.trim(), ' ', ':', ','), true);
        long interval = 0L;
        String item = split.get(0).toUpperCase();
        String ref = FetchingPolicy.INTERVAL.name().toUpperCase();
        int flagIndex = 1;
        if (item.startsWith(ref)) {
            if (item.length() == ref.length()) {
                flagIndex = 2;
                if (split.size() < 2) {
                    throw new IllegalArgumentException("Must specify an interval in seconds.");
                }
                item = split.get(1).toUpperCase();
            } else {
                item = item.substring(ref.length()).trim();
            }
            try {
                interval = (long)(1000.0 * Double.parseDouble(item));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Must specify an interval in seconds.", e);
            }
            if (interval < 0L) {
                throw new IllegalArgumentException("Interval must be equal to or greater than zero.");
            }
            fetchingPolicy = FetchingPolicy.INTERVAL;
        } else {
            try {
                fetchingPolicy = FetchingPolicy.valueOf(item);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        boolean invalidateWorld = true;
        boolean invalidateOffline = true;
        for (int i = flagIndex; i < split.size(); ++i) {
            item = split.get(i).toLowerCase();
            boolean flag = true;
            if (item.charAt(0) == '+') {
                flag = true;
                item = item.substring(1);
            } else if (item.charAt(0) == '-') {
                flag = false;
                item = item.substring(1);
            }
            if (item.equals("world")) {
                invalidateWorld = flag;
                continue;
            }
            if (item.equals("offline")) {
                invalidateOffline = flag;
                continue;
            }
            throw new IllegalArgumentException("Bad flag name: " + item);
        }
        this.fetchingInterval(interval);
        this.fetchingPolicy(fetchingPolicy);
        this.invalidationWorld(invalidateWorld);
        this.invalidationOffline(invalidateOffline);
        return this;
    }

    public String policyToConfigLine() {
        return this.policyToConfigLine(true);
    }

    public String policyToConfigLine(boolean skipDefaults) {
        StringBuilder builder = new StringBuilder(124);
        builder.append(this.fetchingPolicy.name());
        if (this.fetchingPolicy == FetchingPolicy.INTERVAL) {
            builder.append(':');
            builder.append((double)this.fetchingInterval / 1000.0);
        }
        if (!skipDefaults || !this.invalidationOffline()) {
            builder.append("," + (this.invalidationOffline() ? "+" : "-") + "offline");
        }
        if (!skipDefaults || !this.invalidationWorld()) {
            builder.append("," + (this.invalidationWorld() ? "+" : "-") + "world");
        }
        return builder.toString();
    }

    public boolean isPolicyEquivalent(PermissionPolicy other) {
        return this.fetchingPolicy == other.fetchingPolicy && (this.fetchingPolicy != FetchingPolicy.INTERVAL || this.fetchingInterval == other.fetchingInterval) && this.invalidationFlags == other.invalidationFlags;
    }

    public static enum FetchingPolicy {
        TRUE,
        FALSE,
        ONCE,
        INTERVAL,
        ALWAYS;

    }
}

