/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.penalties;

import fr.neatmonster.nocheatplus.penalties.CancelPenalty;
import fr.neatmonster.nocheatplus.penalties.IPenalty;
import fr.neatmonster.nocheatplus.penalties.IPenaltyList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultPenaltyList
implements IPenaltyList {
    private boolean willCancel = false;
    private final Map<Class<?>, GenericNode<?>> penaltyMap = new LinkedHashMap();

    @Override
    public <RI> void addPenalty(Class<RI> registeredInput, IPenalty<RI> penalty) {
        if (penalty == CancelPenalty.CANCEL) {
            this.willCancel = true;
        } else {
            GenericNode<Object> node = this.penaltyMap.get(registeredInput);
            if (node == null) {
                node = new GenericNode();
                this.penaltyMap.put(registeredInput, node);
            }
            ((GenericNode)node).penalties.add(penalty);
        }
    }

    @Override
    public <RI, I extends RI> void applyPenaltiesPrecisely(Class<RI> type, I input, boolean removeAppliedPenalties) {
        GenericNode<?> node = this.penaltyMap.get(type);
        if (node != null && ((GenericNode)node).apply(input, removeAppliedPenalties) && removeAppliedPenalties) {
            this.penaltyMap.remove(type);
        }
    }

    @Override
    public <I> void applyAllApplicablePenalties(I input, boolean removeAppliedPenalties) {
        Class<?> inputClass = input.getClass();
        Iterator<Map.Entry<Class<?>, GenericNode<?>>> it = this.penaltyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class<?>, GenericNode<?>> entry = it.next();
            if (!entry.getKey().isAssignableFrom(inputClass) || !((GenericNode)entry.getValue()).apply(input, removeAppliedPenalties) || !removeAppliedPenalties) continue;
            it.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.penaltyMap.isEmpty();
    }

    @Override
    public boolean willCancel() {
        return this.willCancel;
    }

    private static class GenericNode<RI> {
        private final List<IPenalty<RI>> penalties = new LinkedList<IPenalty<RI>>();

        private GenericNode() {
        }

        private boolean apply(RI input, boolean removeAppliedPenalties) {
            Iterator<IPenalty<RI>> it = this.penalties.iterator();
            while (it.hasNext()) {
                if (!it.next().apply(input) || !removeAppliedPenalties) continue;
                it.remove();
            }
            return this.penalties.isEmpty();
        }
    }
}

