/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.debug;

import fr.neatmonster.nocheatplus.utilities.collision.tracing.ray.RayTracing;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.FakeBlockCache;

public class MapRecorder {
    public static void recordCuboid(BlockCache worldAccess, FakeBlockCache recorder, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = yMin; y <= yMax; ++y) {
                    if (recorder.hasIdEntry(x, y, z)) continue;
                    recorder.set(x, y, z, worldAccess.getType(x, y, z), worldAccess.getData(x, y, z), worldAccess.getBounds(x, y, z));
                }
            }
        }
    }

    public static void recordTrace(BlockCache worldAccess, FakeBlockCache recorder, double x0, double y0, double z0, double x1, double y1, double z1, int margin, int maxSteps) {
        TraceRecorder traceRecorder = new TraceRecorder(worldAccess, recorder, margin);
        traceRecorder.setMaxSteps(maxSteps);
        traceRecorder.set(x0, y0, z0, x1, y1, z1);
        traceRecorder.loop();
    }

    protected static class TraceRecorder
    extends RayTracing {
        private final BlockCache worldAccess;
        private final FakeBlockCache recorder;
        private final int margin;

        public TraceRecorder(BlockCache worldAccess, FakeBlockCache recorder, int margin) {
            this.worldAccess = worldAccess;
            this.recorder = recorder;
            this.margin = margin;
        }

        @Override
        protected boolean step(int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dT, boolean isPrimary) {
            if (this.margin > 0) {
                MapRecorder.recordCuboid(this.worldAccess, this.recorder, blockX - this.margin, blockY - this.margin, blockZ - this.margin, blockX + this.margin, blockY + this.margin, blockZ + this.margin);
            } else {
                this.recorder.set(blockX, blockY, blockZ, this.worldAccess.getType(blockX, blockY, blockZ), this.worldAccess.getData(blockX, blockY, blockZ), this.worldAccess.getBounds(blockX, blockY, blockZ));
            }
            return true;
        }
    }
}

