/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks.violationfrequency;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.IViolationInfo;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.hooks.IFirst;
import fr.neatmonster.nocheatplus.hooks.NCPHook;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.hooks.violationfrequency.ViolationFrequencyConfig;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ViolationFrequencyHook
implements NCPHook,
IFirst {
    private ViolationFrequencyConfig config;
    private Integer hookId = null;

    public void setConfig(ViolationFrequencyConfig config) {
        this.config = config;
        if (config == null || !config.active) {
            this.unregister();
        } else {
            this.register();
        }
    }

    public void unregister() {
        if (this.hookId != null) {
            NCPHookManager.removeHook(this);
            this.hookId = null;
        }
    }

    public void register() {
        this.unregister();
        this.hookId = NCPHookManager.addHook(CheckType.MOVING_SURVIVALFLY, (NCPHook)this);
    }

    @Override
    public String getHookName() {
        return "ViolationFrequency(NCP)";
    }

    @Override
    public String getHookVersion() {
        return "1.1";
    }

    @Override
    public boolean onCheckFailure(CheckType checkType, Player player, IViolationInfo info) {
        ViolationFrequencyConfig config = this.config;
        StringBuilder builder = new StringBuilder(300);
        if (info.getTotalVl() > (double)config.maxThresholdVL) {
            return false;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData != null) {
            MovingData data = pData.getGenericInstance(MovingData.class);
            if (info.getAddedVl() > (double)config.noAdditionVL) {
                if (config.debug) {
                    builder.append("SurvivalFly: ");
                    builder.append("VL=" + StringUtil.fdec1.format(info.getTotalVl()));
                    builder.append("(+" + StringUtil.fdec1.format(info.getAddedVl()) + ")");
                    this.log(builder.toString(), player);
                }
                return true;
            }
            int lastViolatedMoveCount = data.getPlayerMoveCount() - data.sfVLMoveCount;
            if (lastViolatedMoveCount <= config.lastViolatedMoveCount) {
                data.survivalFlyVL += (double)config.amountToAdd;
                if (config.debug) {
                    builder.append("SurvivalFly: ");
                    builder.append("VL=" + StringUtil.fdec1.format(info.getTotalVl()));
                    builder.append("(+" + StringUtil.fdec1.format(info.getAddedVl()) + ") -> ");
                    builder.append("VL=" + StringUtil.fdec1.format(info.getTotalVl() + (double)config.amountToAdd));
                    builder.append("(+" + StringUtil.fdec1.format(info.getAddedVl() + (double)config.amountToAdd) + ")");
                    this.log(builder.toString(), player);
                }
                return info.getTotalVl() + (double)config.amountToAdd <= (double)config.maxThresholdVL;
            }
            if (config.debug) {
                builder.append("SurvivalFly: ");
                builder.append("VL=" + StringUtil.fdec1.format(info.getTotalVl()));
                builder.append("(+" + StringUtil.fdec1.format(info.getAddedVl()) + ")");
                this.log(builder.toString(), player);
            }
            return true;
        }
        return false;
    }

    private void log(String s, Player p) {
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        StringBuilder builder = new StringBuilder(300);
        builder.append("ViolationFrequency");
        builder.append(" [" + ChatColor.YELLOW + p.getName());
        builder.append(ChatColor.WHITE + "] ");
        builder.append(s);
        String message = builder.toString();
        logManager.info(Streams.NOTIFY_INGAME, message);
    }
}

