/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.access.IViolationInfo;
import fr.neatmonster.nocheatplus.hooks.IFirst;
import fr.neatmonster.nocheatplus.hooks.ILast;
import fr.neatmonster.nocheatplus.hooks.IStats;
import fr.neatmonster.nocheatplus.hooks.NCPHook;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

public final class NCPHookManager {
    private static int maxHookId = 0;
    private static final Map<Integer, NCPHook> allHooks = new HashMap<Integer, NCPHook>();
    private static final Map<CheckType, List<NCPHook>> hooksByChecks = new HashMap<CheckType, List<NCPHook>>();
    private static Comparator<NCPHook> HookComparator = new Comparator<NCPHook>(){

        @Override
        public int compare(NCPHook o1, NCPHook o2) {
            boolean s1 = o1 instanceof IStats;
            boolean f1 = o1 instanceof IFirst;
            boolean l1 = o1 instanceof ILast;
            boolean s2 = o2 instanceof IStats;
            boolean f2 = o2 instanceof IFirst;
            boolean l2 = o2 instanceof ILast;
            if (s1 && !s2) {
                return l1 ? 1 : -1;
            }
            if (!s1 && s2) {
                return l2 ? -1 : 1;
            }
            if (l2) {
                return -1;
            }
            if (l1) {
                return 1;
            }
            if (f1) {
                return -1;
            }
            if (f2) {
                return 1;
            }
            return 0;
        }
    };

    public static Integer addHook(CheckType checkType, NCPHook hook) {
        Integer hookId = NCPHookManager.getId(hook);
        NCPHookManager.addToMappings(checkType, hook);
        NCPHookManager.logHookAdded(hook);
        return hookId;
    }

    public static Integer addHook(CheckType[] checkTypes, NCPHook hook) {
        if (checkTypes == null) {
            checkTypes = new CheckType[]{CheckType.ALL};
        }
        Integer hookId = NCPHookManager.getId(hook);
        for (CheckType checkType : checkTypes) {
            NCPHookManager.addToMappings(checkType, hook);
        }
        NCPHookManager.logHookAdded(hook);
        return hookId;
    }

    private static void addToMapping(CheckType checkType, NCPHook hook) {
        List<NCPHook> hooks = hooksByChecks.get((Object)checkType);
        if (!hooks.contains(hook)) {
            if (!(hook instanceof ILast) && (hook instanceof IStats || hook instanceof IFirst)) {
                hooks.add(0, hook);
            } else {
                hooks.add(hook);
            }
            Collections.sort(hooks, HookComparator);
        }
    }

    private static void addToMappings(CheckType checkType, NCPHook hook) {
        for (CheckType refType : CheckTypeUtil.getWithDescendants(checkType)) {
            NCPHookManager.addToMapping(refType, hook);
        }
    }

    private static final boolean applyHooks(CheckType checkType, Player player, IViolationInfo info, List<NCPHook> hooks) {
        for (int i = 0; i < hooks.size(); ++i) {
            NCPHook hook = hooks.get(i);
            try {
                if (!hook.onCheckFailure(checkType, player, info) || hook instanceof IStats) continue;
                return true;
            }
            catch (Throwable t) {
                NCPHookManager.logHookFailure(checkType, player, hook, t);
            }
        }
        return false;
    }

    public static Collection<NCPHook> getAllHooks() {
        LinkedList<NCPHook> hooks = new LinkedList<NCPHook>();
        hooks.addAll(allHooks.values());
        return hooks;
    }

    private static final String getHookDescription(NCPHook hook) {
        return hook.getHookName() + " [" + hook.getHookVersion() + "]";
    }

    public static Collection<NCPHook> getHooksByName(String hookName) {
        LinkedList<NCPHook> hooks = new LinkedList<NCPHook>();
        for (Integer refId : allHooks.keySet()) {
            NCPHook hook = allHooks.get(refId);
            if (!hook.getHookName().equals(hookName) || hooks.contains(hook)) continue;
            hooks.add(hook);
        }
        return hooks;
    }

    private static Integer getId(NCPHook hook) {
        if (hook == null) {
            throw new NullPointerException("Hooks must not be null.");
        }
        Integer id = null;
        for (Integer refId : allHooks.keySet()) {
            if (hook != allHooks.get(refId)) continue;
            id = refId;
            break;
        }
        if (id == null) {
            id = NCPHookManager.getNewHookId();
            allHooks.put(id, hook);
        }
        return id;
    }

    private static Integer getNewHookId() {
        return ++maxHookId;
    }

    private static final void logHookAdded(NCPHook hook) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Added hook: " + NCPHookManager.getHookDescription(hook) + ".");
    }

    private static final void logHookFailure(CheckType checkType, Player player, NCPHook hook, Throwable t) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append("Hook " + NCPHookManager.getHookDescription(hook) + " encountered an unexpected exception:\n");
        builder.append("Processing: ");
        if (checkType.getParent() != null) {
            builder.append("Parent " + (Object)((Object)checkType.getParent()) + " ");
        }
        builder.append("Check " + (Object)((Object)checkType));
        builder.append(" Player " + player.getName());
        builder.append("\n");
        builder.append("Exception (" + t.getClass().getSimpleName() + "): " + t.getMessage() + "\n");
        for (StackTraceElement el : t.getStackTrace()) {
            builder.append(el.toString());
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, builder.toString());
    }

    private static final void logHookRemoved(NCPHook hook) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Removed hook: " + NCPHookManager.getHookDescription(hook) + ".");
    }

    public static Collection<NCPHook> removeAllHooks() {
        Collection<NCPHook> hooks = NCPHookManager.getAllHooks();
        for (NCPHook hook : hooks) {
            NCPHookManager.removeHook(hook);
        }
        return hooks;
    }

    private static void removeFromMappings(NCPHook hook, Integer hookId) {
        allHooks.remove(hookId);
        for (CheckType checkId : hooksByChecks.keySet()) {
            hooksByChecks.get((Object)checkId).remove(hook);
        }
    }

    public static NCPHook removeHook(Integer hookId) {
        NCPHook hook = allHooks.get(hookId);
        if (hook == null) {
            return null;
        }
        NCPHookManager.removeFromMappings(hook, hookId);
        NCPHookManager.logHookRemoved(hook);
        return hook;
    }

    public static Integer removeHook(NCPHook hook) {
        Integer hookId = null;
        for (Integer refId : allHooks.keySet()) {
            if (hook != allHooks.get(refId)) continue;
            hookId = refId;
            break;
        }
        if (hookId == null) {
            return null;
        }
        NCPHookManager.removeFromMappings(hook, hookId);
        NCPHookManager.logHookRemoved(hook);
        return hookId;
    }

    public static Set<Integer> removeHooks(Collection<NCPHook> hooks) {
        LinkedHashSet<Integer> ids = new LinkedHashSet<Integer>();
        for (NCPHook hook : hooks) {
            Integer id = NCPHookManager.removeHook(hook);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public static Collection<NCPHook> removeHooks(String hookName) {
        Collection<NCPHook> hooks = NCPHookManager.getHooksByName(hookName);
        if (hooks.isEmpty()) {
            return null;
        }
        NCPHookManager.removeHooks(hooks);
        return hooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean shouldCancelVLProcessing(ViolationData violationData) {
        CheckType type = violationData.check.getType();
        List<NCPHook> hooksCheck = hooksByChecks.get((Object)type);
        if (!hooksCheck.isEmpty()) {
            if (CheckTypeUtil.needsSynchronization(type)) {
                List<NCPHook> list = hooksCheck;
                synchronized (list) {
                    return NCPHookManager.applyHooks(type, violationData.player, violationData, hooksCheck);
                }
            }
            return NCPHookManager.applyHooks(type, violationData.player, violationData, hooksCheck);
        }
        return false;
    }

    static {
        for (CheckType type : CheckType.values()) {
            if (CheckTypeUtil.needsSynchronization(type)) {
                hooksByChecks.put(type, Collections.synchronizedList(new ArrayList()));
                continue;
            }
            hooksByChecks.put(type, new ArrayList());
        }
    }
}

