/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.ExemptionSettings;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class NCPExemptionManager {
    private static ExemptionSettings settings = new ExemptionSettings();

    public static ExemptionSettings getExemptionSettings() {
        return settings;
    }

    public static void setExemptionSettings(ExemptionSettings settings) {
        NCPExemptionManager.settings = settings;
        NCPAPIProvider.getNoCheatPlusAPI().registerGenericInstance(ExemptionSettings.class, settings);
    }

    public static final void clear() {
        DataManager.clearAllExemptions();
    }

    public static final void exemptPermanently(UUID id) {
        NCPExemptionManager.exemptPermanently(id, CheckType.ALL);
    }

    public static final void exemptPermanently(UUID id, CheckType checkType) {
        IPlayerData data = DataManager.getPlayerData(id);
        if (data != null) {
            data.exempt(checkType);
        }
    }

    public static final void exemptPermanently(Player player) {
        NCPExemptionManager.exemptPermanently(player, CheckType.ALL);
    }

    public static final void exemptPermanently(Player player, CheckType checkType) {
        NCPExemptionManager.exemptPermanently(player.getUniqueId(), checkType);
    }

    public static final boolean isExempted(UUID id, CheckType checkType) {
        IPlayerData data = DataManager.getPlayerData(id);
        return data != null && data.isExempted(checkType);
    }

    public static final boolean isExempted(Player player, CheckType checkType) {
        return NCPExemptionManager.isExempted(player.getUniqueId(), checkType) || settings.isExemptedBySettings((Entity)player);
    }

    @Deprecated
    public static final boolean isExempted(Player player, CheckType checkType, boolean isPrimaryThread) {
        return NCPExemptionManager.isExempted(player, checkType);
    }

    public static final void unexempt(UUID id) {
        NCPExemptionManager.unexempt(id, CheckType.ALL);
    }

    public static final void unexempt(UUID id, CheckType checkType) {
        IPlayerData data = DataManager.getPlayerData(id);
        if (data != null) {
            data.unexempt(checkType);
        }
    }

    public static final void unexempt(Player player) {
        NCPExemptionManager.unexempt(player, CheckType.ALL);
    }

    public static final void unexempt(Player player, CheckType checkType) {
        NCPExemptionManager.unexempt(player.getUniqueId(), checkType);
    }
}

