/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event.mini;

import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.components.registry.order.IGetRegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class MiniListenerNode<E, P> {
    protected final SortListenerEntry<E> typedSort = new SortListenerEntry();
    protected final List<ListenerEntry<E>> registeredListeners = new ArrayList<ListenerEntry<E>>();
    protected ListenerEntry<E>[] sortedListeners = new ListenerEntry[0];
    protected final Class<E> baseType;
    protected final P basePriority;

    public MiniListenerNode(Class<E> baseType, P basePriority) {
        this.baseType = baseType;
        this.basePriority = basePriority;
    }

    public void clear() {
        this.registeredListeners.clear();
        this.sortedListeners = new ListenerEntry[0];
    }

    public void removeMiniListener(MiniListener<E> listener) {
        boolean changed = false;
        Iterator<ListenerEntry<E>> it = this.registeredListeners.iterator();
        while (it.hasNext()) {
            if (it.next().listener != listener) continue;
            it.remove();
            changed = true;
            break;
        }
        if (changed) {
            this.generateSortedListeners();
        }
    }

    public void addMiniListener(MiniListener<E> listener, boolean ignoreCancelled, RegistrationOrder order) {
        this.registeredListeners.add(new ListenerEntry<E>(listener, ignoreCancelled, order));
        this.generateSortedListeners();
    }

    protected void generateSortedListeners() {
        if (this.registeredListeners.isEmpty()) {
            this.clear();
        } else {
            ListenerEntry<E>[] sortedOdd = this.typedSort.getSortedArray(this.registeredListeners);
            ListenerEntry[] sortedListeners = new ListenerEntry[sortedOdd.length];
            System.arraycopy(sortedOdd, 0, sortedListeners, 0, sortedOdd.length);
            this.sortedListeners = sortedListeners;
        }
    }

    protected boolean isCancelled(E event) {
        return false;
    }

    public void onEvent(E event) {
        ListenerEntry<E>[] listeners = this.sortedListeners;
        for (int i = 0; i < listeners.length; ++i) {
            ListenerEntry<E> entry = listeners[i];
            if (entry.ignoreCancelled && this.isCancelled(event)) continue;
            try {
                entry.listener.onEvent(event);
                continue;
            }
            catch (Throwable t) {
                this.logListenerException(entry, i, listeners.length, event, t);
            }
        }
    }

    private void logListenerException(ListenerEntry<E> entry, int index, int length, E event, Throwable t) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(" Details:");
        builder.append(" listenerType=" + entry.listener.getClass().getName());
        builder.append(" listenerOrder=" + ((ListenerEntry)entry).order);
        builder.append(" listenerIndex=" + index + "/" + length);
        if (entry.listener instanceof ComponentWithName) {
            builder.append(" listenerName=");
            builder.append(((ComponentWithName)((Object)entry.listener)).getComponentName());
        }
        builder.append("\n exception:\n");
        builder.append(StringUtil.throwableToString(t));
        HashSet<Throwable> done = new HashSet<Throwable>();
        done.add(t);
        Throwable cause = t.getCause();
        while (cause != null && !done.contains(cause)) {
            done.add(cause);
            builder.append("\n caused by:\n");
            builder.append(StringUtil.throwableToString(cause));
            cause = t.getCause();
        }
        StaticLog.logOnce(Streams.STATUS, Level.SEVERE, "Listener exception: baseType=" + this.baseType.getName() + " basePriority=" + this.basePriority + " eventType=" + event.getClass().getName(), builder.toString());
    }

    protected static final class SortListenerEntry<E>
    extends RegistrationOrder.AbstractRegistrationOrderSort<ListenerEntry<E>> {
        protected SortListenerEntry() {
        }

        @Override
        protected RegistrationOrder fetchRegistrationOrder(ListenerEntry<E> item) {
            return item.getRegistrationOrder();
        }
    }

    protected static class ListenerEntry<E>
    implements IGetRegistrationOrder {
        public final MiniListener<E> listener;
        public final boolean ignoreCancelled;
        private final RegistrationOrder order;

        public ListenerEntry(MiniListener<E> listener, boolean ignoreCancelled, RegistrationOrder order) {
            this.listener = listener;
            this.ignoreCancelled = ignoreCancelled;
            this.order = order == null ? new RegistrationOrder() : new RegistrationOrder(order);
        }

        @Override
        public RegistrationOrder getRegistrationOrder() {
            return this.order;
        }
    }
}

