/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.config.ConfPaths;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.GlobalConfig;
import fr.neatmonster.nocheatplus.config.Moved;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.CharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;

public class PathUtils {
    private static final Set<String> deprecatedFields = new LinkedHashSet<String>();
    private static final SimpleCharPrefixTree deprecatedPrefixes = new SimpleCharPrefixTree();
    private static final Set<String> globalOnlyFields = new HashSet<String>();
    private static final SimpleCharPrefixTree globalOnlyPrefixes = new SimpleCharPrefixTree();
    private static final Map<String, WrapMoved> movedPaths = new LinkedHashMap<String, WrapMoved>();

    private static void initPaths() {
        deprecatedFields.clear();
        deprecatedPrefixes.clear();
        globalOnlyFields.clear();
        globalOnlyPrefixes.clear();
        movedPaths.clear();
        for (WrapMoved moved : ConfPaths.getExtraMovedPaths()) {
            movedPaths.put(moved.oldPath, moved);
        }
        for (Field field : ConfPaths.class.getDeclaredFields()) {
            if (field.getType() != String.class) continue;
            String fieldName = field.getName();
            PathUtils.checkAddPrefixes(field, fieldName, GlobalConfig.class, globalOnlyFields, globalOnlyPrefixes);
            PathUtils.checkAddPrefixes(field, fieldName, Deprecated.class, deprecatedFields, deprecatedPrefixes);
            if (!field.isAnnotationPresent(Moved.class)) continue;
            PathUtils.addMoved(field, field.getAnnotation(Moved.class));
        }
    }

    private static void checkAddPrefixes(Field field, String fieldName, Class<? extends Annotation> annotation, Set<String> fieldNames, SimpleCharPrefixTree pathPrefixes) {
        if (field.isAnnotationPresent(annotation)) {
            fieldNames.add(fieldName);
            PathUtils.addPrefixesField(field, pathPrefixes);
        } else {
            for (String refName : fieldNames) {
                if (!fieldName.startsWith(refName)) continue;
                PathUtils.addPrefixesField(field, pathPrefixes);
            }
        }
    }

    private static void addPrefixesField(Field field, SimpleCharPrefixTree pathPrefixes) {
        try {
            String path = field.get(null).toString();
            if (path != null) {
                pathPrefixes.feed(path);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void addMoved(Field field, Moved rel) {
        try {
            String path = field.get(null).toString();
            movedPaths.put(path, new WrapMoved(path, rel));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected static void warnPaths(ConfigurationSection config, CharPrefixTree<?, ?> paths, String msgPrefix, Set<String> warnedPaths) {
        for (String path : config.getKeys(true)) {
            if (!paths.hasPrefix(path)) continue;
            StaticLog.logWarning("Config path '" + path + "'" + msgPrefix);
            if (warnedPaths == null) continue;
            warnedPaths.add(path);
        }
    }

    public static void processPaths(File file, String configName, boolean isWorldConfig) {
        ConfigFile config = new ConfigFile();
        try {
            config.load(file);
            ConfigFile newConfig = PathUtils.processPaths(config, configName, isWorldConfig);
            if (newConfig != null) {
                config = newConfig;
                try {
                    config.save(file);
                }
                catch (Throwable t) {
                    StaticLog.logSevere("Failed to save configuration (" + configName + ") with changes: " + t.getClass().getSimpleName());
                    StaticLog.logSevere(t);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    public static ConfigFile processPaths(ConfigFile config, String configName, boolean isWorldConfig) {
        LinkedHashSet<String> removePaths = new LinkedHashSet<String>();
        LinkedHashMap<String, Object> addPaths = new LinkedHashMap<String, Object>();
        if (isWorldConfig) {
            PathUtils.processGlobalOnlyPaths((ConfigurationSection)config, configName, null);
        }
        PathUtils.processDeprecatedPaths((ConfigurationSection)config, configName, removePaths);
        PathUtils.processMovedPaths((ConfigurationSection)config, configName, removePaths, addPaths);
        boolean changed = false;
        if (!removePaths.isEmpty()) {
            config = PathUtils.removePaths(config, removePaths);
            changed = true;
        }
        if (!addPaths.isEmpty()) {
            PathUtils.setPaths((ConfigurationSection)config, addPaths, false);
            changed = true;
        }
        if (changed) {
            return config;
        }
        return null;
    }

    public static void setPaths(ConfigurationSection config, Map<String, Object> setPaths, boolean override) {
        PathUtils.setPaths(config, setPaths, "", override);
    }

    protected static void setPaths(ConfigurationSection config, Map<String, Object> setPaths, String pathPrefix, boolean override) {
        for (Map.Entry<String, Object> entry : setPaths.entrySet()) {
            String path = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                PathUtils.setPaths(config, ((ConfigurationSection)value).getValues(true), pathPrefix + path + ".", override);
                continue;
            }
            if (!override && config.contains(path)) continue;
            config.set(pathPrefix + path, value);
        }
    }

    public static ConfigFile removePaths(ConfigFile config, Collection<String> removePaths) {
        SimpleCharPrefixTree prefixes = new SimpleCharPrefixTree();
        for (String path : removePaths) {
            prefixes.feed(path);
        }
        ConfigFile newConfig = new ConfigFile();
        for (Map.Entry entry : config.getValues(true).entrySet()) {
            String path = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection || prefixes.hasPrefix(path)) continue;
            newConfig.set(path, value);
        }
        return newConfig;
    }

    protected static void processMovedPaths(ConfigurationSection config, String configName, Set<String> removePaths, Map<String, Object> addPaths) {
        for (Map.Entry<String, WrapMoved> entry : movedPaths.entrySet()) {
            String to;
            String path = entry.getKey();
            Object value = config.get(path);
            if (!config.contains(path)) continue;
            WrapMoved moved = entry.getValue();
            if (deprecatedPrefixes.hasPrefix(moved.oldPath) || value instanceof ConfigurationSection && !moved.configurationSection) continue;
            String newPath = moved.newPath;
            if (newPath == null || newPath.isEmpty()) {
                to = ".";
            } else {
                to = " to '" + newPath + "'.";
                addPaths.put(newPath, value);
                removePaths.add(path);
            }
            StaticLog.logWarning("Config path '" + path + "' (" + configName + ") has been moved" + to);
        }
    }

    protected static void processDeprecatedPaths(ConfigurationSection config, String configName, Set<String> removePaths) {
        PathUtils.warnPaths(config, deprecatedPrefixes, " (" + configName + ") is not in use anymore.", removePaths);
    }

    protected static void processGlobalOnlyPaths(ConfigurationSection config, String configName, Set<String> removePaths) {
        PathUtils.warnPaths(config, globalOnlyPrefixes, " (" + configName + ") should only be set in the global configuration.", removePaths);
    }

    public static MemoryConfiguration getWorldsDefaultConfig(MemoryConfiguration defaultConfig) {
        char sep = defaultConfig.options().pathSeparator();
        ConfigFile config = new ConfigFile();
        config.options().pathSeparator(sep);
        Map defaults = defaultConfig.getValues(false);
        for (Map.Entry entry : defaults.entrySet()) {
            String part = (String)entry.getKey();
            if (!part.isEmpty() && !PathUtils.mayBeInWorldConfig(part)) continue;
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                PathUtils.addWorldConfigSection((ConfigurationSection)config, (ConfigurationSection)value, part, sep);
                continue;
            }
            config.set(part, value);
        }
        return config;
    }

    protected static void addWorldConfigSection(ConfigurationSection config, ConfigurationSection section, String path, char sep) {
        Map values = section.getValues(false);
        for (Map.Entry entry : values.entrySet()) {
            String fullPath = path + sep + (String)entry.getKey();
            if (!PathUtils.mayBeInWorldConfig(fullPath)) continue;
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                PathUtils.addWorldConfigSection(config, (ConfigurationSection)value, fullPath, sep);
                continue;
            }
            config.set(fullPath, value);
        }
    }

    public static boolean mayBeInWorldConfig(String path) {
        if (globalOnlyPrefixes.hasPrefix(path)) {
            return false;
        }
        return PathUtils.mayBeInConfig(path);
    }

    public static boolean mayBeInConfig(String path) {
        if (deprecatedPrefixes.hasPrefix(path)) {
            return false;
        }
        return !movedPaths.containsKey(path);
    }

    static {
        PathUtils.initPaths();
    }

    public static class WrapMoved {
        public final String oldPath;
        public final String newPath;
        public final boolean configurationSection;

        public WrapMoved(String oldPath, Moved moved) {
            this(oldPath, moved.newPath(), moved.configurationSection());
        }

        public WrapMoved(String oldPath, String newPath) {
            this(oldPath, newPath, false);
        }

        public WrapMoved(String oldPath, String newPath, boolean configurationSection) {
            this.oldPath = oldPath;
            this.newPath = newPath;
            this.configurationSection = configurationSection;
        }
    }

    public static class ManyMoved {
        public final String sectionPrefix;
        public final Set<String> subKeys;
        public final String oldSuffix;
        public final String newSuffix;
        public final boolean configurationSection;

        public ManyMoved(String rootSection, Collection<String> subKeys, String oldSuffix, String newSuffix) {
            this(rootSection, subKeys, oldSuffix, newSuffix, false);
        }

        public ManyMoved(String sectionPrefix, Collection<String> subKeys, String oldSuffix, String newSuffix, boolean configurationSection) {
            this.sectionPrefix = sectionPrefix;
            this.subKeys = new LinkedHashSet<String>(subKeys);
            this.oldSuffix = oldSuffix;
            this.newSuffix = newSuffix;
            this.configurationSection = configurationSection;
        }

        public Collection<WrapMoved> getWrapMoved() {
            LinkedList<WrapMoved> entries = new LinkedList<WrapMoved>();
            for (String key : this.subKeys) {
                String prefix = this.sectionPrefix + key + ".";
                entries.add(new WrapMoved(prefix + this.oldSuffix, prefix + this.newSuffix, this.configurationSection));
            }
            return entries;
        }
    }
}

