/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.DefaultConfig;
import fr.neatmonster.nocheatplus.config.PathUtils;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import fr.neatmonster.nocheatplus.worlds.WorldDataManager;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private static final WorldConfigProvider<ConfigFile> worldConfigProvider = new WorldConfigProvider<ConfigFile>(){

        @Override
        public ConfigFile getDefaultConfig() {
            return ConfigManager.getConfigFile();
        }

        @Override
        public ConfigFile getConfig(String worldName) {
            return ConfigManager.getConfigFile(worldName);
        }

        @Override
        public Collection<ConfigFile> getAllConfigs() {
            LinkedHashSet<ConfigFile> res = new LinkedHashSet<ConfigFile>();
            IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
            Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
            while (it.hasNext()) {
                res.add(it.next().getValue().getRawConfiguration());
            }
            return res;
        }
    };
    private static boolean isInitialized = false;

    public static WorldConfigProvider<ConfigFile> getWorldConfigProvider() {
        return worldConfigProvider;
    }

    public static void cleanup() {
        isInitialized = false;
    }

    public static ConfigFile getConfigFile() {
        return NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().getDefaultWorldData().getRawConfiguration();
    }

    public static ConfigFile getConfigFile(String worldName) {
        return NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().getDefaultWorldData().getRawConfiguration();
    }

    public static synchronized void init(Plugin plugin, WorldDataManager worldDataManager) {
        LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>();
        File globalFile = new File(plugin.getDataFolder(), "config.yml");
        DefaultConfig defaultConfig = new DefaultConfig();
        int maxBuildContained = defaultConfig.getMaxLastChangedBuildNumber();
        PathUtils.processPaths(globalFile, "global config", false);
        ConfigFile globalConfig = new ConfigFile();
        globalConfig.setDefaults((Configuration)defaultConfig);
        globalConfig.options().copyDefaults(true);
        if (globalFile.exists()) {
            try {
                globalConfig.load(globalFile);
                try {
                    if (globalConfig.getBoolean("saveback-config")) {
                        boolean overrideCreated = false;
                        if (!globalConfig.contains("config-version.created")) {
                            overrideCreated = true;
                        }
                        if (!overrideCreated && globalConfig.getInt("config-version.created", 0) >= 0 && ConfigManager.isConfigUpToDate(globalConfig, 0) == null) {
                            overrideCreated = true;
                        }
                        globalConfig.set("config-version.saved", maxBuildContained);
                        if (overrideCreated) {
                            globalConfig.set("config-version.created", maxBuildContained);
                        }
                        globalConfig.save(globalFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Could not save back config.yml (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Could not load config.yml (see exception below). Continue with default settings...");
                StaticLog.logSevere(e);
            }
        } else {
            globalConfig.options().header("This configuration was auto-generated by NoCheatPlus.");
            globalConfig.options().copyHeader(true);
            try {
                globalConfig.set("config-version.created", maxBuildContained);
                globalConfig.set("config-version.saved", maxBuildContained);
                globalConfig.save(globalFile);
            }
            catch (Exception e) {
                StaticLog.logSevere(e);
            }
        }
        newWorldsMap.put(null, globalConfig);
        MemoryConfiguration worldDefaults = PathUtils.getWorldsDefaultConfig((MemoryConfiguration)globalConfig);
        HashMap<String, Object> worldFiles = new HashMap<String, Object>();
        if (plugin.getDataFolder().isDirectory()) {
            for (File file : plugin.getDataFolder().listFiles()) {
                String fileName;
                if (!file.isFile() || !(fileName = file.getName()).matches(".+_config.yml$")) continue;
                String worldname = fileName.substring(0, fileName.length() - 11);
                worldFiles.put(worldname, file);
            }
        }
        for (Map.Entry entry : worldFiles.entrySet()) {
            File worldFile = (File)entry.getValue();
            PathUtils.processPaths(worldFile, "world " + (String)entry.getKey(), true);
            ConfigFile worldConfig = new ConfigFile();
            worldConfig.setDefaults((Configuration)worldDefaults);
            worldConfig.options().copyDefaults(true);
            try {
                worldConfig.load(worldFile);
                newWorldsMap.put((String)entry.getKey(), worldConfig);
                try {
                    if (worldConfig.getBoolean("saveback-config")) {
                        worldConfig.save(worldFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Couldn't save back world-specific configuration for " + (String)entry.getKey() + " (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Couldn't load world-specific configuration for " + (String)entry.getKey() + " (see exception below). Continue with global default settings...");
                StaticLog.logSevere(e);
            }
            worldConfig.setDefaults((Configuration)globalConfig);
            worldConfig.options().copyDefaults(true);
        }
        worldDataManager.applyConfiguration(newWorldsMap);
        isInitialized = true;
    }

    @Deprecated
    public static String isConfigUpToDate(ConfigFile globalConfig) {
        return ConfigManager.isConfigUpToDate(globalConfig, -1);
    }

    public static String isConfigUpToDate(ConfigFile globalConfig, int maxPaths) {
        Object created_o = globalConfig.get("config-version.created");
        int buildCreated = -1;
        if (created_o != null && created_o instanceof Integer) {
            buildCreated = (Integer)created_o;
        }
        if (buildCreated < 0) {
            return null;
        }
        DefaultConfig defaultConfig = new DefaultConfig();
        int maxBuildContained = defaultConfig.getMaxLastChangedBuildNumber();
        int currentBuild = BuildParameters.buildNumber;
        if (currentBuild != Integer.MIN_VALUE && buildCreated > Math.max(maxBuildContained, currentBuild)) {
            return "Your configuration seems to be created by a newer plugin version.\nSome settings could have changed, you should regenerate it!";
        }
        LinkedList<String> problems = new LinkedList<String>();
        Map<String, Integer> lastChangedBuildNumbers = defaultConfig.getLastChangedBuildNumbers();
        for (Map.Entry<String, Integer> entry : lastChangedBuildNumbers.entrySet()) {
            int defaultBuild = entry.getValue();
            if (defaultBuild <= buildCreated) continue;
            String path = entry.getKey();
            Object defaultValue = defaultConfig.get(path);
            if (defaultValue instanceof ConfigurationSection) {
                problems.add(path + (maxPaths >= 0 ? "" : " - Changed with build " + defaultBuild + ", can not handle entire configuration sections yet. "));
                continue;
            }
            Object currentValue = globalConfig.get(path);
            if (currentValue == null || defaultValue == null || defaultBuild <= buildCreated || defaultValue.equals(currentValue)) continue;
            problems.add(path + (maxPaths >= 0 ? "" : " - Changed with build " + defaultBuild + "."));
        }
        if (!problems.isEmpty()) {
            Collections.sort(problems);
            AbstractList outList = maxPaths >= 0 && problems.size() > maxPaths ? new ArrayList(problems.subList(0, maxPaths)) : problems;
            outList.add(0, "The following configuration default values have changed:");
            if (maxPaths >= 0) {
                outList.add("-> " + problems.size() + " entries in total, check the log file(s) for a complete list.");
            } else {
                outList.add("(Remove/update individual values or set configversion.created to " + maxBuildContained + " to ignore all, then reload the configuration with the 'ncp reload' command.)");
            }
            return StringUtil.join(outList, "\n");
        }
        return null;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    @Deprecated
    public static synchronized void setForAllConfigs(String path, Object value) {
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            it.next().getValue().getRawConfiguration().set(path, value);
        }
        worldMan.updateAllWorldData();
    }

    public static boolean isTrueForAnyConfig(String path) {
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            if (!it.next().getValue().getRawConfiguration().getBoolean(path, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlmostTrueForAnyConfig(String path, boolean decideOptimistically, boolean trueForNotSet) {
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            if (!it.next().getValue().getRawConfiguration().getAlmostBoolean(path, decideOptimistically, trueForNotSet)) continue;
            return true;
        }
        return false;
    }

    public static Double getMaxNumberForAllConfigs(String path) {
        Number max = null;
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            ConfigFile config = it.next().getValue().getRawConfiguration();
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (max != null && !(num.doubleValue() > max.doubleValue())) continue;
                max = num;
            }
            catch (Throwable throwable) {}
        }
        return max.doubleValue();
    }

    public static Double getMinNumberForAllConfigs(String path) {
        Number min = null;
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            ConfigFile config = it.next().getValue().getRawConfiguration();
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (min != null && !(num.doubleValue() < min.doubleValue())) continue;
                min = num;
            }
            catch (Throwable throwable) {}
        }
        return min.doubleValue();
    }
}

