/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.order;

import fr.neatmonster.nocheatplus.components.registry.order.IGetRegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.SetupOrder;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHash;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RegistrationOrder {
    public static Comparator<RegistrationOrder> cmpBasePriority = new Comparator<RegistrationOrder>(){

        @Override
        public int compare(RegistrationOrder o1, RegistrationOrder o2) {
            Integer p1 = o1.getBasePriority();
            Integer p2 = o2.getBasePriority();
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.compareTo(p2);
        }
    };
    public static final RegistrationOrder DEFAULT_ORDER = new RegistrationOrder();
    public static final SortRegistrationOrder sortRegistrationOrder = new SortRegistrationOrder();
    public static final SortIGetRegistrationOrder sortIGetRegistrationOrder = new SortIGetRegistrationOrder();
    private final Integer basePriority;
    private final String tag;
    private final String beforeTag;
    private final String afterTag;

    public RegistrationOrder(SetupOrder bluePrint) {
        this(bluePrint.priority());
    }

    public RegistrationOrder(RegisterWithOrder bluePrint) {
        this(bluePrint.basePriority().isEmpty() ? null : Integer.valueOf(Integer.parseInt(bluePrint.basePriority())), bluePrint.tag().isEmpty() ? null : bluePrint.tag(), bluePrint.beforeTag().isEmpty() ? null : bluePrint.beforeTag(), bluePrint.afterTag().isEmpty() ? null : bluePrint.afterTag());
    }

    public RegistrationOrder(RegisterEventsWithOrder bluePrint) {
        this(bluePrint.basePriority().isEmpty() ? null : Integer.valueOf(Integer.parseInt(bluePrint.basePriority())), bluePrint.tag().isEmpty() ? null : bluePrint.tag(), bluePrint.beforeTag().isEmpty() ? null : bluePrint.beforeTag(), bluePrint.afterTag().isEmpty() ? null : bluePrint.afterTag());
    }

    public RegistrationOrder(RegisterMethodWithOrder bluePrint) {
        this(bluePrint.basePriority().isEmpty() ? null : Integer.valueOf(Integer.parseInt(bluePrint.basePriority())), bluePrint.tag().isEmpty() ? null : bluePrint.tag(), bluePrint.beforeTag().isEmpty() ? null : bluePrint.beforeTag(), bluePrint.afterTag().isEmpty() ? null : bluePrint.afterTag());
    }

    public RegistrationOrder(RegistrationOrder bluePrint) {
        this(bluePrint.getBasePriority(), bluePrint.getTag(), bluePrint.getBeforeTag(), bluePrint.getAfterTag());
    }

    public RegistrationOrder() {
        this(null, null, null, null);
    }

    public RegistrationOrder(Integer basePriority) {
        this(basePriority, null, null, null);
    }

    public RegistrationOrder(Integer basePriority, String tag) {
        this(basePriority, tag, null, null);
    }

    public RegistrationOrder(String tag) {
        this(null, tag, null, null);
    }

    public RegistrationOrder(String tag, String beforeTag, String afterTag) {
        this(null, tag, beforeTag, afterTag);
    }

    public RegistrationOrder(Integer basePriority, String tag, String beforeTag, String afterTag) {
        this.basePriority = basePriority;
        this.tag = tag;
        this.beforeTag = beforeTag;
        this.afterTag = afterTag;
    }

    public Integer getBasePriority() {
        return this.basePriority;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBeforeTag() {
        return this.beforeTag;
    }

    public String getAfterTag() {
        return this.afterTag;
    }

    public int hashCode() {
        return (this.basePriority == null ? CoordHash.hashCode3DPrimes(-1, -1, -1) : this.basePriority.hashCode()) ^ (this.tag == null ? CoordHash.hashCode3DPrimes(1, 0, 0) : this.tag.hashCode()) ^ (this.beforeTag == null ? CoordHash.hashCode3DPrimes(0, 1, 0) : this.beforeTag.hashCode()) ^ (this.afterTag == null ? CoordHash.hashCode3DPrimes(0, 0, 1) : this.afterTag.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegistrationOrder)) {
            return false;
        }
        RegistrationOrder other = (RegistrationOrder)obj;
        return (this.basePriority == null ? other.getBasePriority() == null : this.basePriority.equals(other.getBasePriority())) && (this.tag == null ? other.getTag() == null : this.tag.equals(other.getTag())) && (this.beforeTag == null ? other.getBeforeTag() == null : this.beforeTag.equals(other.getBeforeTag())) && (this.afterTag == null ? other.getAfterTag() == null : this.afterTag.equals(other.getAfterTag()));
    }

    public String toString() {
        return "RegistrationOrder(p=" + this.basePriority + (this.tag == null ? "" : " t='" + this.tag + "'") + (this.beforeTag == null ? "" : " bt='" + this.beforeTag + "'") + (this.afterTag == null ? "" : "at='" + this.afterTag + "'") + ")";
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RegisterWithOrder {
        public String basePriority() default "";

        public String tag() default "";

        public String beforeTag() default "";

        public String afterTag() default "";
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RegisterEventsWithOrder {
        public String basePriority() default "";

        public String tag() default "";

        public String beforeTag() default "";

        public String afterTag() default "";
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RegisterMethodWithOrder {
        public String basePriority() default "";

        public String tag() default "";

        public String beforeTag() default "";

        public String afterTag() default "";
    }

    public static class SortRegistrationOrder
    extends AbstractRegistrationOrderSort<RegistrationOrder> {
        @Override
        protected RegistrationOrder fetchRegistrationOrder(RegistrationOrder item) {
            return item;
        }
    }

    public static class SortIGetRegistrationOrder
    extends AbstractRegistrationOrderSort<IGetRegistrationOrder> {
        @Override
        protected RegistrationOrder fetchRegistrationOrder(IGetRegistrationOrder item) {
            return item.getRegistrationOrder();
        }
    }

    public static abstract class AbstractRegistrationOrderSort<F> {
        private final Comparator<F> cmp = new Comparator<F>(){

            @Override
            public int compare(F o1, F o2) {
                return cmpBasePriority.compare(this.fetchRegistrationOrder(o1), this.fetchRegistrationOrder(o2));
            }
        };

        protected abstract RegistrationOrder fetchRegistrationOrder(F var1);

        public void sort(Collection<F> input) {
            LinkedList<F> sorted = this.getSortedLinkedList(input);
            input.clear();
            input.addAll(sorted);
        }

        public LinkedList<F> getSortedLinkedList(Collection<F> input) {
            F[] arr = this.getSortedArray(input);
            LinkedList out = new LinkedList();
            Collections.addAll(out, arr);
            return out;
        }

        public final <O extends Collection<F>> O sort(Collection<F> input, O output) {
            output.addAll(this.getSortedLinkedList(input));
            return output;
        }

        public F[] getSortedArray(Collection<F> input) {
            Object[] output = new Object[input == null ? 0 : input.size()];
            if (input == null || input.isEmpty()) {
                return output;
            }
            if (input.size() == 1) {
                input.toArray(output);
                return output;
            }
            LinkedList<F> belowZeroPriority = new LinkedList<F>();
            LinkedList<F> zeroPriority = new LinkedList<F>();
            LinkedList<F> aboveZeroPriority = new LinkedList<F>();
            int insertionIndex = output.length - 1;
            for (Object item : input) {
                RegistrationOrder order = this.fetchRegistrationOrder(item);
                Integer basePriority = order.getBasePriority();
                if (basePriority == null) {
                    if (order.getBeforeTag() != null) {
                        belowZeroPriority.add(item);
                        continue;
                    }
                    if (order.getAfterTag() != null) {
                        this.sortInFromStart(item, output, insertionIndex);
                        --insertionIndex;
                        continue;
                    }
                    zeroPriority.add(item);
                    continue;
                }
                if (basePriority < 0) {
                    belowZeroPriority.add(item);
                    continue;
                }
                if (basePriority > 0) {
                    aboveZeroPriority.add(item);
                    continue;
                }
                zeroPriority.add(0, item);
            }
            if (!aboveZeroPriority.isEmpty()) {
                this.addSortedSubList(aboveZeroPriority, output, insertionIndex);
                insertionIndex -= aboveZeroPriority.size();
            }
            if (!zeroPriority.isEmpty()) {
                for (Object item : zeroPriority) {
                    this.sortInFromStart(item, output, insertionIndex);
                    --insertionIndex;
                }
            }
            if (!belowZeroPriority.isEmpty()) {
                this.addSortedSubList(belowZeroPriority, output, insertionIndex);
            }
            return output;
        }

        private void addSortedSubList(List<F> subList, F[] output, int insertionIndex) {
            Collections.sort(subList, this.cmp);
            Collections.reverse(subList);
            for (F item : subList) {
                this.sortInFromStart(item, output, insertionIndex);
                --insertionIndex;
            }
        }

        private void sortInFromStart(F item, F[] output, int insertionIndex) {
            RegistrationOrder order = this.fetchRegistrationOrder(item);
            for (int i = insertionIndex; i < output.length; ++i) {
                if (i == output.length - 1 || AbstractRegistrationOrderSort.shouldSortBefore(order, this.fetchRegistrationOrder(output[i + 1]))) {
                    output[i] = item;
                    return;
                }
                output[i] = output[i + 1];
            }
            output[output.length - 1] = item;
        }

        public static boolean shouldSortBefore(RegistrationOrder order1, RegistrationOrder order2) {
            Integer basePriority1 = order1.getBasePriority();
            String tag1 = order1.getTag();
            String beforeTag1 = order1.getBeforeTag();
            String afterTag1 = order1.getAfterTag();
            Integer basePriority2 = order2.getBasePriority();
            String tag2 = order2.getTag();
            String beforeTag2 = order2.getBeforeTag();
            String afterTag2 = order2.getAfterTag();
            if (basePriority1 == null) {
                if (basePriority2 == null) {
                    if (beforeTag1 == null) {
                        if (beforeTag2 == null) {
                            if (afterTag1 == null) {
                                return true;
                            }
                            return (tag2 == null || !tag2.matches(afterTag1)) && afterTag2 != null && tag1 != null && tag1.matches(afterTag2);
                        }
                        return tag1 != null && afterTag2 != null && tag1.matches(afterTag2);
                    }
                    return tag2 == null || afterTag1 == null || !tag2.matches(afterTag1);
                }
                return beforeTag1 != null || afterTag1 == null && basePriority2 > 0 || afterTag1 == null && basePriority2 == 0 && (tag1 == null && beforeTag2 == null && afterTag2 != null || tag1 != null && afterTag2 != null && tag1.matches(afterTag2) || beforeTag2 == null && afterTag2 != null);
            }
            if (basePriority2 == null) {
                if (beforeTag2 == null) {
                    if (afterTag2 == null) {
                        if (basePriority1 < 0) {
                            return false;
                        }
                        if (basePriority1 > 0) {
                            return true;
                        }
                        if (tag2 != null && afterTag1 != null && tag2.matches(afterTag1)) {
                            return false;
                        }
                        if (beforeTag1 != null) {
                            return true;
                        }
                        return afterTag1 == null;
                    }
                    return true;
                }
                return false;
            }
            if (basePriority1 < basePriority2) {
                return true;
            }
            if (basePriority1 > basePriority2) {
                return false;
            }
            if (beforeTag1 == null) {
                if (beforeTag2 == null) {
                    if (afterTag1 == null) {
                        return true;
                    }
                    if (afterTag2 == null) {
                        return false;
                    }
                    if (tag2 != null && tag2.matches(afterTag1)) {
                        return false;
                    }
                    return tag1 != null && tag1.matches(afterTag2);
                }
                return afterTag2 != null && tag1 != null && tag1.matches(afterTag2);
            }
            if (beforeTag2 == null) {
                if (afterTag1 != null && tag2 != null && tag2.matches(afterTag1)) {
                    return false;
                }
                return afterTag2 == null && afterTag1 == null;
            }
            if (tag2 != null && tag2.matches(beforeTag1)) {
                return true;
            }
            if (tag1 != null && tag1.matches(beforeTag2)) {
                return false;
            }
            if (afterTag1 == null) {
                return true;
            }
            if (tag2 != null && tag2.matches(afterTag1)) {
                return false;
            }
            if (afterTag2 != null) {
                return tag1 != null && tag1.matches(afterTag2);
            }
            return false;
        }
    }
}

