/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.meta;

import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class TypeSetRegistry {
    private final Lock lock;
    private final HashMapLOW<Class<?>, GroupNode<?>> groupedTypes;

    public TypeSetRegistry(Lock lock) {
        this.lock = lock;
        this.groupedTypes = new HashMapLOW(lock, 10);
    }

    public <I> void addToGroups(Class<I> itemType, Class<? super I> ... groupTypes) {
        this.lock.lock();
        for (Class<I> clazz : groupTypes) {
            if (!clazz.isAssignableFrom(itemType)) {
                this.lock.unlock();
                throw new IllegalArgumentException("Can't assign " + itemType.getName() + " to " + clazz.getName() + "!");
            }
            GroupNode<? super I> node = this.groupedTypes.get(clazz);
            if (node == null) {
                node = this.newGroupNode(clazz);
            }
            node.add(clazz, itemType);
        }
        this.lock.unlock();
    }

    public <G> void createGroup(Class<G> groupType) {
        this.lock.lock();
        if (!this.groupedTypes.containsKey(groupType)) {
            this.newGroupNode(groupType);
        }
        this.lock.unlock();
    }

    private <G> GroupNode<G> newGroupNode(Class<G> groupType) {
        GroupNode<G> node = new GroupNode<G>(groupType);
        this.groupedTypes.put(groupType, node);
        return node;
    }

    public void addToExistingGroups(Class<?> itemType) {
        this.lock.lock();
        for (Map.Entry<Class<?>, GroupNode<?>> entry : this.groupedTypes.iterable()) {
            Class<?> groupType = entry.getKey();
            if (!groupType.isAssignableFrom(itemType)) continue;
            GroupNode<?> group = entry.getValue();
            group.add(groupType, itemType);
        }
        this.lock.unlock();
    }

    public <G> Collection<Class<? extends G>> getGroupedTypes(Class<G> groupType) {
        GroupNode<?> group = this.groupedTypes.get(groupType);
        return group == null ? Collections.EMPTY_LIST : group.getItems();
    }

    public void updateGroupTypes(TypeSetRegistry refReg) {
        this.lock.lock();
        for (Map.Entry<Class<?>, GroupNode<?>> entry : refReg.groupedTypes.iterable()) {
            if (this.groupedTypes.containsKey(entry.getKey())) continue;
            entry.getValue().createGroup(this);
        }
        this.lock.unlock();
    }

    private static class GroupNode<G> {
        private Collection<Class<? extends G>> group = Collections.EMPTY_LIST;
        private final Class<G> groupType;

        GroupNode(Class<G> groupType) {
            this.groupType = groupType;
        }

        void add(Class<? extends G> itemClass) {
            LinkedHashSet<Class<G>> copyGroup = new LinkedHashSet<Class<G>>(this.group);
            copyGroup.add(itemClass);
            this.group = Collections.unmodifiableCollection(copyGroup);
        }

        void add(Class<?> groupType, Class<?> itemClass) {
            if (groupType != this.groupType) {
                throw new IllegalArgumentException("Invalid group type.");
            }
            this.add(itemClass);
        }

        Collection<Class<? extends G>> getItems() {
            return this.group;
        }

        void createGroup(TypeSetRegistry extReg) {
            extReg.createGroup(this.groupType);
        }
    }
}

