/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.lockable;

import fr.neatmonster.nocheatplus.components.registry.lockable.ILockable;

public class BasicLockable
implements ILockable {
    private static final int ALLOW_LOCK_NOSECRET = 1;
    private static final int ALLOW_LOCK_SECRET = 2;
    private static final int ALLOW_UNLOCK_SECRET = 4;
    private static final int SECRET_IDENTITY = 8;
    private static final int EXACT_SECRET_TYPE = 16;
    private static final int REMOVE_SECRET_UNLOCK = 32;
    private boolean isLocked = false;
    private final int lockFlags;
    private final Class<?> lockSecretType;
    private Object lockSecret = null;

    public BasicLockable() {
        this(true, true, true, false, true, Void.TYPE, false);
    }

    public BasicLockable(Object secret, boolean secretIdentity, boolean isLocked) {
        this(true, true, true, secretIdentity, true, Void.TYPE, false);
        this.lockSecret = secret;
        this.isLocked = isLocked;
    }

    public BasicLockable(Object secret, boolean secretIdentity, boolean exactSecretType, boolean isLocked) {
        this(false, true, true, secretIdentity, true, secret.getClass(), exactSecretType);
        this.lockSecret = secret;
        this.isLocked = isLocked;
    }

    public BasicLockable(boolean secretIdentity, Class<?> secretType, boolean exactSecretType) {
        this(false, true, true, secretIdentity, true, secretType, exactSecretType);
    }

    public BasicLockable(boolean allowLockNoSecret, boolean allowLockSecret, boolean allowUnlockSecret, boolean secretIdentity, boolean removeSecretUnlock, Class<?> secretType, boolean exactSecretType) {
        if (secretType == null) {
            throw new IllegalArgumentException("Can't pass null for secretType, use void.class instead, to ignore this option.");
        }
        this.lockSecretType = secretType;
        int lockFlags = this.setLockFlag(1, allowLockNoSecret, 0);
        lockFlags = this.setLockFlag(2, allowLockSecret, lockFlags);
        lockFlags = this.setLockFlag(4, allowUnlockSecret, lockFlags);
        lockFlags = this.setLockFlag(8, secretIdentity, lockFlags);
        lockFlags = this.setLockFlag(32, removeSecretUnlock, lockFlags);
        this.lockFlags = lockFlags = this.setLockFlag(16, exactSecretType, lockFlags);
    }

    private final int setLockFlag(int flag, boolean value, int result) {
        if (value) {
            return result | flag;
        }
        return result & ~flag;
    }

    private final boolean isLockFlagSet(int flag) {
        return (this.lockFlags & flag) == flag;
    }

    private final boolean isApplicableLockSecret(Object givenSecret, boolean isUnlock) {
        if (this.lockSecret == null ? this.isLocked : (this.isLockFlagSet(8) ? this.lockSecret != givenSecret : !this.lockSecret.equals(givenSecret))) {
            return false;
        }
        if (this.lockSecretType != Void.TYPE) {
            Class<?> type = givenSecret.getClass();
            if (this.isLockFlagSet(16) ? this.lockSecretType != type : !this.lockSecretType.isAssignableFrom(type)) {
                return false;
            }
        }
        return this.furtherLockingRestrictions(givenSecret, isUnlock);
    }

    protected boolean furtherLockingRestrictions(Object givenSecret, boolean isUnlock) {
        return true;
    }

    @Override
    public final void lock() {
        if (!this.isLockFlagSet(1)) {
            throw new UnsupportedOperationException();
        }
        if (!this.furtherLockingRestrictions(null, false)) {
            throw new IllegalStateException();
        }
        this.isLocked = true;
        this.lockSecret = null;
    }

    @Override
    public final void lock(Object secret) {
        if (!this.isLockFlagSet(2)) {
            throw new UnsupportedOperationException();
        }
        if (secret == null || !this.isApplicableLockSecret(secret, false)) {
            throw new IllegalArgumentException();
        }
        this.lockSecret = secret;
        this.isLocked = true;
    }

    @Override
    public final void unlock(Object secret) {
        if (!this.isLockFlagSet(4)) {
            throw new UnsupportedOperationException();
        }
        if (secret == null || !this.isApplicableLockSecret(secret, true)) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked) {
            return;
        }
        if (this.isLockFlagSet(32)) {
            this.lockSecret = null;
        }
        this.isLocked = false;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void throwIfLocked() {
        if (this.isLocked) {
            throw new IllegalStateException();
        }
    }
}

