/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.factory;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.registry.factory.FactoryOneRegistry;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.factory.IRichFactoryRegistry;
import fr.neatmonster.nocheatplus.components.registry.meta.RichTypeSetRegistry;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class RichFactoryRegistry<A>
extends RichTypeSetRegistry
implements IRichFactoryRegistry<A> {
    private final Lock lock;
    private final FactoryOneRegistry<A> factoryRegistry;
    private Set<Class<?>> autoGroups = Collections.EMPTY_SET;

    public RichFactoryRegistry(Lock lock) {
        super(lock);
        this.lock = lock;
        this.factoryRegistry = new FactoryOneRegistry(lock, CheckUtils.primaryServerThreadContextTester);
    }

    @Override
    public <T> T getNewInstance(Class<T> registeredFor, A arg) {
        return this.factoryRegistry.getNewInstance(registeredFor, arg);
    }

    @Override
    public <T> void registerFactory(Class<T> registerFor, IFactoryOne<A, T> factory) {
        this.lock.lock();
        this.factoryRegistry.registerFactory(registerFor, factory);
        for (Class<T> clazz : this.autoGroups) {
            if (!clazz.isAssignableFrom(registerFor)) continue;
            this.addToGroups(registerFor, clazz);
        }
        this.lock.unlock();
    }

    @Override
    public <G> void createAutoGroup(Class<G> groupType) {
        this.lock.lock();
        this.createGroup(groupType);
        LinkedHashSet autoGroups = new LinkedHashSet(this.autoGroups);
        autoGroups.add(groupType);
        this.autoGroups = autoGroups;
        this.lock.unlock();
    }

    public static class CheckRemovalSpec {
        public final Collection<Class<?>> completeRemoval = new LinkedHashSet();
        public final Collection<Class<? extends IDataOnRemoveSubCheckData>> subCheckRemoval = new LinkedHashSet<Class<? extends IDataOnRemoveSubCheckData>>();
        public final Collection<CheckType> checkTypes;

        public CheckRemovalSpec(CheckType checkType, boolean withDescendantCheckTypes, IRichFactoryRegistry<?> factoryRegistry) {
            this(withDescendantCheckTypes ? CheckTypeUtil.getWithDescendants(checkType) : Arrays.asList(checkType), factoryRegistry);
        }

        public CheckRemovalSpec(Collection<CheckType> checkTypes, IRichFactoryRegistry<?> factoryRegistry) {
            this.checkTypes = checkTypes;
            for (CheckType checkType : checkTypes) {
                for (Class<IData> clazz : factoryRegistry.getGroupedTypes(IData.class, checkType)) {
                    this.completeRemoval.add(clazz);
                }
                for (Class<Object> clazz : factoryRegistry.getGroupedTypes(IDataOnRemoveSubCheckData.class, checkType)) {
                    this.subCheckRemoval.add(clazz);
                }
            }
            if (checkTypes.contains((Object)CheckType.ALL)) {
                for (Class clazz : factoryRegistry.getGroupedTypes(IData.class)) {
                    this.completeRemoval.add(clazz);
                }
                for (Class clazz : factoryRegistry.getGroupedTypes(IDataOnRemoveSubCheckData.class)) {
                    this.subCheckRemoval.add(clazz);
                }
            }
        }
    }
}

