/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.data.checktype;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CheckTypeTree<N extends CheckTypeTreeNode<N>> {
    private final N rootNode;
    private final Map<CheckType, N> nodeMap = new LinkedHashMap<CheckType, N>();

    public CheckTypeTree() {
        class DefaultFactory
        implements CheckTypeTreeNodeFactory<N> {
            DefaultFactory() {
            }

            @Override
            public N newNode(CheckType checkType, N parent) {
                return CheckTypeTree.this.newNode(checkType, parent, this);
            }
        }
        this.rootNode = this.newNode(CheckType.ALL, null, new DefaultFactory());
        LinkedList allNodes = new LinkedList();
        this.collectNodes(this.rootNode, allNodes);
        for (CheckTypeTreeNode node : allNodes) {
            this.nodeMap.put(node.getCheckType(), node);
        }
    }

    private void collectNodes(N node, List<N> bucket) {
        bucket.add(node);
        for (CheckTypeTreeNode child : ((CheckTypeTreeNode)node).getChildren()) {
            this.collectNodes(child, bucket);
        }
    }

    protected abstract N newNode(CheckType var1, N var2, CheckTypeTreeNodeFactory<N> var3);

    public N getNode(CheckType checkType) {
        return (N)((CheckTypeTreeNode)this.nodeMap.get((Object)checkType));
    }

    public boolean visitWithDescendants(CheckType checkType, Visitor<N> visitor) {
        return this.visitWithDescendants(this.getNode(checkType), visitor);
    }

    public boolean visitWithDescendants(N node, Visitor<N> visitor) {
        if (!visitor.visit(node)) {
            return false;
        }
        return this.visitDescendants(node, visitor);
    }

    public boolean visitDescendants(CheckType checkType, Visitor<N> visitor) {
        return this.visitDescendants(this.getNode(checkType), visitor);
    }

    public boolean visitDescendants(N parentNode, Visitor<N> visitor) {
        for (CheckTypeTreeNode childNode : ((CheckTypeTreeNode)parentNode).getChildren()) {
            if (this.visitWithDescendants(childNode, visitor)) continue;
            return false;
        }
        return true;
    }

    public boolean visitWithAncestors(CheckType checkType, Visitor<N> visitor) {
        return this.visitWithAncestors(this.getNode(checkType), visitor);
    }

    public boolean visitWithAncestors(N node, Visitor<N> visitor) {
        if (!visitor.visit(node)) {
            return false;
        }
        return this.visitAncestors(node, visitor);
    }

    public boolean visitAncestors(CheckType checkType, Visitor<N> visitor) {
        return this.visitAncestors(this.getNode(checkType), visitor);
    }

    public boolean visitAncestors(N node, Visitor<N> visitor) {
        Object parent = ((CheckTypeTreeNode)node).getParent();
        if (parent != null) {
            return this.visitWithAncestors(parent, visitor);
        }
        return true;
    }

    public static class CheckTypeTreeNode<N extends CheckTypeTreeNode<N>> {
        private final CheckType checkType;
        private final N parent;
        private final List<N> children;

        public CheckTypeTreeNode(CheckType checkType, N parent, CheckTypeTreeNodeFactory<N> factory) {
            this.checkType = checkType;
            this.parent = parent;
            Set<CheckType> childrenTypes = CheckTypeUtil.getDirectChildren(checkType);
            ArrayList<CheckTypeTreeNode> children = new ArrayList<CheckTypeTreeNode>(childrenTypes.size());
            for (CheckType childType : childrenTypes) {
                children.add(factory.newNode(childType, this));
            }
            this.children = Collections.unmodifiableList(children);
        }

        public CheckType getCheckType() {
            return this.checkType;
        }

        public N getParent() {
            return this.parent;
        }

        public List<N> getChildren() {
            return this.children;
        }
    }

    public static interface CheckTypeTreeNodeFactory<N extends CheckTypeTreeNode<N>> {
        public N newNode(CheckType var1, N var2);
    }

    public static interface Visitor<N extends CheckTypeTreeNode<N>> {
        public boolean visit(N var1);
    }
}

