/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class ServerVersion {
    private static String minecraftVersion = "unknown";
    private static final String[][] versionTagsMatch = new String[][]{{"1.7.2-r", "1.7.2"}};

    public static boolean isMinecraftVersionUnknown() {
        return GenericVersion.isVersionUnknown(minecraftVersion);
    }

    public static String parseMinecraftVersion(String ... versionCandidates) {
        for (String serverVersion : versionCandidates) {
            serverVersion = serverVersion.trim();
            for (String minecraftVersion : new String[]{GenericVersion.collectVersion(serverVersion, 0), ServerVersion.parseMinecraftVersionGeneric(serverVersion), ServerVersion.parseMinecraftVersionTokens(serverVersion)}) {
                if (minecraftVersion == null || !ServerVersion.validateMinecraftVersion(minecraftVersion)) continue;
                return minecraftVersion;
            }
        }
        return null;
    }

    public static Object getNMSMinecraftServer() {
        Server server = Bukkit.getServer();
        try {
            Object obj = ReflectionUtil.invokeMethodNoArgs(server, "getServer", new Class[0]);
            return obj;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String fetchNMSMinecraftServerVersion() {
        Object server = ServerVersion.getNMSMinecraftServer();
        if (server == null) {
            return null;
        }
        try {
            return (String)ReflectionUtil.invokeMethodNoArgs(server, "getVersion", String.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean validateMinecraftVersion(String minecraftVersion) {
        return GenericVersion.collectVersion(minecraftVersion, 0) != null;
    }

    private static String parseMinecraftVersionTokens(String serverVersion) {
        serverVersion = serverVersion.trim().toLowerCase();
        for (String[] entry : versionTagsMatch) {
            if (!serverVersion.contains(entry[0])) continue;
            return entry[1];
        }
        return null;
    }

    private static String parseMinecraftVersionGeneric(String serverVersion) {
        String lcServerVersion = serverVersion.trim().toLowerCase();
        for (String candidate : new String[]{GenericVersion.parseVersionDelimiters(lcServerVersion, "(mc:", ")"), GenericVersion.parseVersionDelimiters(lcServerVersion, "(mc:", "-pre"), GenericVersion.parseVersionDelimiters(lcServerVersion, "mcpc-plus-", "-"), GenericVersion.parseVersionDelimiters(lcServerVersion, "git-bukkit-", "-r"), GenericVersion.parseVersionDelimiters(lcServerVersion, "", "-r")}) {
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static String setMinecraftVersion(String version) {
        minecraftVersion = version == null ? "unknown" : ((version = version.trim().toLowerCase()).isEmpty() || version.equals("unknown") ? "unknown" : version);
        return minecraftVersion;
    }

    public static String getMinecraftVersion() {
        return minecraftVersion;
    }

    public static int compareMinecraftVersion(String toVersion) {
        return GenericVersion.compareVersions(ServerVersion.getMinecraftVersion(), toVersion);
    }

    public static boolean isLowerThan(String version) {
        return ServerVersion.compareMinecraftVersion(version) == -1;
    }

    public static boolean isHigherThan(String version) {
        return ServerVersion.compareMinecraftVersion(version) == 1;
    }

    public static boolean isAtLeast(String version) {
        return ServerVersion.compareMinecraftVersion(version) >= 0;
    }

    public static boolean isAtMost(String version) {
        return ServerVersion.compareMinecraftVersion(version) <= 0;
    }

    public static boolean isMinecraftVersionBetween(String versionLow, boolean includeLow, String versionHigh, boolean includeHigh) {
        return GenericVersion.isVersionBetween(ServerVersion.getMinecraftVersion(), versionLow, includeLow, versionHigh, includeHigh);
    }

    public static <V> V select(String cmpVersion, V valueLT, V valueEQ, V valueGT, V valueUnknown) {
        String mcVersion = ServerVersion.getMinecraftVersion();
        if (mcVersion == "unknown") {
            return valueUnknown;
        }
        int cmp = GenericVersion.compareVersions(mcVersion, cmpVersion);
        if (cmp == 0) {
            return valueEQ;
        }
        if (cmp < 0) {
            return valueLT;
        }
        return valueGT;
    }
}

