/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

public enum ClientVersion {
    V_1_7_2(4),
    V_1_7_10(5),
    V_1_8(47),
    V_1_9(107),
    V_1_9_1(108),
    V_1_9_2(109),
    V_1_9_3(110),
    V_1_10(210),
    V_1_11(315),
    V_1_11_1(316),
    V_1_12(335),
    V_1_12_1(338),
    V_1_12_2(340),
    V_1_13(393),
    V_1_13_1(401),
    V_1_13_2(404),
    V_1_14(477),
    V_1_14_1(480),
    V_1_14_2(485),
    V_1_14_3(490),
    V_1_14_4(498),
    V_1_15(573),
    V_1_15_1(575),
    V_1_15_2(578),
    V_1_16(735),
    V_1_16_1(736),
    V_1_16_2(751),
    V_1_16_3(753),
    V_1_16_4(754),
    V_1_17(755),
    V_1_17_1(756),
    V_1_18(757),
    V_1_18_2(758),
    V_1_19(759),
    V_1_19_1(760),
    V_1_19_3(761),
    V_1_19_4(762),
    V_1_20(763),
    V_1_20_2(764),
    V_1_20_3(765),
    V_1_20_6(766),
    V_1_21(767),
    V_1_21_2(768),
    V_1_21_4(769),
    V_1_21_5(770),
    V_1_21_6(771),
    V_1_21_7(772),
    LOWER_THAN_KNOWN_VERSIONS(ClientVersion.V_1_7_2.protocolID - 1, false),
    HIGHER_THAN_KNOWN_VERSIONS(ClientVersion.V_1_21_7.protocolID + 1, false),
    UNKNOWN(-1, false);

    private final int protocolID;
    private final String name;
    private static final ClientVersion[] VALUES;
    private static final int LOWEST_KNOWN_PROTOCOL_VERSION;
    private static final int HIGHEST_KNOWN_PROTOCOL_VERSION;

    private ClientVersion(int protocolVersion) {
        this.protocolID = protocolVersion;
        this.name = this.name().substring(2).replace("_", ".");
    }

    private ClientVersion(int protocolVersion, boolean knownVersion) {
        this.protocolID = protocolVersion;
        this.name = !knownVersion ? this.name() : this.name().substring(2).replace("_", ".");
    }

    public static ClientVersion getById(int protocolVersion) {
        if (protocolVersion < LOWEST_KNOWN_PROTOCOL_VERSION) {
            return LOWER_THAN_KNOWN_VERSIONS;
        }
        if (protocolVersion > HIGHEST_KNOWN_PROTOCOL_VERSION) {
            return HIGHER_THAN_KNOWN_VERSIONS;
        }
        for (ClientVersion version : VALUES) {
            if (version.protocolID > protocolVersion) break;
            if (version.protocolID != protocolVersion) continue;
            return version;
        }
        return UNKNOWN;
    }

    public static ClientVersion getByString(String versionName) {
        for (ClientVersion version : VALUES) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return UNKNOWN;
    }

    public String getReleaseName() {
        return this.name;
    }

    public int getProtocolVersion() {
        return this.protocolID;
    }

    public static ClientVersion getLatest() {
        return VALUES[VALUES.length - 4];
    }

    public static ClientVersion getOldest() {
        return VALUES[0];
    }

    public boolean isVersionBetween(ClientVersion versionLow, boolean includeLow, ClientVersion versionHigh, boolean includeHigh) {
        if (includeLow ? this.isLowerThan(versionLow) : this.isAtMost(versionLow)) {
            return false;
        }
        return !(includeHigh ? this.isHigherThan(versionHigh) : this.isAtLeast(versionHigh));
    }

    public boolean isHigherThan(ClientVersion target) {
        return this.protocolID > target.protocolID;
    }

    public boolean isAtLeast(ClientVersion target) {
        return this.protocolID >= target.protocolID;
    }

    public boolean isLowerThan(ClientVersion target) {
        return this.protocolID < target.protocolID;
    }

    public boolean isAtMost(ClientVersion target) {
        return this.protocolID <= target.protocolID;
    }

    public boolean isInRange(ClientVersion min, ClientVersion max) {
        return this.isAtLeast(min) && this.isAtMost(max);
    }

    public boolean isBetween(ClientVersion min, ClientVersion max) {
        return this.isHigherThan(min) && this.isLowerThan(max);
    }

    static {
        VALUES = ClientVersion.values();
        LOWEST_KNOWN_PROTOCOL_VERSION = ClientVersion.LOWER_THAN_KNOWN_VERSIONS.protocolID + 1;
        HIGHEST_KNOWN_PROTOCOL_VERSION = ClientVersion.HIGHER_THAN_KNOWN_VERSIONS.protocolID - 1;
    }
}

