/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect.reflect;

import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.IReflectBlock;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectAxisAlignedBB;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlockPosition;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectHelper;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectIBlockAccess;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectIBlockData;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectMaterial;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectWorld;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Material;

public class ReflectBlock
implements IReflectBlock {
    public final Class<?> nmsClass;
    private final ReflectBlockPosition reflectBlockPosition;
    private final ReflectAxisAlignedBB reflectAxisAlignedBB;
    private final ReflectIBlockData reflectIBlockData;
    private final ReflectIBlockAccess reflectIBlockAccess;
    private final ReflectWorld reflectWorld;
    public final Method nmsGetById;
    public final Method nmsGetBlockData;
    public final Method nmsFetchAABB;

    public ReflectBlock(ReflectBase base, ReflectBlockPosition reflectBlockPosition, ReflectMaterial reflectMaterial, ReflectWorld reflectWorld) throws ClassNotFoundException {
        this.reflectBlockPosition = reflectBlockPosition;
        if (reflectBlockPosition.new_nmsBlockPosition == null) {
            this.fail();
        }
        this.reflectAxisAlignedBB = new ReflectAxisAlignedBB(base);
        this.reflectIBlockData = new ReflectIBlockData(base, reflectMaterial);
        this.reflectWorld = reflectWorld;
        if (reflectWorld.nmsClass == null || reflectWorld.nmsGetType == null) {
            this.fail();
        }
        this.reflectIBlockAccess = new ReflectIBlockAccess(base);
        this.nmsClass = Class.forName(base.nmsPackageName + ".Block");
        this.nmsGetById = ReflectionUtil.getMethod(this.nmsClass, "getById", Integer.TYPE);
        if (this.nmsGetById == null) {
            this.fail();
        }
        this.nmsGetBlockData = ReflectionUtil.getMethodNoArgs(this.nmsClass, "getBlockData", this.reflectIBlockData.nmsClass);
        if (this.nmsGetBlockData == null) {
            this.fail();
        }
        this.nmsFetchAABB = this.determine_fetchAABB();
        if (this.nmsFetchAABB == null) {
            this.fail();
        }
    }

    private Method determine_fetchAABB() {
        Method nmsFetchAABB = null;
        if (ServerVersion.compareMinecraftVersion("1.11") >= 0 ? (nmsFetchAABB = ReflectionUtil.getMethod(this.nmsClass, "b", this.reflectIBlockData.nmsClass, this.reflectIBlockAccess.nmsClass, this.reflectBlockPosition.nmsClass)) != null && nmsFetchAABB.getReturnType() == this.reflectAxisAlignedBB.nmsClass && nmsFetchAABB.isAnnotationPresent(Deprecated.class) : nmsFetchAABB == null && (nmsFetchAABB = ReflectionUtil.getMethod(this.nmsClass, "a", this.reflectIBlockData.nmsClass, this.reflectIBlockAccess.nmsClass, this.reflectBlockPosition.nmsClass)) != null && nmsFetchAABB.getReturnType() == this.reflectAxisAlignedBB.nmsClass && nmsFetchAABB.isAnnotationPresent(Deprecated.class)) {
            return nmsFetchAABB;
        }
        return null;
    }

    private void fail() {
        throw new ReflectHelper.ReflectFailureException();
    }

    private Object nmsBlockPosition(int x, int y, int z) {
        Object blockPos = ReflectionUtil.newInstance(this.reflectBlockPosition.new_nmsBlockPosition, x, y, z);
        if (blockPos == null) {
            this.fail();
        }
        return blockPos;
    }

    @Override
    public Object nms_getByMaterial(Material id) {
        if (this.nmsGetById == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethod(this.nmsGetById, null, id.getId());
    }

    private Object nms_getBlockData(Object block) {
        try {
            return this.nmsGetBlockData.invoke(block, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
        catch (IllegalArgumentException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
        catch (InvocationTargetException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
    }

    @Override
    public Object nms_getMaterial(Object block) {
        return this.reflectIBlockData.nms_getMaterial(this.nms_getBlockData(block));
    }

    @Override
    public double[] nms_fetchBounds(Object nmsWorld, Object nmsBlock, int x, int y, int z) {
        Object pos = this.nmsBlockPosition(x, y, z);
        Object blockData = this.reflectWorld.nms_getType(nmsWorld, pos);
        Object bb = this.nms_fetchAABB(nmsBlock, blockData, nmsWorld, pos);
        if (bb == null) {
            return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        return this.reflectAxisAlignedBB.fillInValues(bb, new double[6]);
    }

    private Object nms_fetchAABB(Object nmsBlock, Object iBlockData, Object iBlockAccess, Object blockPosition) {
        try {
            return this.nmsFetchAABB.invoke(nmsBlock, iBlockData, iBlockAccess, blockPosition);
        }
        catch (IllegalAccessException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
        catch (IllegalArgumentException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
        catch (InvocationTargetException e) {
            throw new ReflectHelper.ReflectFailureException();
        }
    }

    @Override
    public boolean isFetchBoundsAvailable() {
        return true;
    }
}

