/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.compat.bukkit.MCAccessBukkit;
import fr.neatmonster.nocheatplus.compat.cbreflect.BlockCacheCBReflect;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectHelper;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MCAccessCBReflect
extends MCAccessBukkit {
    protected final ReflectHelper helper = new ReflectHelper();
    protected final boolean knownSupportedVersion;
    protected final boolean dealFallDamageFiresAnEvent;

    public MCAccessCBReflect() throws ReflectHelper.ReflectFailureException {
        String mcVersion = ServerVersion.getMinecraftVersion();
        if (mcVersion == "unknown") {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "The Minecraft version could not be detected, Compat-CB-Reflect might or might not work.");
            this.knownSupportedVersion = false;
        } else if (GenericVersion.compareVersions(mcVersion, "1.5") < 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "The Minecraft version seems to be older than what Compat-CB-Reflect can support.");
            this.knownSupportedVersion = false;
        } else if (GenericVersion.compareVersions(mcVersion, "1.12.2") > 0) {
            this.knownSupportedVersion = false;
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "The Minecraft version seems to be more recent than the one Compat-CB-Reflect has been built with - this might work, but there could be incompatibilities.");
        } else {
            this.knownSupportedVersion = true;
        }
        this.dealFallDamageFiresAnEvent = mcVersion != "unknown" && GenericVersion.compareVersions(mcVersion, "1.8") >= 0;
    }

    @Override
    public String getMCVersion() {
        return "1.5-1.12.2";
    }

    @Override
    public String getServerVersionTag() {
        return "CB-Reflect";
    }

    @Override
    public BlockCache getBlockCache(World world) {
        try {
            return new BlockCacheCBReflect(this.helper, world);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return new BlockCacheBukkit(world);
        }
    }

    @Override
    public boolean shouldBeZombie(Player player) {
        try {
            Object handle = this.helper.getHandle(player);
            return !this.helper.nmsPlayer_dead(handle) && this.helper.nmsPlayer_getHealth(handle) <= 0.0;
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.shouldBeZombie(player);
        }
    }

    @Override
    public void setDead(Player player, int deathTicks) {
        try {
            Object handle = this.helper.getHandle(player);
            this.helper.nmsPlayer_dead(handle, true);
            this.helper.nmsPlayer_deathTicks(handle, deathTicks);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.setDead(player, deathTicks);
        }
    }

    @Override
    public AlmostBoolean dealFallDamageFiresAnEvent() {
        if (!this.dealFallDamageFiresAnEvent) {
            return AlmostBoolean.NO;
        }
        return AlmostBoolean.match(this.helper.canDealFallDamage());
    }

    @Override
    public void dealFallDamage(Player player, double damage) {
        try {
            this.helper.dealFallDamage(player, damage);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.dealFallDamage(player, damage);
        }
    }

    @Override
    public int getInvulnerableTicks(Player player) {
        try {
            return this.helper.getInvulnerableTicks(player);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getInvulnerableTicks(player);
        }
    }

    @Override
    public void setInvulnerableTicks(Player player, int ticks) {
        try {
            this.helper.setInvulnerableTicks(player, ticks);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.setInvulnerableTicks(player, ticks);
        }
    }

    @Override
    public AlmostBoolean isBlockSolid(Material id) {
        try {
            return this.helper.isBlockSolid(id);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.isBlockSolid(id);
        }
    }

    @Override
    public AlmostBoolean isBlockLiquid(Material id) {
        try {
            return this.helper.isBlockLiquid(id);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.isBlockLiquid(id);
        }
    }

    @Override
    public double getHeight(Entity entity) {
        if (this.bukkitHasGetHeightAndGetWidth) {
            return super.getHeight(entity);
        }
        try {
            return this.helper.getHeight(entity);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getHeight(entity);
        }
    }

    @Override
    public double getWidth(Entity entity) {
        if (this.bukkitHasGetHeightAndGetWidth) {
            return super.getWidth(entity);
        }
        try {
            return this.helper.getWidth(entity);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getWidth(entity);
        }
    }

    @Override
    public AlmostBoolean isIllegalBounds(Player player) {
        if (player.isDead()) {
            return AlmostBoolean.NO;
        }
        try {
            double[] bounds = this.helper.getBoundsTemp((Entity)player);
            if (LocUtil.isBadCoordinate(bounds)) {
                return AlmostBoolean.YES;
            }
            if (!player.isSleeping()) {
                double dY = Math.abs(bounds[4] - bounds[1]);
                if (dY > 1.8) {
                    return AlmostBoolean.YES;
                }
                if (dY < 0.1 && this.getHeight((Entity)player) >= 0.1) {
                    return AlmostBoolean.YES;
                }
            }
        }
        catch (ReflectHelper.ReflectFailureException reflectFailureException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return AlmostBoolean.MAYBE;
    }
}

