/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Wall;

public class BukkitWall
implements BukkitShapeModel {
    private final double minXZ;
    private final double maxXZ;
    private final double height;
    private final double sideInset;
    private final double[] east;
    private final double[] north;
    private final double[] west;
    private final double[] south;
    private final double[] eastwest;
    private final double[] southnorth;

    public BukkitWall(double inset, double height) {
        this(inset, 1.0 - inset, height, 0.0);
    }

    public BukkitWall(double inset, double height, double sideInset) {
        this(inset, 1.0 - inset, height, sideInset);
    }

    public BukkitWall(double minXZ, double maxXZ, double height, double sideInset) {
        this.minXZ = minXZ;
        this.maxXZ = maxXZ;
        this.height = height;
        this.sideInset = sideInset;
        this.east = new double[]{maxXZ, 0.0, sideInset, 1.0, height, 1.0 - sideInset};
        this.north = new double[]{sideInset, 0.0, 0.0, 1.0 - sideInset, height, minXZ};
        this.west = new double[]{0.0, 0.0, sideInset, minXZ, height, 1.0 - sideInset};
        this.south = new double[]{sideInset, 0.0, maxXZ, 1.0 - sideInset, height, 1.0};
        this.eastwest = new double[]{0.0, 0.0, sideInset, 1.0, height, 1.0 - sideInset};
        this.southnorth = new double[]{sideInset, 0.0, 0.0, 1.0 - sideInset, height, 1.0};
    }

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof MultipleFacing) {
            MultipleFacing fence = (MultipleFacing)blockData;
            double[] res = new double[]{this.minXZ, 0.0, this.minXZ, this.maxXZ, this.height, this.maxXZ};
            Set faces = fence.getFaces();
            if (!faces.contains(BlockFace.UP) && faces.size() == 2) {
                if (faces.contains(BlockFace.SOUTH)) {
                    return new double[]{this.sideInset, 0.0, 0.0, 1.0 - this.sideInset, this.height, 1.0};
                }
                if (faces.contains(BlockFace.WEST)) {
                    return new double[]{0.0, 0.0, this.sideInset, 1.0, this.height, 1.0 - this.sideInset};
                }
            }
            for (BlockFace face : fence.getFaces()) {
                switch (face) {
                    case EAST: {
                        res = this.add(res, this.east);
                        break;
                    }
                    case NORTH: {
                        res = this.add(res, this.north);
                        break;
                    }
                    case WEST: {
                        res = this.add(res, this.west);
                        break;
                    }
                    case SOUTH: {
                        res = this.add(res, this.south);
                        break;
                    }
                }
            }
            return res;
        }
        if (blockData instanceof Wall) {
            Wall wall = (Wall)blockData;
            if (wall.isUp()) {
                double[] res = new double[]{this.minXZ, 0.0, this.minXZ, this.maxXZ, this.height, this.maxXZ};
                if (!wall.getHeight(BlockFace.WEST).equals((Object)Wall.Height.NONE)) {
                    res = this.add(res, this.west);
                }
                if (!wall.getHeight(BlockFace.EAST).equals((Object)Wall.Height.NONE)) {
                    res = this.add(res, this.east);
                }
                if (!wall.getHeight(BlockFace.NORTH).equals((Object)Wall.Height.NONE)) {
                    res = this.add(res, this.north);
                }
                if (!wall.getHeight(BlockFace.SOUTH).equals((Object)Wall.Height.NONE)) {
                    res = this.add(res, this.south);
                }
                return res;
            }
            double[] res = null;
            if (!wall.getHeight(BlockFace.WEST).equals((Object)Wall.Height.NONE) && !wall.getHeight(BlockFace.EAST).equals((Object)Wall.Height.NONE) && res == null) {
                res = this.eastwest;
            }
            if (!wall.getHeight(BlockFace.NORTH).equals((Object)Wall.Height.NONE) && !wall.getHeight(BlockFace.SOUTH).equals((Object)Wall.Height.NONE)) {
                res = res == null ? this.southnorth : this.add(res, this.southnorth);
            }
            if (res != null) {
                return res;
            }
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }

    private double[] add(double[] array1, double[] array2) {
        double[] newArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }
}

