/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrapDoor;

public class BukkitTrapDoor
implements BukkitShapeModel {
    private static final double closedHeight = 0.1875;
    private static final double openWidth = 0.1875;

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof TrapDoor) {
            double[] dArray;
            TrapDoor trapDoor = (TrapDoor)blockData;
            if (trapDoor.isOpen()) {
                switch (trapDoor.getFacing()) {
                    case NORTH: {
                        return new double[]{0.0, 0.0, 0.8125, 1.0, 1.0, 1.0};
                    }
                    case SOUTH: {
                        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.1875};
                    }
                    case EAST: {
                        return new double[]{0.0, 0.0, 0.0, 0.1875, 1.0, 1.0};
                    }
                    case WEST: {
                        return new double[]{0.8125, 0.0, 0.0, 1.0, 1.0, 1.0};
                    }
                }
            }
            if (trapDoor.getHalf() == Bisected.Half.BOTTOM) {
                double[] dArray2 = new double[6];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                dArray2[3] = 1.0;
                dArray2[4] = 0.1875;
                dArray = dArray2;
                dArray2[5] = 1.0;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.0;
                dArray3[1] = 0.8125;
                dArray3[2] = 0.0;
                dArray3[3] = 1.0;
                dArray3[4] = 1.0;
                dArray = dArray3;
                dArray3[5] = 1.0;
            }
            return dArray;
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        TrapDoor trapDoor;
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof TrapDoor && (trapDoor = (TrapDoor)blockData).isOpen()) {
            switch (trapDoor.getFacing()) {
                case EAST: {
                    return 3;
                }
                case NORTH: {
                    return 4;
                }
                case SOUTH: {
                    return 5;
                }
                case WEST: {
                    return 6;
                }
            }
        }
        return 0;
    }
}

