/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;

public class BukkitStairs
implements BukkitShapeModel {
    private final double[] topslabs = new double[]{0.0, 0.5, 0.0, 1.0, 1.0, 1.0};
    private final double[] bottomslabs = new double[]{0.0, 0.0, 0.0, 1.0, 0.5, 1.0};
    private final double[] octet_nnn = new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 0.5};
    private final double[] octet_nnp = new double[]{0.0, 0.0, 0.5, 0.5, 0.5, 1.0};
    private final double[] octet_pnn = new double[]{0.5, 0.0, 0.0, 1.0, 0.5, 0.5};
    private final double[] octet_pnp = new double[]{0.5, 0.0, 0.5, 1.0, 0.5, 1.0};
    private final double[] octet_npn = new double[]{0.0, 0.5, 0.0, 0.5, 1.0, 0.5};
    private final double[] octet_npp = new double[]{0.0, 0.5, 0.5, 0.5, 1.0, 1.0};
    private final double[] octet_ppn = new double[]{0.5, 0.5, 0.0, 1.0, 1.0, 0.5};
    private final double[] octet_ppp = new double[]{0.5, 0.5, 0.5, 1.0, 1.0, 1.0};
    private final double[][] top_stairs = this.makeshape(this.topslabs, this.octet_nnn, this.octet_pnn, this.octet_nnp, this.octet_pnp);
    private final double[][] bottom_stairs = this.makeshape(this.bottomslabs, this.octet_npn, this.octet_ppn, this.octet_npp, this.octet_ppp);
    private final int[] shape_by_state = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockData blockData = block.getState().getBlockData();
        if (blockData instanceof Stairs) {
            Stairs stairs = (Stairs)blockData;
            Bisected.Half half = stairs.getHalf();
            switch (half) {
                case BOTTOM: {
                    return this.bottom_stairs[this.shape_by_state[this.getShapeStateIndex(stairs)]];
                }
                case TOP: {
                    return this.top_stairs[this.shape_by_state[this.getShapeStateIndex(stairs)]];
                }
            }
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }

    private double[][] makeshape(double[] slab, double[] octet_nn, double[] octet_pn, double[] octet_np, double[] octet_pp) {
        return (double[][])IntStream.range(0, 16).mapToObj(flags -> this.makeStairShape(flags, slab, octet_nn, octet_pn, octet_np, octet_pp)).toArray(x$0 -> new double[x$0][]);
    }

    private double[] makeStairShape(int flags, double[] slab, double[] octet_nn, double[] octet_pn, double[] octet_np, double[] octet_pp) {
        double[] res = slab;
        if ((flags & 1) != 0) {
            res = this.merge(res, octet_nn);
        }
        if ((flags & 2) != 0) {
            res = this.merge(res, octet_pn);
        }
        if ((flags & 4) != 0) {
            res = this.merge(res, octet_np);
        }
        if ((flags & 8) != 0) {
            res = this.merge(res, octet_pp);
        }
        return res;
    }

    private int getShapeStateIndex(Stairs stair) {
        return stair.getShape().ordinal() * 4 + this.directionToValue(stair.getFacing());
    }

    private int directionToValue(BlockFace face) {
        switch (face) {
            default: {
                return -1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 1;
            }
            case EAST: 
        }
        return 3;
    }

    private double[] merge(double[] bounds, double[] octet) {
        double[] res = bounds;
        double minX = octet[0];
        double minY = octet[1];
        double minZ = octet[2];
        double maxX = octet[3];
        double maxY = octet[4];
        double maxZ = octet[5];
        for (int i = 2; i <= AxisAlignedBBUtils.getNumberOfAABBs(bounds); ++i) {
            List<Axis> a;
            double tminX = bounds[i * 6 - 6];
            double tminY = bounds[i * 6 - 5];
            double tminZ = bounds[i * 6 - 4];
            double tmaxX = bounds[i * 6 - 3];
            double tmaxY = bounds[i * 6 - 2];
            double tmaxZ = bounds[i * 6 - 1];
            if (!this.sameshape(minX, minY, minZ, maxX, maxY, maxZ, tminX, tminY, tminZ, tmaxX, tmaxY, tmaxZ) || (a = this.getRelative(minX, minY, minZ, maxX, maxY, maxZ, tminX, tminY, tminZ, tmaxX, tmaxY, tmaxZ)).size() != 1) continue;
            Axis axis = a.get(0);
            switch (axis) {
                case X_AXIS: {
                    res[i * 6 - 6] = Math.min(tminX, minX);
                    res[i * 6 - 3] = Math.max(tmaxX, maxX);
                    return res;
                }
                case Z_AXIS: {
                    res[i * 6 - 4] = Math.min(tminZ, minZ);
                    res[i * 6 - 1] = Math.max(tmaxZ, maxZ);
                    return res;
                }
            }
        }
        return this.add(res, octet);
    }

    private double[] add(double[] array1, double[] array2) {
        double[] newArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    private List<Axis> getRelative(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double tminX, double tminY, double tminZ, double tmaxX, double tmaxY, double tmaxZ) {
        ArrayList<Axis> list = new ArrayList<Axis>();
        if (minX == tmaxX || maxX == tminX) {
            list.add(Axis.X_AXIS);
        }
        if (minY == tmaxY || maxY == tminY) {
            list.add(Axis.Y_AXIS);
        }
        if (minZ == tmaxZ || maxZ == tminZ) {
            list.add(Axis.Z_AXIS);
        }
        return list;
    }

    private boolean sameshape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double tminX, double tminY, double tminZ, double tmaxX, double tmaxY, double tmaxZ) {
        double dx = maxX - minX;
        double dy = maxY - minY;
        double dz = maxZ - minZ;
        double tdx = tmaxX - tminX;
        double tdy = tmaxY - tminY;
        double tdz = tmaxZ - tminZ;
        return dx == tdx && dy == tdy && dz == tdz;
    }
}

