/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Piston;
import org.bukkit.util.BoundingBox;

public class BukkitPiston
implements BukkitShapeModel {
    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        if (Bridge1_13.hasBoundingBox()) {
            BoundingBox bd = block.getBoundingBox();
            return new double[]{bd.getMinX() - (double)x, bd.getMinY() - (double)y, bd.getMinZ() - (double)z, bd.getMaxX() - (double)x, bd.getMaxY() - (double)y, bd.getMaxZ() - (double)z};
        }
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        double[] res = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        if (blockData instanceof Piston) {
            Piston piston = (Piston)blockData;
            if (!piston.isExtended()) {
                return res;
            }
            BlockFace face = piston.getFacing();
            switch (face) {
                case NORTH: {
                    res[2] = 0.25;
                    break;
                }
                case SOUTH: {
                    res[5] = 0.75;
                    break;
                }
                case WEST: {
                    res[0] = 0.25;
                    break;
                }
                case EAST: {
                    res[3] = 0.75;
                    break;
                }
                case UP: {
                    res[4] = 0.75;
                    break;
                }
                case DOWN: {
                    res[1] = 0.25;
                    break;
                }
            }
            return res;
        }
        return res;
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }
}

