/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Openable;

public class BukkitGate
implements BukkitShapeModel {
    private final double minXZ;
    private final double maxXZ;
    private final double height;

    public BukkitGate(double inset, double height) {
        this(inset, 1.0 - inset, height);
    }

    public BukkitGate(double minXZ, double maxXZ, double height) {
        this.minXZ = minXZ;
        this.maxXZ = maxXZ;
        this.height = height;
    }

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof Directional) {
            switch (((Directional)blockData).getFacing()) {
                case WEST: {
                    return new double[]{this.minXZ, 0.0, 0.0, this.maxXZ, this.height, 1.0};
                }
                case EAST: {
                    return new double[]{this.minXZ, 0.0, 0.0, this.maxXZ, this.height, 1.0};
                }
                case NORTH: {
                    return new double[]{0.0, 0.0, this.minXZ, 1.0, this.height, this.maxXZ};
                }
                case SOUTH: {
                    return new double[]{0.0, 0.0, this.minXZ, 1.0, this.height, this.maxXZ};
                }
            }
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof Openable) {
            return ((Openable)blockData).isOpen() ? 4 : 0;
        }
        return 0;
    }
}

