/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.PointedDripstone;

public class BukkitDripStone
implements BukkitShapeModel {
    private static final double[] TIP_MERGE = new double[]{0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875};
    private static final double[] TIP_DOWN = new double[]{0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875};
    private static final double[] TIP_UP = new double[]{0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875};
    private static final double[] FRUSTUM = new double[]{0.25, 0.0, 0.25, 0.75, 1.0, 0.75};
    private static final double[] MIDDLE = new double[]{0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125};
    private static final double[] BASE = new double[]{0.125, 0.0, 0.125, 0.875, 1.0, 0.875};

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof PointedDripstone) {
            boolean bedrock = blockCache.getPlayerData() != null && blockCache.getPlayerData().isBedrockPlayer();
            long randomseed = bedrock ? LocUtil.randomSeedBedrock(x, 0, z) : LocUtil.randomSeedJava(x, 0, z);
            double xOffset = MathUtil.clamp((double)this.calcOffset(randomseed, false, bedrock), -0.125, 0.125);
            double zOffset = MathUtil.clamp((double)this.calcOffset(randomseed, true, bedrock), -0.125, 0.125);
            PointedDripstone pds = (PointedDripstone)blockData;
            switch (pds.getThickness()) {
                case TIP_MERGE: {
                    return this.offset(TIP_MERGE, xOffset, 0.0, zOffset);
                }
                case TIP: {
                    if (pds.getVerticalDirection() == BlockFace.DOWN) {
                        return this.offset(TIP_DOWN, xOffset, 0.0, zOffset);
                    }
                    return this.offset(TIP_UP, xOffset, 0.0, zOffset);
                }
                case FRUSTUM: {
                    return this.offset(FRUSTUM, xOffset, 0.0, zOffset);
                }
                case MIDDLE: {
                    return this.offset(MIDDLE, xOffset, 0.0, zOffset);
                }
            }
            return this.offset(BASE, xOffset, 0.0, zOffset);
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }

    private float calcOffset(long x, boolean shift, boolean bedrock) {
        if (shift) {
            x >>= 8;
        }
        float b = x &= 0xFL;
        if (bedrock) {
            b *= 0.0333333f;
            b -= 0.25f;
        } else {
            b /= 15.0f;
            b -= 0.5f;
            b *= 0.5f;
        }
        return b;
    }

    private double[] offset(double[] input, double x, double y, double z) {
        return new double[]{input[0] + x, input[1] + y, input[2] + z, input[3] + x, input[4] + y, input[5] + z};
    }
}

