/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;

public class BukkitDoor
implements BukkitShapeModel {
    private static final double doorWidthOpen = 0.1875;

    private static final BlockFace getWhereTheDoorIsFace(BlockFace facing, Door.Hinge hinge, boolean isOpen) {
        switch (facing) {
            case NORTH: {
                if (isOpen) {
                    if (hinge == Door.Hinge.LEFT) {
                        return BlockFace.WEST;
                    }
                    return BlockFace.EAST;
                }
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                if (isOpen) {
                    if (hinge == Door.Hinge.LEFT) {
                        return BlockFace.EAST;
                    }
                    return BlockFace.WEST;
                }
                return BlockFace.NORTH;
            }
            case EAST: {
                if (isOpen) {
                    if (hinge == Door.Hinge.LEFT) {
                        return BlockFace.NORTH;
                    }
                    return BlockFace.SOUTH;
                }
                return BlockFace.WEST;
            }
            case WEST: {
                if (isOpen) {
                    if (hinge == Door.Hinge.LEFT) {
                        return BlockFace.SOUTH;
                    }
                    return BlockFace.NORTH;
                }
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            boolean isOpen = door.isOpen();
            double doorWidth = 0.1875;
            switch (BukkitDoor.getWhereTheDoorIsFace(door.getFacing(), door.getHinge(), isOpen)) {
                case NORTH: {
                    return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.1875};
                }
                case SOUTH: {
                    return new double[]{0.0, 0.0, 0.8125, 1.0, 1.0, 1.0};
                }
                case EAST: {
                    return new double[]{0.8125, 0.0, 0.0, 1.0, 1.0, 1.0};
                }
                case WEST: {
                    return new double[]{0.0, 0.0, 0.0, 0.1875, 1.0, 1.0};
                }
            }
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }
}

