/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit.model;

import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;

public abstract class AbstractBukkitCentered
implements BukkitShapeModel {
    private final double minDist;
    private final double maxDist;
    private final double length;
    protected final boolean invertFace;

    public AbstractBukkitCentered(double inset, double length, boolean invertFace) {
        this.minDist = inset;
        this.maxDist = 1.0 - inset;
        this.length = length;
        this.invertFace = invertFace;
    }

    protected abstract BlockFace getFacing(BlockData var1);

    @Override
    public double[] getShape(BlockCache blockCache, World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        BlockState state = block.getState();
        BlockData blockData = state.getBlockData();
        BlockFace facing = this.invertFace ? this.getFacing(blockData).getOppositeFace() : this.getFacing(blockData);
        switch (facing) {
            case EAST: {
                return new double[]{0.0, this.minDist, this.minDist, this.length, this.maxDist, this.maxDist};
            }
            case WEST: {
                return new double[]{1.0 - this.length, this.minDist, this.minDist, 1.0, this.maxDist, this.maxDist};
            }
            case SOUTH: {
                return new double[]{this.minDist, this.minDist, 0.0, this.maxDist, this.maxDist, this.length};
            }
            case NORTH: {
                return new double[]{this.minDist, this.minDist, 1.0 - this.length, this.maxDist, this.maxDist, 1.0};
            }
            case DOWN: {
                return new double[]{this.minDist, 1.0 - this.length, this.minDist, this.maxDist, 1.0, this.maxDist};
            }
            case UP: {
                return new double[]{this.minDist, 0.0, this.minDist, this.maxDist, this.length, this.maxDist};
            }
        }
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public int getFakeData(BlockCache blockCache, World world, int x, int y, int z) {
        return 0;
    }
}

