/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.AttribUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeAttribute;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class NSBukkitAttributeAccess
implements IAttributeAccess {
    public NSBukkitAttributeAccess() {
        if (ReflectionUtil.getClass("org.bukkit.attribute.AttributeInstance") == null) {
            throw new RuntimeException("Service not available.");
        }
    }

    private int operationToInt(AttributeModifier.Operation operation) {
        switch (operation) {
            case ADD_NUMBER: {
                return 0;
            }
            case ADD_SCALAR: {
                return 1;
            }
            case MULTIPLY_SCALAR_1: {
                return 2;
            }
        }
        throw new RuntimeException("Unknown operation: " + operation);
    }

    private AttributeModifier getModifier(AttributeInstance attrInst, NamespacedKey id) {
        for (AttributeModifier mod : attrInst.getModifiers()) {
            if (!id.equals((Object)mod.getKey())) continue;
            return mod;
        }
        return null;
    }

    private double getMultiplier(AttributeModifier mod) {
        return AttribUtil.getMultiplier(this.operationToInt(mod.getOperation()), mod.getAmount());
    }

    @Override
    public double getSpeedMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.MOVEMENT_SPEED);
        double val = attrInst.getValue() / attrInst.getBaseValue();
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.NSID_SPRINT_BOOST);
        return mod == null ? val : val / this.getMultiplier(mod);
    }

    @Override
    public double getSprintMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.MOVEMENT_SPEED);
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.NSID_SPRINT_BOOST);
        return mod == null ? 1.0 : this.getMultiplier(mod);
    }

    @Override
    public float getMovementSpeed(Player player) {
        return player.getWalkSpeed() / 2.0f * (float)this.getSpeedMultiplier(player);
    }

    @Override
    public double getGravity(Player player) {
        if (!BridgeMisc.hasGravity((LivingEntity)player)) {
            return 0.0;
        }
        PlayerMoveData thisMove = DataManager.getPlayerData((Player)player).getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.GRAVITY);
        double gravity = attrInst == null ? (thisMove.yDistance <= 0.0 && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player)) ? 0.01 : 0.08) : MathUtil.clamp(attrInst.getValue(), -1.0, 1.0);
        if (thisMove.yDistance <= 0.0 && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player))) {
            gravity = Math.min(gravity, 0.01);
        }
        return gravity;
    }

    @Override
    public double getSafeFallDistance(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.SAFE_FALL_DISTANCE);
        if (attrInst == null) {
            return 3.0;
        }
        return MathUtil.clamp(attrInst.getValue(), -1024.0, 1024.0);
    }

    @Override
    public double getFallDamageMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.FALL_DAMAGE_MULTIPLIER);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 1.0, 100.0);
    }

    @Override
    public double getBreakingSpeedMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.BLOCK_BREAK_SPEED);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 1.0, 1024.0);
    }

    @Override
    public double getJumpGainMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.JUMP_STRENGTH);
        if (attrInst == null) {
            return 1.0;
        }
        double toMultiplier = attrInst.getValue() / attrInst.getBaseValue();
        return MathUtil.clamp(toMultiplier, 0.0, 76.19047619047619);
    }

    @Override
    public double getPlayerSneakingFactor(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.SNEAKING_SPEED);
        if (attrInst == null) {
            return 0.3f + BridgeEnchant.getSwiftSneakIncrement(player);
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 1.0);
    }

    @Override
    public double getPlayerMaxBlockReach(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.INTERACTION_RANGE);
        if (attrInst == null) {
            return 4.5;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 64.0);
    }

    @Override
    public double getPlayerMaxAttackReach(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.ATTACK_RANGE);
        if (attrInst == null) {
            return 3.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 64.0);
    }

    @Override
    public double getMaxStepUp(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.STEP_HEIGHT);
        if (attrInst == null) {
            if (player.isInsideVehicle()) {
                if (player.getVehicle() != null && MaterialUtil.isBoat(player.getVehicle().getType())) {
                    return 0.0;
                }
                return 1.0;
            }
            MovingConfig cc = DataManager.getPlayerData(player).getGenericInstance(MovingConfig.class);
            return cc.sfStepHeight;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 10.0);
    }

    @Override
    public float getMovementEfficiency(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.MOVEMENT_EFFICIENCY);
        if (attrInst == null) {
            return 0.0f;
        }
        return (float)MathUtil.clamp(attrInst.getValue(), 0.0, 1.0);
    }

    @Override
    public float getWaterMovementEfficiency(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_8)) {
            return 0.0f;
        }
        float depthStrider = BridgeEnchant.getDepthStriderLevel(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_21)) {
            return depthStrider;
        }
        if (ServerVersion.isLowerThan("1.21")) {
            return depthStrider / 3.0f;
        }
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.WATER_MOVEMENT_EFFICIENCY);
        if (attrInst == null) {
            return 0.0f;
        }
        return (float)MathUtil.clamp(attrInst.getValue(), 0.0, 1.0);
    }

    @Override
    public double getSubmergedMiningSpeedMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.SUBMERGED_MINING_SPEED);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 20.0);
    }

    @Override
    public double getMiningEfficiency(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.MINING_EFFICIENCY);
        if (attrInst == null) {
            return 0.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 1024.0);
    }

    @Override
    public double getEntityScale(Player player) {
        AttributeInstance attrInst = player.getAttribute(BridgeAttribute.SCALE);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0625, 16.0);
    }
}

