/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEntityType;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgePotionEffect;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.entity.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.potion.PotionEffectType;

public class MCAccessBukkitBase
implements MCAccess {
    protected final boolean bukkitHasGetHeightAndGetWidth;
    protected final Set<Material> processedBlocks = new LinkedHashSet<Material>();

    public MCAccessBukkitBase() {
        this.testItchyBlock();
        this.bukkitHasGetHeightAndGetWidth = ReflectionUtil.getMethodNoArgs(Entity.class, "getHeight", Double.TYPE) != null && ReflectionUtil.getMethodNoArgs(Entity.class, "getWidth", Double.TYPE) != null;
    }

    private boolean guessItchyBlockPre1_13(Material mat) {
        return !mat.isOccluding() || !mat.isSolid() || mat.isTransparent();
    }

    protected boolean guessItchyBlock(Material mat) {
        if (this.processedBlocks.contains(mat) || BlockProperties.isAir(mat) || BlockProperties.isLiquid(mat)) {
            return false;
        }
        long flags = BlockFlags.getBlockFlags(mat);
        if (BlockFlags.hasAnyFlag(flags, BlockFlags.F_IGN_PASSABLE)) {
            return !BlockFlags.hasNoFlags(flags, BlockFlags.F_GROUND_HEIGHT | BlockFlags.F_GROUND | BlockFlags.F_SOLID);
        }
        long testFlags1 = BlockFlags.F_SOLID | BlockFlags.F_XZ100;
        long testFlags2 = BlockFlags.F_HEIGHT100;
        if (BlockFlags.hasAllFlags(flags, testFlags1) && BlockFlags.hasAnyFlag(flags, testFlags2)) {
            return false;
        }
        return this.guessItchyBlockPre1_13(mat);
    }

    private void testItchyBlock() {
        this.guessItchyBlockPre1_13(Material.AIR);
    }

    @Override
    public String getMCVersion() {
        return "1.13-1.20";
    }

    @Override
    public String getServerVersionTag() {
        return "Bukkit-API";
    }

    @Override
    public CommandMap getCommandMap() {
        try {
            return (CommandMap)ReflectionUtil.invokeMethodNoArgs(Bukkit.getServer(), "getCommandMap", new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public BlockCache getBlockCache() {
        return this.getBlockCache(null);
    }

    @Override
    public BlockCache getBlockCache(World world) {
        return new BlockCacheBukkit(world);
    }

    @Override
    public double getHeight(Entity entity) {
        double entityHeight = this.bukkitHasGetHeightAndGetWidth ? entity.getHeight() : 1.0;
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    @Override
    public AlmostBoolean isBlockSolid(Material mat) {
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(mat.isSolid());
    }

    private final double legacyGetWidth(Entity entity) {
        EntityType type = entity.getType();
        Double width = BridgeEntityType.LEGACY_ENTITY_WIDTH.get(type);
        if (width != null) {
            return width;
        }
        switch (type) {
            case SNOWBALL: {
                return 0.25;
            }
            case CHICKEN: 
            case SILVERFISH: {
                return 0.3f;
            }
            case SMALL_FIREBALL: 
            case WITHER_SKULL: {
                return 0.3125;
            }
            case GHAST: {
                return 0.4f;
            }
            case ARROW: 
            case BAT: 
            case EXPERIENCE_ORB: 
            case ITEM_FRAME: 
            case PAINTING: {
                return 0.5;
            }
            case PLAYER: 
            case ZOMBIE: 
            case SKELETON: 
            case CREEPER: 
            case ENDERMAN: 
            case OCELOT: 
            case BLAZE: 
            case VILLAGER: 
            case WITCH: 
            case WOLF: {
                return 0.6f;
            }
            case CAVE_SPIDER: {
                return 0.7f;
            }
            case COW: 
            case PIG: 
            case SHEEP: 
            case WITHER: {
                return 0.9f;
            }
            case SQUID: {
                return 0.95f;
            }
            case FIREBALL: {
                return 1.0;
            }
            case IRON_GOLEM: 
            case SPIDER: {
                return 1.4f;
            }
            case GIANT: {
                return 3.6f;
            }
            case ENDER_DRAGON: {
                return 16.0;
            }
            case SLIME: 
            case MAGMA_CUBE: {
                if (!(entity instanceof Slime)) break;
                return 0.6f * (float)((Slime)entity).getSize();
            }
        }
        if (MaterialUtil.isBoat(entity.getType())) {
            return ServerVersion.isHigherThan("1.8") ? 1.396484375 : (double)1.4f;
        }
        if (entity instanceof Minecart) {
            return 0.98f;
        }
        try {
            switch (type) {
                case HORSE: {
                    return 1.4f;
                }
                case ENDERMITE: {
                    return 0.4f;
                }
                case ARMOR_STAND: {
                    return 0.5;
                }
                case RABBIT: {
                    return 0.6f;
                }
                case GUARDIAN: {
                    return 0.95f;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0.6f;
    }

    @Override
    public double getWidth(Entity entity) {
        if (this.bukkitHasGetHeightAndGetWidth) {
            return entity.getWidth();
        }
        return this.legacyGetWidth(entity);
    }

    @Override
    public AlmostBoolean isBlockLiquid(Material mat) {
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        if (MaterialUtil.WATER.contains(mat) || MaterialUtil.LAVA.contains(mat)) {
            return AlmostBoolean.YES;
        }
        return AlmostBoolean.NO;
    }

    @Override
    public AlmostBoolean isIllegalBounds(Player player) {
        if (player.isDead()) {
            return AlmostBoolean.NO;
        }
        if (!player.isSleeping()) {
            // empty if block
        }
        return AlmostBoolean.MAYBE;
    }

    @Override
    public double getJumpAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.JUMP_BOOST);
    }

    @Override
    public double getFasterMovementAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.SPEED);
    }

    @Override
    public int getInvulnerableTicks(Player player) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setInvulnerableTicks(Player player, int ticks) {
    }

    @Override
    public void dealFallDamage(Player player, double damage) {
        BridgeHealth.damage((LivingEntity)player, damage);
    }

    @Override
    public boolean isComplexPart(Entity entity) {
        return entity instanceof ComplexEntityPart || entity instanceof ComplexLivingEntity;
    }

    @Override
    public boolean shouldBeZombie(Player player) {
        return BridgeHealth.getHealth((LivingEntity)player) <= 0.0 && !player.isDead();
    }

    @Override
    public void setDead(Player player, int deathTicks) {
        BridgeHealth.setHealth((LivingEntity)player, 0.0);
        BridgeHealth.damage((LivingEntity)player, 1.0);
    }

    @Override
    public boolean hasGravity(Material mat) {
        try {
            return mat.hasGravity();
        }
        catch (Throwable t) {
            switch (mat) {
                case SAND: 
                case GRAVEL: {
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.NO;
    }

    @Override
    public boolean resetActiveItem(Player player) {
        return false;
    }
}

