/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.AttribUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeBukkitAPI;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import java.util.UUID;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BukkitAttributeAccess
implements IAttributeAccess {
    public BukkitAttributeAccess() {
        if (ReflectionUtil.getClass("org.bukkit.attribute.AttributeInstance") == null) {
            throw new RuntimeException("Service not available.");
        }
    }

    private int operationToInt(AttributeModifier.Operation operation) {
        switch (operation) {
            case ADD_NUMBER: {
                return 0;
            }
            case ADD_SCALAR: {
                return 1;
            }
            case MULTIPLY_SCALAR_1: {
                return 2;
            }
        }
        throw new RuntimeException("Unknown operation: " + operation);
    }

    private AttributeModifier getModifier(AttributeInstance attrInst, UUID id) {
        for (AttributeModifier mod : attrInst.getModifiers()) {
            if (!id.equals(mod.getUniqueId())) continue;
            return mod;
        }
        return null;
    }

    private double getMultiplier(AttributeModifier mod) {
        return AttribUtil.getMultiplier(this.operationToInt(mod.getOperation()), mod.getAmount());
    }

    @Override
    public float getMovementSpeed(Player player) {
        return player.getWalkSpeed() / 2.0f * (float)this.getSpeedMultiplier(player);
    }

    @Override
    public double getSpeedMultiplier(Player player) {
        AttributeInstance attrInst = BridgeBukkitAPI.getSpeedAttributeInstance(player);
        double val = attrInst.getValue() / attrInst.getBaseValue();
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.ID_SPRINT_BOOST);
        return mod == null ? val : val / this.getMultiplier(mod);
    }

    @Override
    public double getSprintMultiplier(Player player) {
        AttributeInstance attrInst = BridgeBukkitAPI.getSpeedAttributeInstance(player);
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.ID_SPRINT_BOOST);
        return mod == null ? 1.0 : this.getMultiplier(mod);
    }

    @Override
    public double getGravity(Player player) {
        double gravity;
        PlayerMoveData thisMove = DataManager.getPlayerData((Player)player).getGenericInstance(MovingData.class).playerMoves.getCurrentMove();
        if (!BridgeMisc.hasGravity((LivingEntity)player)) {
            return 0.0;
        }
        if (ServerVersion.isLowerThan("1.20.5")) {
            gravity = thisMove.yDistance <= 0.0 && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player)) ? 0.01 : 0.08;
        } else {
            AttributeInstance attrInst = BridgeBukkitAPI.getGravityAttributeInstance(player);
            gravity = attrInst == null ? (thisMove.yDistance <= 0.0 && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player)) ? 0.01 : 0.08) : MathUtil.clamp(attrInst.getValue(), -1.0, 1.0);
            if (thisMove.yDistance <= 0.0 && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player))) {
                gravity = Math.min(gravity, 0.01);
            }
        }
        return gravity;
    }

    @Override
    public double getSafeFallDistance(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 3.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getSafeFallAttributeInstance(player);
        if (attrInst == null) {
            return 3.0;
        }
        return MathUtil.clamp(attrInst.getValue(), -1024.0, 1024.0);
    }

    @Override
    public double getFallDamageMultiplier(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 1.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getFallMultAttributeInstance(player);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 1.0, 100.0);
    }

    @Override
    public double getBreakingSpeedMultiplier(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 1.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getBreakSpeedAttributeInstance(player);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 1.0, 1024.0);
    }

    @Override
    public double getJumpGainMultiplier(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 1.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getJumpPowerAttributeInstance(player);
        if (attrInst == null) {
            return 1.0;
        }
        double val = attrInst.getValue() / attrInst.getBaseValue();
        return MathUtil.clamp(val, 0.0, 76.19047619047619);
    }

    @Override
    public double getPlayerSneakingFactor(Player player) {
        return 0.3f + BridgeEnchant.getSwiftSneakIncrement(player);
    }

    @Override
    public double getPlayerMaxBlockReach(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 4.5;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getBlockInteractionRangeAttributeInstance(player);
        if (attrInst == null) {
            return 4.5;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 64.0);
    }

    @Override
    public double getPlayerMaxAttackReach(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 3.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getEntityInteractionRangeAttributeInstance(player);
        if (attrInst == null) {
            return 3.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 64.0);
    }

    @Override
    public double getMaxStepUp(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            if (player.isInsideVehicle()) {
                if (player.getVehicle() != null && MaterialUtil.isBoat(player.getVehicle().getType())) {
                    return 0.0;
                }
                return 1.0;
            }
            MovingConfig cc = DataManager.getPlayerData(player).getGenericInstance(MovingConfig.class);
            return cc.sfStepHeight;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getStepHeightAttributeInstance(player);
        if (attrInst == null) {
            if (player.isInsideVehicle()) {
                if (player.getVehicle() != null && MaterialUtil.isBoat(player.getVehicle().getType())) {
                    return 0.0;
                }
                return 1.0;
            }
            MovingConfig cc = DataManager.getPlayerData(player).getGenericInstance(MovingConfig.class);
            return cc.sfStepHeight;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0, 10.0);
    }

    @Override
    public float getWaterMovementEfficiency(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_8)) {
            return 0.0f;
        }
        float depthStrider = BridgeEnchant.getDepthStriderLevel(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_21)) {
            return depthStrider;
        }
        if (ServerVersion.isLowerThan("1.21")) {
            return depthStrider / 3.0f;
        }
        return depthStrider;
    }

    @Override
    public float getMovementEfficiency(Player player) {
        return 0.0f;
    }

    @Override
    public double getSubmergedMiningSpeedMultiplier(Player player) {
        return 1.0;
    }

    @Override
    public double getMiningEfficiency(Player player) {
        return 0.0;
    }

    @Override
    public double getEntityScale(Player player) {
        if (ServerVersion.isLowerThan("1.20.5")) {
            return 1.0;
        }
        AttributeInstance attrInst = BridgeBukkitAPI.getScaleAttributeInstance(player);
        if (attrInst == null) {
            return 1.0;
        }
        return MathUtil.clamp(attrInst.getValue(), 0.0625, 16.0);
    }
}

