/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import org.bukkit.potion.PotionEffectType;

public class BridgePotionEffect {
    public static final PotionEffectType SLOWNESS = BridgePotionEffect.getFirstNotNull("SLOWNESS", "SLOW");
    public static final PotionEffectType HASTE = BridgePotionEffect.getFirstNotNull("HASTE", "FAST_DIGGING");
    public static final PotionEffectType MINING_FATIGUE = BridgePotionEffect.getFirstNotNull("MINING_FATIGUE", "SLOW_DIGGING");
    public static final PotionEffectType JUMP_BOOST = BridgePotionEffect.getFirstNotNull("JUMP_BOOST", "JUMP");
    public static final PotionEffectType WEAVING = BridgePotionEffect.getFirst("WEAVING");

    private static final PotionEffectType parsePotionEffect(String name) {
        try {
            return PotionEffectType.getByName((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PotionEffectType getFirst(String ... names) {
        for (String name : names) {
            PotionEffectType type = BridgePotionEffect.parsePotionEffect(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static PotionEffectType getFirstNotNull(String ... names) {
        PotionEffectType type = BridgePotionEffect.getFirst(names);
        if (type == null) {
            throw new NullPointerException("PotionEffect not present: " + StringUtil.join(names, ", "));
        }
        return type;
    }
}

