/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class BridgeMaterial {
    private static final Map<String, Material> legacy = new HashMap<String, Material>();
    private static final Map<String, Material> all = new HashMap<String, Material>();
    private static final Map<Material, Material> signblocksmap = new HashMap<Material, Material>();
    public static final Material DIAMOND_SHOVEL;
    public static final Material TRIDENT;
    public static final Material NETHERITE_AXE;
    public static final Material NETHERITE_HOE;
    public static final Material NETHERITE_PICKAXE;
    public static final Material NETHERITE_SHOVEL;
    public static final Material NETHERITE_SWORD;
    public static final Material GOLDEN_AXE;
    public static final Material GOLDEN_HOE;
    public static final Material GOLDEN_PICKAXE;
    public static final Material GOLDEN_SHOVEL;
    public static final Material GOLDEN_SWORD;
    public static final Material IRON_SHOVEL;
    public static final Material STONE_SHOVEL;
    public static final Material WOODEN_AXE;
    public static final Material WOODEN_HOE;
    public static final Material WOODEN_PICKAXE;
    public static final Material WOODEN_SHOVEL;
    public static final Material WOODEN_SWORD;
    public static final Material SEA_LANTERN;
    public static final Material COMPOSTER;
    public static final Material CONDUIT;
    public static final Material BARREL;
    public static final Material BEETROOTS;
    public static final Material BRICKS;
    public static final Material BRICK_SLAB;
    public static final Material CAKE;
    public static final Material CARROTS;
    public static final Material CAVE_AIR;
    public static final Material CHAIN_COMMAND_BLOCK;
    public static final Material COBBLESTONE_WALL;
    public static final Material COBWEB;
    public static final Material COMMAND_BLOCK;
    public static final Material CRAFTING_TABLE;
    public static final Material DANDELION;
    public static final Material ENCHANTING_TABLE;
    public static final Material END_PORTAL;
    public static final Material END_PORTAL_FRAME;
    public static final Material END_STONE;
    public static final Material END_STONE_BRICKS;
    public static final Material FARMLAND;
    public static final Material FIREWORK_ROCKET;
    public static final Material GRASS;
    public static final Material GRASS_BLOCK;
    public static final Material GRASS_PATH;
    public static final Material HEAVY_WEIGHTED_PRESSURE_PLATE;
    public static final Material IRON_BARS;
    public static final Material IRON_DOOR;
    public static final Material LIGHT_WEIGHTED_PRESSURE_PLATE;
    public static final Material LILY_PAD;
    public static final Material MAGMA_BLOCK;
    public static final Material MELON;
    public static final Material MOVING_PISTON;
    public static final Material MYCELIUM;
    public static final Material NETHER_BRICKS;
    public static final Material NETHER_BRICK_FENCE;
    public static final Material NETHER_PORTAL;
    public static final Material NETHER_QUARTZ_ORE;
    public static final Material NETHER_WARTS;
    public static final Material OAK_LOG;
    public static final Material OAK_WOOD;
    public static final Material OAK_TRAPDOOR;
    public static final Material PISTON;
    public static final Material PISTON_HEAD;
    public static final Material POTATOES;
    public static final Material RED_NETHER_BRICKS;
    public static final Material REPEATER;
    public static final Material REPEATING_COMMAND_BLOCK;
    public static final Material SCAFFOLDING;
    public static final Material SIGN;
    public static final Material SKELETON_SKULL;
    public static final Material SPAWNER;
    public static final Material STICKY_PISTON;
    public static final Material STONE_BRICKS;
    public static final Material STONE_BRICK_STAIRS;
    public static final Material STONE_PRESSURE_PLATE;
    public static final Material WOODEN_PRESSURE_PLATE;
    public static final Material STONE_SLAB;
    public static final Material SUGAR_CANE;
    public static final Material TALL_GRASS;
    public static final Material TERRACOTTA;
    public static final Material VOID_AIR;
    public static final Material FROGSPAWN;
    public static final Material WHEAT_CROPS;

    public static Material getSignItemFromBlock(Material mat) {
        return signblocksmap.get(mat);
    }

    public static Material legacy(String name) {
        return legacy.get(name.toLowerCase());
    }

    public static Material get(String name) {
        return all.get(name.toLowerCase());
    }

    public static Material getBlock(String name) {
        Material mat = BridgeMaterial.get(name);
        if (mat == null || !mat.isBlock()) {
            return null;
        }
        return mat;
    }

    public static Material getNotNull(String name) {
        Material mat = BridgeMaterial.get(name);
        if (mat == null) {
            throw new NullPointerException("Material not present: " + name);
        }
        return mat;
    }

    public static Material getFirst(String ... names) {
        for (String name : names) {
            Material mat = BridgeMaterial.get(name);
            if (mat == null) continue;
            return mat;
        }
        return null;
    }

    public static Material getFirstNotNull(String ... names) {
        Material mat = BridgeMaterial.getFirst(names);
        if (mat == null) {
            throw new NullPointerException("Material not present: " + StringUtil.join(names, ", "));
        }
        return mat;
    }

    public static Set<Material> getAll(String ... names) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        for (String name : names) {
            Material mat = BridgeMaterial.get(name);
            if (mat == null) continue;
            res.add(mat);
        }
        return res;
    }

    public static Set<Material> getAllBlocks(String ... names) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        for (String name : names) {
            Material mat = BridgeMaterial.get(name);
            if (mat == null || !mat.isBlock()) continue;
            res.add(mat);
        }
        return res;
    }

    public static boolean has(String name) {
        return all.containsKey(name.toLowerCase());
    }

    private static void getBySuffix(String suffix, AlmostBoolean isBlock, SimpleCharPrefixTree excludePrefixTree, Set<Material> res) {
        for (Map.Entry<String, Material> entry : all.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith(suffix) || excludePrefixTree.hasPrefix(key)) continue;
            Material value = entry.getValue();
            if (isBlock != AlmostBoolean.MAYBE && isBlock.decide() ^ value.isBlock()) continue;
            res.add(value);
        }
    }

    public static Set<Material> getBySuffix(String suffix, AlmostBoolean isBlock, String ... excludePrefixes) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        SimpleCharPrefixTree prefixTree = new SimpleCharPrefixTree();
        prefixTree.feedAll(Arrays.asList(excludePrefixes), false, true);
        BridgeMaterial.getBySuffix(suffix.toLowerCase(), isBlock, prefixTree, res);
        return res;
    }

    public static Set<Material> getBySuffix(Collection<String> suffices, AlmostBoolean isBlock, String ... excludePrefixes) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        SimpleCharPrefixTree prefixTree = new SimpleCharPrefixTree();
        prefixTree.feedAll(Arrays.asList(excludePrefixes), false, true);
        for (String suffix : suffices) {
            BridgeMaterial.getBySuffix(suffix.toLowerCase(), isBlock, prefixTree, res);
        }
        return res;
    }

    public static Set<Material> getByPrefix(String prefix, AlmostBoolean isBlock) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        for (Map.Entry<String, Material> entry : all.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            Material value = entry.getValue();
            if (isBlock != AlmostBoolean.MAYBE && isBlock.decide() ^ value.isBlock()) continue;
            res.add(value);
        }
        return res;
    }

    public static Set<Material> getByContains(AlmostBoolean isBlock, Collection<String> contains, String ... excludeContains) {
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        LinkedList<String> useExcludeContains = new LinkedList<String>();
        for (String exclude : excludeContains) {
            useExcludeContains.add(exclude.toLowerCase());
        }
        for (Map.Entry entry : all.entrySet()) {
            String key = (String)entry.getKey();
            for (String s : contains) {
                if (!key.contains(s)) continue;
                Material value = (Material)entry.getValue();
                if (isBlock != AlmostBoolean.MAYBE && isBlock.decide() ^ value.isBlock()) continue;
                boolean match = true;
                for (String exclude : useExcludeContains) {
                    if (!key.contains(exclude)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                res.add(value);
            }
        }
        return res;
    }

    public static Set<Material> getByPrefixAndSuffix(Collection<String> prefixes, Collection<String> suffices, AlmostBoolean isBlock, String ... excludeContains) {
        SimpleCharPrefixTree prefixTree;
        LinkedHashSet<Material> res = new LinkedHashSet<Material>();
        LinkedList<String> useExcludeContains = new LinkedList<String>();
        for (String exclude : excludeContains) {
            useExcludeContains.add(exclude.toLowerCase());
        }
        if (prefixes == null) {
            prefixTree = null;
        } else {
            prefixTree = new SimpleCharPrefixTree();
            prefixTree.feedAll(prefixes, false, true);
        }
        SimpleCharPrefixTree suffixTree = new SimpleCharPrefixTree();
        for (String suffix : suffices) {
            suffixTree.feed(StringUtil.reverse(suffix.toLowerCase()));
        }
        boolean isBlockDecided = isBlock.decide();
        for (Map.Entry<String, Material> entry : all.entrySet()) {
            String key = entry.getKey();
            if (prefixTree != null && !prefixTree.hasPrefix(key) || !suffixTree.hasPrefix(StringUtil.reverse(key))) continue;
            Material value = entry.getValue();
            if (isBlock != AlmostBoolean.MAYBE && isBlockDecided ^ value.isBlock()) continue;
            boolean match = true;
            for (String exclude : useExcludeContains) {
                if (!key.contains(exclude)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            res.add(entry.getValue());
        }
        return res;
    }

    static {
        for (Material mat : Material.values()) {
            String name = mat.name().toLowerCase(Locale.ROOT);
            all.put(name, mat);
            if (name.equals("sign_post") || name.equals("wall_sign")) {
                signblocksmap.put(mat, Material.getMaterial((String)"SIGN"));
            } else if (name.endsWith("_wall_sign") || name.endsWith("_wall_hanging_sign")) {
                signblocksmap.put(mat, Material.getMaterial((String)name.replace("_wall", "").toUpperCase(Locale.ROOT)));
            } else if (name.endsWith("_sign")) {
                signblocksmap.put(mat, mat);
            }
            if (!name.startsWith("legacy_")) continue;
            legacy.put(name.substring(7), mat);
        }
        DIAMOND_SHOVEL = BridgeMaterial.getFirstNotNull("diamond_shovel", "diamond_spade");
        TRIDENT = BridgeMaterial.getFirst("trident");
        NETHERITE_AXE = BridgeMaterial.getFirst("netherite_axe");
        NETHERITE_HOE = BridgeMaterial.getFirst("netherite_hoe");
        NETHERITE_PICKAXE = BridgeMaterial.getFirst("netherite_pickaxe");
        NETHERITE_SHOVEL = BridgeMaterial.getFirst("netherite_shovel");
        NETHERITE_SWORD = BridgeMaterial.getFirst("netherite_sword");
        GOLDEN_AXE = BridgeMaterial.getFirstNotNull("golden_axe", "gold_axe");
        GOLDEN_HOE = BridgeMaterial.getFirstNotNull("golden_hoe", "gold_hoe");
        GOLDEN_PICKAXE = BridgeMaterial.getFirstNotNull("golden_pickaxe", "gold_pickaxe");
        GOLDEN_SHOVEL = BridgeMaterial.getFirstNotNull("golden_shovel", "gold_spade");
        GOLDEN_SWORD = BridgeMaterial.getFirstNotNull("golden_sword", "gold_sword");
        IRON_SHOVEL = BridgeMaterial.getFirstNotNull("iron_shovel", "iron_spade");
        STONE_SHOVEL = BridgeMaterial.getFirstNotNull("stone_shovel", "stone_spade");
        WOODEN_AXE = BridgeMaterial.getFirstNotNull("wooden_axe", "wood_axe");
        WOODEN_HOE = BridgeMaterial.getFirstNotNull("wooden_hoe", "wood_hoe");
        WOODEN_PICKAXE = BridgeMaterial.getFirstNotNull("wooden_pickaxe", "wood_pickaxe");
        WOODEN_SHOVEL = BridgeMaterial.getFirstNotNull("wooden_shovel", "wood_spade");
        WOODEN_SWORD = BridgeMaterial.getFirstNotNull("wooden_sword", "wood_sword");
        SEA_LANTERN = BridgeMaterial.get("sea_lantern");
        COMPOSTER = BridgeMaterial.get("composter");
        CONDUIT = BridgeMaterial.get("conduit");
        BARREL = BridgeMaterial.get("barrel");
        BEETROOTS = BridgeMaterial.getFirst("beetroots", "beetroot_block");
        BRICKS = BridgeMaterial.getFirst("bricks", "brick");
        BRICK_SLAB = BridgeMaterial.getFirst("brick_slab");
        CAKE = BridgeMaterial.getFirstNotNull("cake_block", "cake");
        CARROTS = BridgeMaterial.getFirst("carrots", "carrot");
        CAVE_AIR = BridgeMaterial.getFirst("cave_air");
        CHAIN_COMMAND_BLOCK = BridgeMaterial.getFirst("chain_command_block", "command_chain");
        COBBLESTONE_WALL = BridgeMaterial.getFirstNotNull("cobblestone_wall", "cobble_wall");
        COBWEB = BridgeMaterial.getFirstNotNull("cobweb", "web");
        COMMAND_BLOCK = BridgeMaterial.getFirstNotNull("command_block", "command");
        CRAFTING_TABLE = BridgeMaterial.getFirstNotNull("crafting_table", "workbench");
        DANDELION = BridgeMaterial.getFirstNotNull("dandelion", "yellow_flower");
        ENCHANTING_TABLE = BridgeMaterial.getFirstNotNull("enchanting_table", "enchantment_table");
        END_PORTAL = BridgeMaterial.getFirstNotNull("end_portal", "ender_portal");
        END_PORTAL_FRAME = BridgeMaterial.getFirstNotNull("end_portal_frame", "ender_portal_frame");
        END_STONE = BridgeMaterial.getFirstNotNull("end_stone", "ender_stone");
        END_STONE_BRICKS = BridgeMaterial.getFirst("end_stone_bricks", "end_bricks");
        FARMLAND = BridgeMaterial.getFirstNotNull("farmland", "soil");
        FIREWORK_ROCKET = BridgeMaterial.getFirst("firework_rocket", "firework");
        GRASS = BridgeMaterial.getFirstNotNull("short_grass", "long_grass", "grass");
        GRASS_BLOCK = BridgeMaterial.getFirstNotNull("grass_block", "grass");
        GRASS_PATH = BridgeMaterial.getFirst("grass_path", "dirt_path");
        HEAVY_WEIGHTED_PRESSURE_PLATE = BridgeMaterial.getFirstNotNull("heavy_weighted_pressure_plate", "iron_plate");
        IRON_BARS = BridgeMaterial.getFirstNotNull("iron_bars", "iron_fence");
        IRON_DOOR = BridgeMaterial.getFirstNotNull("iron_door_block", "iron_door");
        LIGHT_WEIGHTED_PRESSURE_PLATE = BridgeMaterial.getFirstNotNull("light_weighted_pressure_plate", "gold_plate");
        LILY_PAD = BridgeMaterial.getFirstNotNull("lily_pad", "water_lily");
        MAGMA_BLOCK = BridgeMaterial.getFirst("magma_block", "magma");
        MELON = BridgeMaterial.getFirstNotNull("melon_block", "melon");
        MOVING_PISTON = BridgeMaterial.getFirstNotNull("moving_piston", "piston_moving_piece");
        MYCELIUM = BridgeMaterial.getFirstNotNull("mycelium", "mycel");
        NETHER_BRICKS = BridgeMaterial.getFirstNotNull("nether_bricks", "nether_brick");
        NETHER_BRICK_FENCE = BridgeMaterial.getFirstNotNull("nether_brick_fence", "nether_fence");
        NETHER_PORTAL = BridgeMaterial.getFirstNotNull("nether_portal", "portal");
        NETHER_QUARTZ_ORE = BridgeMaterial.getFirstNotNull("nether_quartz_ore", "quartz_ore");
        NETHER_WARTS = BridgeMaterial.getFirstNotNull("nether_warts", "nether_wart");
        OAK_LOG = BridgeMaterial.getFirstNotNull("oak_log", "log");
        OAK_WOOD = BridgeMaterial.getFirstNotNull("oak_wood", "wood");
        OAK_TRAPDOOR = BridgeMaterial.getFirstNotNull("oak_trapdoor", "trap_door");
        PISTON = BridgeMaterial.getFirstNotNull("piston_base", "piston");
        PISTON_HEAD = BridgeMaterial.getFirstNotNull("piston_head", "piston_extension");
        POTATOES = BridgeMaterial.getFirst("potatoes", "potato");
        RED_NETHER_BRICKS = BridgeMaterial.getFirst("red_nether_bricks", "red_nether_brick");
        REPEATER = BridgeMaterial.getFirstNotNull("repeater", "diode_block_off");
        REPEATING_COMMAND_BLOCK = BridgeMaterial.getFirst("repeating_command_block", "command_repeating");
        SCAFFOLDING = BridgeMaterial.get("scaffolding");
        SIGN = BridgeMaterial.getFirstNotNull("bamboo_sign", "cherry_sign", "acacia_sign", "birch_sign", "dark_oak_sign", "jungle_sign", "oak_sign", "spruce_sign", "bamboo_wall_sign", "cherry_wall_sign", "acacia_wall_sign", "birch_wall_sign", "dark_oak_wall_sign", "jungle_wall_sign", "oak_wall_sign", "spruce_wall_sign", "sign_post", "sign", "wall_sign");
        SKELETON_SKULL = BridgeMaterial.getFirst("skeleton_skull", "skull");
        SPAWNER = BridgeMaterial.getFirstNotNull("spawner", "mob_spawner");
        STICKY_PISTON = BridgeMaterial.getFirstNotNull("piston_sticky_base", "sticky_piston");
        STONE_BRICKS = BridgeMaterial.getFirstNotNull("stone_bricks", "smooth_brick");
        STONE_BRICK_STAIRS = BridgeMaterial.getFirstNotNull("stone_brick_stairs", "smooth_stairs");
        STONE_PRESSURE_PLATE = BridgeMaterial.getFirstNotNull("stone_pressure_plate", "stone_plate");
        WOODEN_PRESSURE_PLATE = BridgeMaterial.getFirstNotNull("wooden_pressure_plate", "wood_plate", "acacia_pressure_plate", "birch_pressure_plate", "dark_oak_pressure_plate", "jungle_pressure_plate", "oak_pressure_plate", "spruce_pressure_plate");
        STONE_SLAB = BridgeMaterial.getFirstNotNull("stone_slab", "step");
        SUGAR_CANE = BridgeMaterial.getFirstNotNull("sugar_cane_block", "sugar_cane");
        TALL_GRASS = BridgeMaterial.getFirstNotNull("tall_grass", "long_grass");
        TERRACOTTA = BridgeMaterial.getFirst("terracotta", "hard_clay");
        VOID_AIR = BridgeMaterial.get("void_air");
        FROGSPAWN = BridgeMaterial.get("frogspawn");
        WHEAT_CROPS = BridgeMaterial.getFirstNotNull("crops", "wheat");
    }
}

