/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.EntityType;

public class BridgeEntityType {
    private static final Map<String, EntityType> all = new HashMap<String, EntityType>();
    public static final EntityType EYE_OF_ENDER;
    public static final EntityType EXPERIENCE_BOTTLE;
    public static final EntityType SPLASH_POTION;
    public static final EntityType FIREWORK;
    public static final EntityType FISHING_HOOK;
    public static final EntityType ITEM;
    public static final EntityType SNOW_GOLEM;
    public static final EntityType TNT;
    public static final EntityType MUSHROOM_COW;
    public static final EntityType ENDER_CRYSTAL;
    public static final EntityType LEASH_KNOT;
    public static final EntityType ZOMBIFIED_PIGLIN;
    public static final EntityType WIND_CHARGE;
    public static final Map<EntityType, Double> LEGACY_ENTITY_WIDTH;
    public static final Set<EntityType> PROJECTILE_CHECK_LIST;

    public static EntityType getFirst(String ... names) {
        for (String name : names) {
            EntityType type = BridgeEntityType.get(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static EntityType get(String name) {
        return all.get(name.toLowerCase());
    }

    public static EntityType getFirstNotNull(String ... names) {
        EntityType type = BridgeEntityType.getFirst(names);
        if (type == null) {
            throw new NullPointerException("EntityType not present: " + StringUtil.join(names, ", "));
        }
        return type;
    }

    private static Map<EntityType, Double> init() {
        HashMap<EntityType, Double> map = new HashMap<EntityType, Double>();
        map.put(EYE_OF_ENDER, 0.25);
        map.put(FIREWORK, 0.25);
        map.put(FISHING_HOOK, 0.25);
        map.put(ITEM, 0.25);
        if (MUSHROOM_COW != null) {
            map.put(MUSHROOM_COW, 0.25);
        }
        map.put(TNT, 0.98);
        map.put(SNOW_GOLEM, 0.4);
        map.put(ENDER_CRYSTAL, 2.0);
        if (LEASH_KNOT != null) {
            map.put(LEASH_KNOT, 0.5);
        }
        return map;
    }

    static {
        for (EntityType type : EntityType.values()) {
            String name = type.name().toLowerCase(Locale.ROOT);
            all.put(name, type);
        }
        EYE_OF_ENDER = BridgeEntityType.getFirstNotNull("eye_of_ender", "ender_signal");
        EXPERIENCE_BOTTLE = BridgeEntityType.getFirstNotNull("experience_bottle", "thrown_exp_bottle");
        SPLASH_POTION = BridgeEntityType.getFirstNotNull("potion", "splash_potion");
        FIREWORK = BridgeEntityType.getFirstNotNull("firework", "firework_rocket");
        FISHING_HOOK = BridgeEntityType.getFirstNotNull("fishing_hook", "fishing_bobber");
        ITEM = BridgeEntityType.getFirstNotNull("dropped_item", "item");
        SNOW_GOLEM = BridgeEntityType.getFirstNotNull("snowman", "snow_golem");
        TNT = BridgeEntityType.getFirstNotNull("primed_tnt", "tnt");
        MUSHROOM_COW = BridgeEntityType.getFirst("mushroom_cow");
        ENDER_CRYSTAL = BridgeEntityType.getFirstNotNull("ender_crystal", "end_crystal");
        LEASH_KNOT = BridgeEntityType.getFirst("leash_hitch", "leash_knot");
        ZOMBIFIED_PIGLIN = BridgeEntityType.getFirstNotNull("pig_zombie", "zombified_piglin");
        WIND_CHARGE = BridgeEntityType.getFirst("wind_charge");
        LEGACY_ENTITY_WIDTH = BridgeEntityType.init();
        PROJECTILE_CHECK_LIST = Collections.unmodifiableSet(new HashSet<EntityType>(Arrays.asList(EntityType.ENDER_PEARL, EntityType.EGG, EntityType.SNOWBALL, EYE_OF_ENDER, EXPERIENCE_BOTTLE, SPLASH_POTION)));
    }
}

