/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class BridgeEnchant {
    private static final Enchantment DEPTH_STRIDER = BridgeEnchant.parseEnchantment("DEPTH_STRIDER");
    private static final Enchantment THORNS = BridgeEnchant.parseEnchantment("THORNS");
    private static final Enchantment RIPTIDE = BridgeEnchant.parseEnchantment("RIPTIDE");
    private static final Enchantment FEATHER_FALLING = BridgeEnchant.getFirstNotNull("FEATHER_FALLING", "PROTECTION_FALL");
    private static final Enchantment SOUL_SPEED = BridgeEnchant.parseEnchantment("SOUL_SPEED");
    private static final Enchantment SWIFT_SNEAK = BridgeEnchant.parseEnchantment("SWIFT_SNEAK");
    public static final Enchantment EFFICIENCY = BridgeEnchant.getFirstNotNull("EFFICIENCY", "DIG_SPEED");
    public static final Enchantment AQUA_AFFINITY = BridgeEnchant.getFirstNotNull("AQUA_AFFINITY", "WATER_WORKER");

    private static Enchantment parseEnchantment(String name) {
        try {
            return Enchantment.getByName((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Enchantment getFirst(String ... names) {
        for (String name : names) {
            Enchantment type = BridgeEnchant.parseEnchantment(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static Enchantment getFirstNotNull(String ... names) {
        Enchantment type = BridgeEnchant.getFirst(names);
        if (type == null) {
            throw new NullPointerException("Enchant not present: " + StringUtil.join(names, ", "));
        }
        return type;
    }

    private static int getMaxLevelArmor(Player player, Enchantment enchantment) {
        ItemStack[] armor;
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        for (ItemStack item : armor = player.getInventory().getArmorContents()) {
            if (BlockProperties.isAir(item)) continue;
            level = Math.max(item.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static int getHelmetLevelArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack armor = player.getInventory().getHelmet();
        if (!BlockProperties.isAir(armor)) {
            level = Math.max(armor.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static int getChestplateLevelArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack armor = player.getInventory().getChestplate();
        if (!BlockProperties.isAir(armor)) {
            level = Math.max(armor.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static int getLeggingsLevelArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack armor = player.getInventory().getLeggings();
        if (!BlockProperties.isAir(armor)) {
            level = Math.max(armor.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static int getBootsLevelArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack armor = player.getInventory().getBoots();
        if (!BlockProperties.isAir(armor)) {
            level = Math.max(armor.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static boolean hasArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getArmorContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getEnchantmentLevel(enchantment) <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean hasHelmet(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        ItemStack contents = player.getInventory().getHelmet();
        return contents != null && contents.getEnchantmentLevel(enchantment) > 0;
    }

    private static boolean hasChestplate(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        ItemStack contents = player.getInventory().getChestplate();
        return contents != null && contents.getEnchantmentLevel(enchantment) > 0;
    }

    private static boolean hasLeggings(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        ItemStack contents = player.getInventory().getLeggings();
        return contents != null && contents.getEnchantmentLevel(enchantment) > 0;
    }

    private static boolean hasBoots(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        ItemStack contents = player.getInventory().getBoots();
        return contents != null && contents.getEnchantmentLevel(enchantment) > 0;
    }

    public static boolean hasThorns() {
        return THORNS != null;
    }

    public static boolean hasDepthStrider() {
        return DEPTH_STRIDER != null;
    }

    public static boolean hasFeatherFalling() {
        return FEATHER_FALLING != null;
    }

    public static boolean hasSoulSpeed() {
        return SOUL_SPEED != null;
    }

    public static boolean hasSwiftSneak() {
        return SWIFT_SNEAK != null;
    }

    public static boolean hasThorns(Player player) {
        return BridgeEnchant.hasArmor(player, THORNS);
    }

    public static boolean hasSoulSpeed(Player player) {
        return BridgeEnchant.hasBoots(player, SOUL_SPEED);
    }

    public static int getFeatherFallingLevel(Player player) {
        return Math.min(4, BridgeEnchant.getBootsLevelArmor(player, FEATHER_FALLING));
    }

    public static int getDepthStriderLevel(Player player) {
        return Math.min(3, BridgeEnchant.getBootsLevelArmor(player, DEPTH_STRIDER));
    }

    public static int getSoulSpeedLevel(Player player) {
        return Math.min(3, BridgeEnchant.getBootsLevelArmor(player, SOUL_SPEED));
    }

    public static int getSwiftSneakLevel(Player player) {
        return Math.min(3, BridgeEnchant.getLeggingsLevelArmor(player, SWIFT_SNEAK));
    }

    public static float getSwiftSneakIncrement(Player player) {
        return MathUtil.clamp((float)BridgeEnchant.getSwiftSneakLevel(player) * 0.15f, 0.0f, 1.0f);
    }

    private static int getTrident(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand.getType().equals((Object)BridgeMaterial.TRIDENT)) {
            return Math.max(mainHand.getEnchantmentLevel(enchantment), level);
        }
        if (offHand.getType().equals((Object)BridgeMaterial.TRIDENT)) {
            level = Math.max(offHand.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    public static int getRiptideLevel(Player player) {
        return Math.min(3, BridgeEnchant.getTrident(player, RIPTIDE));
    }
}

