/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.attribute.Attribute;

public class BridgeAttribute {
    private static final Map<String, Attribute> all = new HashMap<String, Attribute>();
    public static final Attribute GRAVITY;
    public static final Attribute MOVEMENT_SPEED;
    public static final Attribute SCALE;
    public static final Attribute MINING_EFFICIENCY;
    public static final Attribute SUBMERGED_MINING_SPEED;
    public static final Attribute MOVEMENT_EFFICIENCY;
    public static final Attribute WATER_MOVEMENT_EFFICIENCY;
    public static final Attribute STEP_HEIGHT;
    public static final Attribute INTERACTION_RANGE;
    public static final Attribute ATTACK_RANGE;
    public static final Attribute SNEAKING_SPEED;
    public static final Attribute JUMP_STRENGTH;
    public static final Attribute BLOCK_BREAK_SPEED;
    public static final Attribute FALL_DAMAGE_MULTIPLIER;
    public static final Attribute SAFE_FALL_DISTANCE;

    public static Attribute get(String name) {
        return all.get(name.toLowerCase());
    }

    public static Attribute getFirst(String ... names) {
        for (String name : names) {
            Attribute type = BridgeAttribute.get(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static Attribute getFirstNotNull(String ... names) {
        Attribute attribute = BridgeAttribute.getFirst(names);
        if (attribute == null) {
            throw new NullPointerException("Attribute not present: " + StringUtil.join(names, ", "));
        }
        return attribute;
    }

    static {
        for (Attribute attribute : Arrays.asList(Attribute.values())) {
            String name = attribute.name().toLowerCase(Locale.ROOT);
            all.put(name, attribute);
        }
        GRAVITY = BridgeAttribute.getFirstNotNull("gravity", "generic_gravity");
        MOVEMENT_SPEED = BridgeAttribute.getFirstNotNull("movement_speed", "generic_movement_speed");
        SCALE = BridgeAttribute.getFirstNotNull("scale", "generic_scale");
        MINING_EFFICIENCY = BridgeAttribute.getFirstNotNull("mining_efficiency", "player_mining_efficiency");
        SUBMERGED_MINING_SPEED = BridgeAttribute.getFirstNotNull("submerged_mining_speed", "player_submerged_mining_speed");
        MOVEMENT_EFFICIENCY = BridgeAttribute.getFirstNotNull("movement_efficiency", "generic_movement_efficiency");
        WATER_MOVEMENT_EFFICIENCY = BridgeAttribute.getFirstNotNull("water_movement_efficiency", "generic_water_movement_efficiency");
        STEP_HEIGHT = BridgeAttribute.getFirstNotNull("step_height", "generic_step_height");
        INTERACTION_RANGE = BridgeAttribute.getFirstNotNull("block_interaction_range", "player_block_interaction_range");
        ATTACK_RANGE = BridgeAttribute.getFirstNotNull("entity_interaction_range", "player_entity_interaction_range");
        SNEAKING_SPEED = BridgeAttribute.getFirstNotNull("sneaking_speed", "player_sneaking_speed");
        JUMP_STRENGTH = BridgeAttribute.getFirstNotNull("jump_strength", "generic_jump_strength");
        BLOCK_BREAK_SPEED = BridgeAttribute.getFirstNotNull("block_break_speed", "player_block_break_speed");
        FALL_DAMAGE_MULTIPLIER = BridgeAttribute.getFirstNotNull("fall_damage_multiplier", "generic_fall_damage_multiplier");
        SAFE_FALL_DISTANCE = BridgeAttribute.getFirstNotNull("safe_fall_distance", "generic_safe_fall_distance");
    }
}

