/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.compat.bukkit.model.BukkitShapeModel;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BlockCacheBukkitModern
extends BlockCacheBukkit {
    private Map<Material, BukkitShapeModel> shapeModels;

    public BlockCacheBukkitModern(Map<Material, BukkitShapeModel> shapeModels) {
        super(null);
        this.shapeModels = shapeModels;
    }

    public BlockCacheBukkitModern(World world) {
        super(world);
    }

    @Override
    public int fetchData(int x, int y, int z) {
        int data;
        Material mat = this.getType(x, y, z);
        BukkitShapeModel shapeModel = this.shapeModels.get(mat);
        if (shapeModel != null && (data = shapeModel.getFakeData(this, this.world, x, y, z)) != Integer.MAX_VALUE) {
            return data;
        }
        return super.fetchData(x, y, z);
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        Material mat = this.getType(x, y, z);
        BukkitShapeModel shapeModel = this.shapeModels.get(mat);
        if (shapeModel == null) {
            return super.fetchBounds(x, y, z);
        }
        return shapeModel.getShape(this, this.world, x, y, z);
    }

    @Override
    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            for (Entity vehicle : entity.getNearbyEntities(0.1, 2.0, 0.1)) {
                EntityType type = vehicle.getType();
                if (!MaterialUtil.isBoat(type) && type != EntityType.SHULKER) continue;
                double vehicleY = vehicle.getLocation(this.useLoc).getY() + vehicle.getHeight();
                double entityY = entity.getLocation(this.useLoc).getY();
                this.useLoc.setWorld(null);
                return vehicleY < entityY + 0.1 && Math.abs(vehicleY - entityY) < 0.7;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

