/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.init.vanilla.special;

import fr.neatmonster.nocheatplus.compat.activation.ActivationUtil;
import fr.neatmonster.nocheatplus.compat.blocks.AbstractBlockPropertiesPatch;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.LinkedList;
import org.bukkit.Material;

public class MultiClientProtocolBlockShapePatch
extends AbstractBlockPropertiesPatch {
    public MultiClientProtocolBlockShapePatch() {
        this.activation.neutralDescription("Block shape patch for multi client protocol support.").advertise(true).setConditionsAND().notUnitTest().condition(ActivationUtil.getMultiProtocolSupportPluginActivation());
    }

    @Override
    public void setupBlockProperties(WorldConfigProvider<?> worldConfigProvider) {
        LinkedList<String> done = new LinkedList<String>();
        BlockFlags.addFlags(BridgeMaterial.LILY_PAD, BlockFlags.F_GROUND | BlockFlags.F_HEIGHT8_1 | BlockFlags.F_GROUND_HEIGHT);
        done.add("water_lily");
        BlockFlags.addFlags(BridgeMaterial.FARMLAND, BlockFlags.F_MIN_HEIGHT16_15 | BlockFlags.F_HEIGHT100 | BlockFlags.F_GROUND_HEIGHT);
        done.add("soil");
        try {
            BlockFlags.addFlags("HONEY_BLOCK", BlockFlags.F_MIN_HEIGHT16_15 | BlockFlags.F_GROUND_HEIGHT);
            done.add("honey_block");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (Material mat : MaterialUtil.SHULKER_BOXES) {
                BlockFlags.addFlags(mat, BlockFlags.F_SOLID | BlockFlags.F_GROUND_HEIGHT | BlockFlags.F_GROUND);
            }
            done.add("shulker_box");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StaticLog.logInfo("Applied block patches for multi client protocol support: " + StringUtil.join(done, ", "));
    }
}

