/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.init.vanilla;

import fr.neatmonster.nocheatplus.compat.blocks.BlockPropertiesSetup;
import fr.neatmonster.nocheatplus.compat.blocks.init.BlockInit;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import org.bukkit.Material;

public class BlocksMC1_13
implements BlockPropertiesSetup {
    public BlocksMC1_13() {
        BlockInit.assertMaterialExists("LILY_PAD");
        BlockInit.assertMaterialExists("CAVE_AIR");
    }

    @Override
    public void setupBlockProperties(WorldConfigProvider<?> worldConfigProvider) {
        BlockFlags.setBlockFlags("ANVIL", BlockFlags.SOLID_GROUND);
        BlockInit.setAs("VOID_AIR", Material.AIR);
        BlockInit.setAs("CAVE_AIR", Material.AIR);
        BlockInit.setAs("PODZOL", Material.DIRT);
        BlockInit.setAs("COARSE_DIRT", Material.DIRT);
        for (Material mat : MaterialUtil.CORAL_BLOCKS) {
            BlockInit.setAs(mat, Material.STONE);
        }
        for (Material mat : MaterialUtil.DEAD_CORAL_PARTS) {
            BlockProperties.setBlockProps(mat, BlockProperties.instantType);
            BlockFlags.setBlockFlags(mat, BlockFlags.F_IGN_PASSABLE);
        }
        for (Material mat : MaterialUtil.WATER_PLANTS) {
            BlockFlags.setFlag(mat, BlockFlags.F_XZ100 | BlockFlags.F_WATER_PLANT | BlockFlags.F_LIQUID | BlockFlags.F_WATER);
        }
        BlockInit.setAs("BUBBLE_COLUMN", Material.WATER);
        BlockFlags.addFlags("BUBBLE_COLUMN", BlockFlags.F_BUBBLE_COLUMN);
        BlockInit.setInstantPassable("WALL_TORCH");
        for (Material mat : MaterialUtil.SHULKER_BOXES) {
            BlockFlags.addFlags(mat, BlockFlags.F_XZ100 | BlockFlags.SOLID_GROUND);
        }
        for (Material mat : MaterialUtil.INFESTED_BLOCKS) {
            BlockProperties.setBlockProps(mat, BlockProperties.instantType);
        }
        for (Material mat : BridgeMaterial.getAllBlocks("andesite", "diorite", "granite", "polished_andesite", "polished_diorite", "polished_granite", "smooth_stone")) {
            BlockInit.setAs(mat, Material.STONE);
        }
        BlockProperties.setBlockProps("SMOOTH_STONE", BlockProperties.stoneTypeII);
        for (Material mat : MaterialUtil.HEADS_WALL) {
            BlockInit.setAs(mat, BridgeMaterial.SKELETON_SKULL);
        }
        BlockFlags.setFlagsAs("BLUE_ICE", Material.ICE);
        BlockFlags.addFlags("BLUE_ICE", BlockFlags.F_BLUE_ICE);
        BlockProperties.setBlockProps("BLUE_ICE", new BlockProperties.BlockProps(BlockProperties.woodPickaxe, 2.8f));
        BlockInit.setAs("WET_SPONGE", Material.SPONGE);
        BlockInit.setAs("RED_SAND", Material.SAND);
        BlockInit.setAs("SEAGRASS", Material.SEAGRASS);
        BlockInit.setAs("TALL_SEAGRASS", Material.TALL_SEAGRASS);
        BlockProperties.setBlockProps("SANDSTONE_SLAB", BlockProperties.stoneTypeII);
        BlockProperties.setBlockProps("RED_SANDSTONE_SLAB", BlockProperties.stoneTypeII);
        BlockInit.setAs("SMOOTH_SANDSTONE", Material.SANDSTONE);
        BlockProperties.setBlockProps("SMOOTH_SANDSTONE", BlockProperties.stoneTypeII);
        BlockInit.setAs("SMOOTH_RED_SANDSTONE", Material.SANDSTONE);
        BlockProperties.setBlockProps("SMOOTH_RED_SANDSTONE", BlockProperties.stoneTypeII);
        BlockInit.setAs("CUT_SANDSTONE", Material.SANDSTONE);
        BlockInit.setAs("CUT_RED_SANDSTONE", Material.SANDSTONE);
        BlockInit.setAs("CHISELED_SANDSTONE", Material.SANDSTONE);
        BlockInit.setAs("CHISELED_RED_SANDSTONE", Material.SANDSTONE);
        BlockInit.setAs("COBBLESTONE_SLAB", BridgeMaterial.BRICK_SLAB);
        BlockInit.setAs("STONE_BRICK_SLAB", BridgeMaterial.BRICK_SLAB);
        BlockInit.setAs("NETHER_BRICK_SLAB", BridgeMaterial.BRICK_SLAB);
        BlockProperties.setBlockProps("PRISMARINE_BRICK_SLAB", BlockProperties.stoneTypeI);
        BlockProperties.setBlockProps("PRISMARINE_SLAB", BlockProperties.stoneTypeI);
        BlockInit.setAs("DARK_PRISMARINE_SLAB", "PRISMARINE_SLAB");
        BlockInit.setAs("QUARTZ_SLAB", BridgeMaterial.STONE_SLAB);
        BlockInit.setAs("PETRIFIED_OAK_SLAB", BridgeMaterial.STONE_SLAB);
        BlockInit.setAs("PRISMARINE_BRICKS", BridgeMaterial.BRICKS);
        BlockProperties.setBlockProps("PRISMARINE_BRICKS", BlockProperties.stoneTypeI);
        BlockInit.setAs("MOSSY_STONE_BRICKS", "PRISMARINE_BRICKS");
        BlockInit.setAs("CHISELED_STONE_BRICKS", "PRISMARINE_BRICKS");
        BlockInit.setAs("CRACKED_STONE_BRICKS", "PRISMARINE_BRICKS");
        BlockInit.setAs("PRISMARINE_BRICK_STAIRS", BridgeMaterial.STONE_BRICK_STAIRS);
        BlockInit.setAs("PRISMARINE_STAIRS", BridgeMaterial.STONE_BRICK_STAIRS);
        BlockInit.setAs("DARK_PRISMARINE_STAIRS", BridgeMaterial.STONE_BRICK_STAIRS);
        BlockInit.setAs("MOSSY_COBBLESTONE_WALL", BridgeMaterial.COBBLESTONE_WALL);
        BlockInit.setAs("DARK_PRISMARINE", "PRISMARINE");
        BlockInit.setAs("DAMAGED_ANVIL", "ANVIL");
        BlockInit.setAs("CHIPPED_ANVIL", "ANVIL");
        BlockInit.setAs("CARVED_PUMPKIN", Material.PUMPKIN);
        BlockInit.setAs("SMOOTH_QUARTZ", "SMOOTH_SANDSTONE");
        BlockInit.setAs("CHISELED_QUARTZ_BLOCK", "QUARTZ_BLOCK");
        BlockInit.setPropsAs("QUARTZ_PILLAR", "QUARTZ_BLOCK");
        BlockProperties.setBlockProps("DRIED_KELP_BLOCK", new BlockProperties.BlockProps(BlockProperties.noTool, 0.5f));
        if (ServerVersion.compareMinecraftVersion("1.18") >= 0) {
            BlockProperties.setBlockProps(Material.CONDUIT, new BlockProperties.BlockProps(BlockProperties.stonePickaxe, 3.0f));
        } else {
            BlockProperties.setBlockProps("CONDUIT", new BlockProperties.BlockProps(BlockProperties.noTool, 3.0f));
        }
        BlockProperties.setBlockProps("SEA_PICKLE", BlockProperties.instantType);
        BlockFlags.addFlags("SEA_PICKLE", BlockFlags.F_GROUND | BlockFlags.F_GROUND_HEIGHT);
        BlockProperties.setBlockProps("TURTLE_EGG", new BlockProperties.BlockProps(BlockProperties.noTool, 0.5f));
        BlockFlags.removeFlags(BridgeMaterial.FARMLAND, BlockFlags.F_HEIGHT100);
        BlockFlags.addFlags(BridgeMaterial.FARMLAND, BlockFlags.F_XZ100 | BlockFlags.F_MIN_HEIGHT16_15);
        ConfigFile config = ConfigManager.getConfigFile();
        if (config.getBoolean("checks.blockbreak.debug", config.getBoolean("checks.debug", false))) {
            StaticLog.logInfo("Added block-info for Minecraft 1.13 blocks.");
        }
    }
}

