/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.changetracker;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.LinkedList;
import java.util.ListIterator;

public class OnGroundReference {
    private BlockCache blockCache = null;
    private BlockChangeReference ref = null;
    private long ignoreFlags = 0L;
    private LinkedList<BlockChangeTracker.BlockChangeEntry> entries = null;
    private ListIterator<BlockChangeTracker.BlockChangeEntry> itEntries = null;
    private BlockChangeTracker.BlockChangeEntry entry = null;
    private BlockCache.IBlockCacheNode node = null;
    private LinkedList<BlockChangeTracker.BlockChangeEntry> entriesAbove = null;
    private ListIterator<BlockChangeTracker.BlockChangeEntry> itEntriesAbove = null;
    private BlockChangeTracker.BlockChangeEntry entryAbove = null;
    private BlockCache.IBlockCacheNode nodeAbove = null;
    private int entriesAboveLockIndex = 0;

    public void init(BlockCache blockCache, BlockChangeReference ref, long ignoreFlags) {
        this.blockCache = blockCache;
        this.ref = ref;
        this.ignoreFlags = ignoreFlags;
    }

    public void setEntries(LinkedList<BlockChangeTracker.BlockChangeEntry> entries) {
        this.entries = entries;
        this.itEntries = null;
        this.entry = null;
        this.node = null;
    }

    public void setEntriesAbove(LinkedList<BlockChangeTracker.BlockChangeEntry> entriesAbove) {
        this.entriesAbove = entriesAbove;
        this.itEntriesAbove = null;
        this.entryAbove = null;
        this.nodeAbove = null;
    }

    public void moveDown() {
        this.entriesAbove = this.entries;
        this.itEntriesAbove = null;
        this.entryAbove = null;
        this.nodeAbove = this.node;
    }

    public void updateSpan() {
        if (this.entry != null) {
            this.ref.updateSpan(this.entry);
        }
        if (this.entryAbove != null) {
            this.ref.updateSpan(this.entryAbove);
        }
    }

    public void clear() {
        this.ignoreFlags = 0L;
        this.ref = null;
        this.entriesAbove = null;
        this.entries = null;
        this.itEntriesAbove = null;
        this.itEntries = null;
        this.entryAbove = null;
        this.entry = null;
        this.nodeAbove = null;
        this.node = null;
    }

    public boolean hasAnyEntries() {
        return this.entries != null || this.entriesAbove != null;
    }

    public BlockCache.IBlockCacheNode getNode() {
        return this.node;
    }

    public BlockCache.IBlockCacheNode getNodeAbove() {
        return this.nodeAbove;
    }

    public boolean initEntries(int x, int y, int z) {
        this.itEntries = this.entries == null ? null : this.entries.listIterator();
        this.itEntriesAbove = this.entriesAbove == null ? null : this.entriesAbove.listIterator();
        this.entriesAboveLockIndex = 0;
        if (this.itEntries != null) {
            while (this.itEntries.hasNext()) {
                this.entry = this.itEntries.next();
                if ((this.ref == null || this.ref.canUpdateWith(this.entry)) && BlockProperties.isGround(this.entry.previousState.getType(), this.ignoreFlags)) break;
                this.entry = null;
            }
        }
        if (this.entry == null) {
            this.node = this.blockCache.getOrCreateBlockCacheNode(x, y, z, false);
            if (!BlockProperties.isGround(this.node.getType(), this.ignoreFlags)) {
                this.entriesAbove = this.entries;
                return false;
            }
        } else {
            this.node = null;
        }
        ListIterator<Object> listIterator = this.itEntriesAbove = this.entriesAbove == null ? null : this.entriesAbove.listIterator();
        if (this.itEntriesAbove != null) {
            while (this.itEntriesAbove.hasNext()) {
                this.entryAbove = this.itEntriesAbove.next();
                if (this.ref == null || this.ref.canUpdateWith(this.entryAbove)) break;
                this.entryAbove = null;
            }
        }
        if (this.entry == null && this.entryAbove == null) {
            this.entriesAbove = this.entries;
            return false;
        }
        if (this.entry != null && this.entryAbove != null && !this.entry.overlapsIntervalOfValidity(this.entryAbove)) {
            if (this.entryAbove.nextEntryTick >= 0 && this.entry.tick > this.entryAbove.nextEntryTick) {
                this.entryAbove = null;
                while (this.itEntriesAbove.hasNext()) {
                    this.entryAbove = this.itEntriesAbove.next();
                    if (this.entryAbove.nextEntryTick >= 0 && this.entry.tick > this.entryAbove.nextEntryTick) {
                        this.entryAbove = null;
                        continue;
                    }
                    break;
                }
            } else if (this.entry.nextEntryTick >= 0 && this.entryAbove.tick > this.entry.nextEntryTick) {
                this.entry = null;
                while (this.itEntries.hasNext()) {
                    this.entry = this.itEntries.next();
                    if (this.entry.nextEntryTick >= 0 && this.entryAbove.tick > this.entry.nextEntryTick || !BlockProperties.isGround(this.entry.previousState.getType(), this.ignoreFlags)) {
                        this.entry = null;
                        continue;
                    }
                    break;
                }
            } else {
                throw new IllegalStateException("Unintended pun.");
            }
            if (this.entry == null && this.entryAbove == null) {
                return false;
            }
            if (this.entry == null) {
                this.node = this.blockCache.getOrCreateBlockCacheNode(x, y, z, false);
                if (!BlockProperties.isGround(this.node.getType(), this.ignoreFlags)) {
                    return false;
                }
            }
        }
        if (this.nodeAbove == null) {
            this.nodeAbove = this.entryAbove == null ? this.blockCache.getOrCreateBlockCacheNode(x, y + 1, z, false) : this.entryAbove.previousState;
        }
        if (this.node == null) {
            this.node = this.entry == null ? this.blockCache.getOrCreateBlockCacheNode(x, y, z, false) : this.entry.previousState;
        }
        return true;
    }

    public boolean advance() {
        if (this.entries == null) {
            if (this.itEntriesAbove.hasNext()) {
                this.entryAbove = this.itEntriesAbove.next();
                this.nodeAbove = this.entryAbove.previousState;
                return true;
            }
            return false;
        }
        if (this.entriesAbove == null) {
            this.entry = null;
            while (this.itEntries.hasNext()) {
                this.entry = this.itEntries.next();
                this.node = this.entry.previousState;
                if (BlockProperties.isGround(this.node.getType(), this.ignoreFlags)) {
                    return true;
                }
                this.entry = null;
                this.node = null;
            }
            return this.entry != null;
        }
        return this.advanceDualEntries();
    }

    private boolean advanceDualEntries() {
        do {
            this.entryAbove = null;
            this.nodeAbove = null;
            while (this.itEntriesAbove.hasNext()) {
                this.entryAbove = this.itEntriesAbove.next();
                this.nodeAbove = this.entryAbove.previousState;
                if (this.entry == null) {
                    return true;
                }
                if (this.entry.nextEntryTick >= 0 && this.entryAbove.tick > this.entry.nextEntryTick) {
                    this.entryAbove = null;
                    this.nodeAbove = null;
                    break;
                }
                if (this.entry.overlapsIntervalOfValidity(this.entryAbove)) {
                    return true;
                }
                this.entryAbove = null;
                this.nodeAbove = null;
            }
            this.entry = null;
            this.node = null;
            if (this.itEntries.hasNext()) {
                this.entry = this.itEntries.next();
                this.node = this.entry.previousState;
                while (this.itEntriesAbove.nextIndex() > this.entriesAboveLockIndex) {
                    this.entryAbove = this.itEntriesAbove.previous();
                    this.nodeAbove = this.entryAbove.previousState;
                }
                if (this.entryAbove == null) continue;
                while (!this.entry.overlapsIntervalOfValidity(this.entryAbove)) {
                    if (this.entry.nextEntryTick >= 0 && this.entryAbove.tick > this.entry.nextEntryTick) {
                        this.entryAbove = null;
                        this.nodeAbove = null;
                        break;
                    }
                    if (this.itEntriesAbove.hasNext()) {
                        this.entryAbove = this.itEntriesAbove.next();
                        this.nodeAbove = this.entryAbove.previousState;
                        this.entriesAboveLockIndex = this.itEntriesAbove.nextIndex();
                        continue;
                    }
                    this.entryAbove = null;
                    this.nodeAbove = null;
                    break;
                }
                if (this.entryAbove == null) continue;
                return true;
            }
            this.entryAbove = null;
            this.entry = null;
            this.nodeAbove = null;
            this.node = null;
            return false;
        } while (this.entry != null || this.entryAbove != null);
        return false;
    }
}

