/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks;

import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.utilities.Validate;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.AxisAlignedBBUtils;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class LegacyBlocks {
    private static final BlockStairs STAIRS = new BlockStairs();
    private static final BlockTrapDoor TRAPDOOR = new BlockTrapDoor();
    private static final Map<Material, Block> blocks = LegacyBlocks.init();

    private static Map<Material, Block> init() {
        HashMap<Material, Block> blocks = new HashMap<Material, Block>();
        for (Material mat : MaterialUtil.ALL_STAIRS) {
            blocks.put(mat, STAIRS);
        }
        for (Material mat : MaterialUtil.ALL_TRAP_DOORS) {
            blocks.put(mat, TRAPDOOR);
        }
        blocks.put(BridgeMaterial.END_PORTAL_FRAME, new BlockEndPortalFrame());
        blocks.put(BridgeMaterial.PISTON_HEAD, new BlockPistonHead());
        blocks.put(Material.BREWING_STAND, new BlockStatic(0.0, 0.0, 0.0, 1.0, 0.125, 1.0, 0.4375, 0.125, 0.4375, 0.5625, 0.875, 0.5625));
        blocks.put(Material.SOUL_SAND, new BlockStatic(0.0, 0.0, 0.0, 1.0, 0.875, 1.0));
        blocks.put(Material.CACTUS, new BlockStatic(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375));
        return blocks;
    }

    public static double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
        Block blockshape = blocks.get(mat);
        if (blockshape != null) {
            return blockshape.getShape(cache, mat, x, y, z, old);
        }
        return null;
    }

    public static class BlockStairs
    implements Block {
        private final double[] topslabs = new double[]{0.0, 0.5, 0.0, 1.0, 1.0, 1.0};
        private final double[] bottomslabs = new double[]{0.0, 0.0, 0.0, 1.0, 0.5, 1.0};
        private final double[] octet_nnn = new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 0.5};
        private final double[] octet_nnp = new double[]{0.0, 0.0, 0.5, 0.5, 0.5, 1.0};
        private final double[] octet_pnn = new double[]{0.5, 0.0, 0.0, 1.0, 0.5, 0.5};
        private final double[] octet_pnp = new double[]{0.5, 0.0, 0.5, 1.0, 0.5, 1.0};
        private final double[] octet_npn = new double[]{0.0, 0.5, 0.0, 0.5, 1.0, 0.5};
        private final double[] octet_npp = new double[]{0.0, 0.5, 0.5, 0.5, 1.0, 1.0};
        private final double[] octet_ppn = new double[]{0.5, 0.5, 0.0, 1.0, 1.0, 0.5};
        private final double[] octet_ppp = new double[]{0.5, 0.5, 0.5, 1.0, 1.0, 1.0};
        private final double[][] top_stairs = this.makeshape(this.topslabs, this.octet_nnn, this.octet_pnn, this.octet_nnp, this.octet_pnp);
        private final double[][] bottom_stairs = this.makeshape(this.bottomslabs, this.octet_npn, this.octet_ppn, this.octet_npp, this.octet_ppp);
        private final int[] shape_by_state = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

        @Override
        public double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
            return this.getShapeLegacy(cache, cache.getData(x, y, z), x, y, z);
        }

        public double[] getShapeLegacy(BlockCache cache, int data, int x, int y, int z) {
            boolean isTop = (data & 4) != 0;
            BlockFace face = this.dataToDirection(data);
            if (face == null) {
                return null;
            }
            int shapeindex = this.getStairShapeIndexLegacy(cache, face, isTop, data, x, y, z);
            if (isTop) {
                return this.top_stairs[this.shape_by_state[this.getShapeStateIndex(shapeindex, face)]];
            }
            return this.bottom_stairs[this.shape_by_state[this.getShapeStateIndex(shapeindex, face)]];
        }

        private int getStairShapeIndexLegacy(BlockCache cache, BlockFace face, boolean isTop, int data, int x, int y, int z) {
            BlockFace testFace;
            BlockFace oppositeface = face.getOppositeFace();
            Material testType1 = cache.getType(x + face.getModX(), y, z + face.getModZ());
            int testData1 = cache.getData(x + face.getModX(), y, z + face.getModZ());
            Material testType2 = cache.getType(x + oppositeface.getModX(), y, z + oppositeface.getModZ());
            int testData2 = cache.getData(x + oppositeface.getModX(), y, z + oppositeface.getModZ());
            if (BlockProperties.isStairs(testType1) && isTop == ((testData1 & 4) != 0) && (testFace = this.dataToDirection(testData1)) != null && this.hasDifferentAscAxis(face, testFace) && this.canTakeShape(cache, isTop, face, x + testFace.getOppositeFace().getModX(), y, z + testFace.getOppositeFace().getModZ())) {
                if (testFace == this.getCounterClockWise(face)) {
                    return 3;
                }
                return 4;
            }
            if (BlockProperties.isStairs(testType2) && isTop == ((testData2 & 4) != 0) && (testFace = this.dataToDirection(testData2)) != null && this.hasDifferentAscAxis(face, testFace) && this.canTakeShape(cache, isTop, face, x + testFace.getModX(), y, z + testFace.getModZ())) {
                if (testFace == this.getCounterClockWise(face)) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }

        private boolean hasDifferentAscAxis(BlockFace testFace1, BlockFace testFace2) {
            return testFace1.getOppositeFace() != testFace2;
        }

        private boolean canTakeShape(BlockCache cache, boolean orginStairTop, BlockFace orginStairFace, int x, int y, int z) {
            Material testType = cache.getType(x, y, z);
            int testData = cache.getData(x, y, z);
            boolean testTop = (testData & 4) != 0;
            BlockFace testFace = this.dataToDirection(testData);
            return !BlockProperties.isStairs(testType) || orginStairFace != testFace || orginStairTop != testTop;
        }

        private BlockFace getCounterClockWise(BlockFace face) {
            switch (face) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }

        private double[][] makeshape(double[] slab, double[] octet_nn, double[] octet_pn, double[] octet_np, double[] octet_pp) {
            return (double[][])IntStream.range(0, 16).mapToObj(flags -> this.makeStairShape(flags, slab, octet_nn, octet_pn, octet_np, octet_pp)).toArray(x$0 -> new double[x$0][]);
        }

        private double[] makeStairShape(int flags, double[] slab, double[] octet_nn, double[] octet_pn, double[] octet_np, double[] octet_pp) {
            double[] res = slab;
            if ((flags & 1) != 0) {
                res = this.merge(res, octet_nn);
            }
            if ((flags & 2) != 0) {
                res = this.merge(res, octet_pn);
            }
            if ((flags & 4) != 0) {
                res = this.merge(res, octet_np);
            }
            if ((flags & 8) != 0) {
                res = this.merge(res, octet_pp);
            }
            return res;
        }

        private int getShapeStateIndex(int shapeIndex, BlockFace face) {
            return shapeIndex * 4 + this.directionToValue(face);
        }

        private int directionToValue(BlockFace face) {
            switch (face) {
                default: {
                    return -1;
                }
                case NORTH: {
                    return 2;
                }
                case SOUTH: {
                    return 0;
                }
                case WEST: {
                    return 1;
                }
                case EAST: 
            }
            return 3;
        }

        private BlockFace dataToDirection(int data) {
            switch (data & 3) {
                case 0: {
                    return BlockFace.EAST;
                }
                case 1: {
                    return BlockFace.WEST;
                }
                case 2: {
                    return BlockFace.SOUTH;
                }
                case 3: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }

        private double[] add(double[] array1, double[] array2) {
            double[] newArray = new double[array1.length + array2.length];
            System.arraycopy(array1, 0, newArray, 0, array1.length);
            System.arraycopy(array2, 0, newArray, array1.length, array2.length);
            return newArray;
        }

        private double[] merge(double[] bounds, double[] octet) {
            double[] res = bounds;
            double minX = octet[0];
            double minY = octet[1];
            double minZ = octet[2];
            double maxX = octet[3];
            double maxY = octet[4];
            double maxZ = octet[5];
            for (int i = 2; i <= AxisAlignedBBUtils.getNumberOfAABBs(bounds); ++i) {
                List<Axis> a;
                double tminX = bounds[i * 6 - 6];
                double tminY = bounds[i * 6 - 5];
                double tminZ = bounds[i * 6 - 4];
                double tmaxX = bounds[i * 6 - 3];
                double tmaxY = bounds[i * 6 - 2];
                double tmaxZ = bounds[i * 6 - 1];
                if (!this.sameshape(minX, minY, minZ, maxX, maxY, maxZ, tminX, tminY, tminZ, tmaxX, tmaxY, tmaxZ) || (a = this.getRelative(minX, minY, minZ, maxX, maxY, maxZ, tminX, tminY, tminZ, tmaxX, tmaxY, tmaxZ)).size() != 1) continue;
                Axis axis = a.get(0);
                switch (axis) {
                    case X_AXIS: {
                        res[i * 6 - 6] = Math.min(tminX, minX);
                        res[i * 6 - 3] = Math.max(tmaxX, maxX);
                        return res;
                    }
                    case Z_AXIS: {
                        res[i * 6 - 4] = Math.min(tminZ, minZ);
                        res[i * 6 - 1] = Math.max(tmaxZ, maxZ);
                        return res;
                    }
                }
            }
            return this.add(res, octet);
        }

        private List<Axis> getRelative(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double tminX, double tminY, double tminZ, double tmaxX, double tmaxY, double tmaxZ) {
            ArrayList<Axis> list = new ArrayList<Axis>();
            if (minX == tmaxX || maxX == tminX) {
                list.add(Axis.X_AXIS);
            }
            if (minY == tmaxY || maxY == tminY) {
                list.add(Axis.Y_AXIS);
            }
            if (minZ == tmaxZ || maxZ == tminZ) {
                list.add(Axis.Z_AXIS);
            }
            return list;
        }

        private boolean sameshape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double tminX, double tminY, double tminZ, double tmaxX, double tmaxY, double tmaxZ) {
            double dx = maxX - minX;
            double dy = maxY - minY;
            double dz = maxZ - minZ;
            double tdx = tmaxX - tminX;
            double tdy = tmaxY - tminY;
            double tdz = tmaxZ - tminZ;
            return dx == tdx && dy == tdy && dz == tdz;
        }
    }

    public static class BlockTrapDoor
    implements Block {
        private static final double closedHeight = 0.1875;
        private static final double openWidth = 0.1875;

        @Override
        public double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
            return this.getShapeLegacy(cache.getData(x, y, z));
        }

        public double[] getShapeLegacy(int data) {
            BlockFace face = this.dataToDirection(data);
            if (face == null) {
                return null;
            }
            return this.getShape(face, (data & 4) != 0, (data & 8) == 0);
        }

        public BlockFace dataToDirection(int data) {
            switch (data & 3) {
                case 0: {
                    return BlockFace.NORTH;
                }
                case 1: {
                    return BlockFace.SOUTH;
                }
                case 2: {
                    return BlockFace.WEST;
                }
                case 3: {
                    return BlockFace.EAST;
                }
            }
            return null;
        }

        private double[] getShape(BlockFace face, boolean open, boolean bottom) {
            if (open) {
                switch (face) {
                    case NORTH: {
                        return new double[]{0.0, 0.0, 0.8125, 1.0, 1.0, 1.0};
                    }
                    case SOUTH: {
                        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.1875};
                    }
                    case EAST: {
                        return new double[]{0.0, 0.0, 0.0, 0.1875, 1.0, 1.0};
                    }
                    case WEST: {
                        return new double[]{0.8125, 0.0, 0.0, 1.0, 1.0, 1.0};
                    }
                }
            } else {
                double[] dArray;
                if (bottom) {
                    double[] dArray2 = new double[6];
                    dArray2[0] = 0.0;
                    dArray2[1] = 0.0;
                    dArray2[2] = 0.0;
                    dArray2[3] = 1.0;
                    dArray2[4] = 0.1875;
                    dArray = dArray2;
                    dArray2[5] = 1.0;
                } else {
                    double[] dArray3 = new double[6];
                    dArray3[0] = 0.0;
                    dArray3[1] = 0.8125;
                    dArray3[2] = 0.0;
                    dArray3[3] = 1.0;
                    dArray3[4] = 1.0;
                    dArray = dArray3;
                    dArray3[5] = 1.0;
                }
                return dArray;
            }
            return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
    }

    public static class BlockEndPortalFrame
    implements Block {
        public double[] getShapeLegacy(boolean hasEye) {
            double[] dArray;
            if (hasEye) {
                double[] dArray2 = new double[12];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                dArray2[3] = 1.0;
                dArray2[4] = 0.8125;
                dArray2[5] = 1.0;
                dArray2[6] = 0.3125;
                dArray2[7] = 0.8125;
                dArray2[8] = 0.3125;
                dArray2[9] = 0.6875;
                dArray2[10] = 1.0;
                dArray = dArray2;
                dArray2[11] = 0.6875;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                dArray3[2] = 0.0;
                dArray3[3] = 1.0;
                dArray3[4] = 0.8125;
                dArray = dArray3;
                dArray3[5] = 1.0;
            }
            return dArray;
        }

        public double[] getShapeLegacy(int data) {
            return this.getShapeLegacy((data & 4) != 0);
        }

        @Override
        public double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
            return this.getShapeLegacy(cache.getData(x, y, z));
        }
    }

    public static class BlockPistonHead
    implements Block {
        @Override
        public double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
            return this.getShapeLegacy(cache.getData(x, y, z), old);
        }

        public double[] getShapeLegacy(int data, boolean bugged) {
            BlockFace face = this.dataToDirection(data);
            if (face == null) {
                return null;
            }
            return this.getShape(face, bugged);
        }

        private double[] getShape(BlockFace face, boolean bugged) {
            double bug = bugged ? 0.125 : 0.0;
            switch (face) {
                case UP: {
                    return new double[]{0.375, 0.0, 0.375, 0.625, 1.0, 0.625, 0.0, 0.75, 0.0, 1.0, 1.0, 1.0};
                }
                case DOWN: {
                    return new double[]{0.375, 0.0, 0.375, 0.625, 1.0, 0.625, 0.0, 0.0, 0.0, 1.0, 0.25, 1.0};
                }
                case NORTH: {
                    return new double[]{0.375 - bug, 0.375, 0.0, 0.625 + bug, 0.625, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.25};
                }
                case SOUTH: {
                    return new double[]{0.375 - bug, 0.375, 0.0, 0.625 + bug, 0.625, 1.0, 0.0, 0.0, 0.75, 1.0, 1.0, 1.0};
                }
                case WEST: {
                    double[] dArray;
                    if (bugged) {
                        double[] dArray2 = new double[12];
                        dArray2[0] = 0.0;
                        dArray2[1] = 0.375;
                        dArray2[2] = 0.25;
                        dArray2[3] = 0.625;
                        dArray2[4] = 0.75;
                        dArray2[5] = 1.0;
                        dArray2[6] = 0.0;
                        dArray2[7] = 0.0;
                        dArray2[8] = 0.0;
                        dArray2[9] = 0.25;
                        dArray2[10] = 1.0;
                        dArray = dArray2;
                        dArray2[11] = 1.0;
                    } else {
                        double[] dArray3 = new double[12];
                        dArray3[0] = 0.0;
                        dArray3[1] = 0.375;
                        dArray3[2] = 0.375;
                        dArray3[3] = 1.0;
                        dArray3[4] = 0.625;
                        dArray3[5] = 0.625;
                        dArray3[6] = 0.0;
                        dArray3[7] = 0.0;
                        dArray3[8] = 0.0;
                        dArray3[9] = 0.25;
                        dArray3[10] = 1.0;
                        dArray = dArray3;
                        dArray3[11] = 1.0;
                    }
                    return dArray;
                }
                case EAST: {
                    return new double[]{0.0, 0.375, 0.375 - bug, 1.0, 0.625, 0.625 + bug, 0.75, 0.0, 0.0, 1.0, 1.0, 1.0};
                }
            }
            return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }

        private BlockFace dataToDirection(int data) {
            switch (data & 7) {
                case 0: {
                    return BlockFace.DOWN;
                }
                case 1: {
                    return BlockFace.UP;
                }
                case 2: {
                    return BlockFace.NORTH;
                }
                case 3: {
                    return BlockFace.SOUTH;
                }
                case 4: {
                    return BlockFace.WEST;
                }
                case 5: {
                    return BlockFace.EAST;
                }
            }
            return null;
        }
    }

    public static class BlockStatic
    implements Block {
        private final double[] bounds;

        public BlockStatic(double ... bounds) {
            if (bounds.length == 0) {
                this.bounds = null;
                return;
            }
            Validate.validateAABB(bounds);
            this.bounds = bounds;
        }

        @Override
        public double[] getShape(BlockCache cache, Material mat, int x, int y, int z, boolean old) {
            return this.bounds;
        }
    }

    public static interface Block {
        public double[] getShape(BlockCache var1, Material var2, int var3, int var4, int var5, boolean var6);
    }
}

