/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class SchedulerHelper {
    private static final boolean RegionizedServer = ReflectionUtil.getClass("io.papermc.paper.threadedregions.RegionizedServer") != null;
    private static final Class<?> GlobalRegionScheduler = ReflectionUtil.getClass("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
    private static final Class<?> EntityScheduler = ReflectionUtil.getClass("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
    private static final boolean isFoliaServer = RegionizedServer && GlobalRegionScheduler != null && EntityScheduler != null;

    public static boolean isFoliaServer() {
        return isFoliaServer;
    }

    public static Object runTaskAsync(Plugin plugin, Consumer<Object> run) {
        if (!isFoliaServer) {
            return Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> run.accept(null)).getTaskId();
        }
        Thread thread = Executors.defaultThreadFactory().newThread(() -> run.accept(null));
        if (thread == null) {
            return null;
        }
        thread.run();
        return thread;
    }

    public static Object runSyncTask(Plugin plugin, Consumer<Object> run) {
        if (!isFoliaServer) {
            return Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, () -> run.accept(null));
        }
        try {
            Method getSchedulerMethod = ReflectionUtil.getMethodNoArgs(Server.class, "getGlobalRegionScheduler", GlobalRegionScheduler);
            Object syncScheduler = getSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> schedulerClass = syncScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("run", Plugin.class, Consumer.class);
            Object taskInfo = executeMethod.invoke(syncScheduler, plugin, run);
            return taskInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object runSyncRepeatingTask(Plugin plugin, Consumer<Object> run, long delay, long period) {
        if (!isFoliaServer) {
            return Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, () -> run.accept(null), delay, period);
        }
        try {
            Method getSchedulerMethod = ReflectionUtil.getMethodNoArgs(Server.class, "getGlobalRegionScheduler", GlobalRegionScheduler);
            Object syncScheduler = getSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> schedulerClass = syncScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
            Object taskInfo = executeMethod.invoke(syncScheduler, plugin, run, delay, period);
            return taskInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object runSyncDelayedTask(Plugin plugin, Consumer<Object> run, long delay) {
        if (!isFoliaServer) {
            return Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, () -> run.accept(null), delay);
        }
        try {
            Method getSchedulerMethod = ReflectionUtil.getMethodNoArgs(Server.class, "getGlobalRegionScheduler", GlobalRegionScheduler);
            Object syncScheduler = getSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> schedulerClass = syncScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE);
            Object taskInfo = executeMethod.invoke(syncScheduler, plugin, run, delay);
            return taskInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object runSyncTaskForEntity(Entity entity, Plugin plugin, Consumer<Object> run, Runnable retired) {
        return SchedulerHelper.runSyncDelayedTaskForEntity(entity, plugin, run, retired, 1L);
    }

    public static Object runSyncDelayedTaskForEntity(Entity entity, Plugin plugin, Consumer<Object> run, Runnable retired, long delay) {
        if (!isFoliaServer) {
            return Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, () -> run.accept(null), delay);
        }
        try {
            Method getSchedulerMethod = ReflectionUtil.getMethodNoArgs(Entity.class, "getScheduler", EntityScheduler);
            Object syncEntityScheduler = getSchedulerMethod.invoke((Object)entity, new Object[0]);
            Class<?> schedulerClass = syncEntityScheduler.getClass();
            Method executeMethod = schedulerClass.getMethod("runDelayed", Plugin.class, Consumer.class, Runnable.class, Long.TYPE);
            Object taskInfo = executeMethod.invoke(syncEntityScheduler, plugin, run, retired, delay);
            return taskInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        if (task instanceof Thread) {
            return;
        }
        if (task instanceof Integer) {
            int taskId = (Integer)task;
            Bukkit.getScheduler().cancelTask(taskId);
        } else {
            Method cancelMethod = ReflectionUtil.getMethodNoArgs(task.getClass(), "cancel", new Class[0]);
            ReflectionUtil.invokeMethodNoArgs(cancelMethod, task);
        }
    }

    public static void cancelTasks(Plugin plugin) {
        if (!isFoliaServer) {
            Bukkit.getScheduler().cancelTasks(plugin);
        } else {
            try {
                Method getGlobalRegionSchedulerMethod = ReflectionUtil.getMethodNoArgs(Server.class, "getGlobalRegionScheduler", GlobalRegionScheduler);
                Object syncScheduler = getGlobalRegionSchedulerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                Class<?> schedulerClass = syncScheduler.getClass();
                Method executeMethod = schedulerClass.getMethod("cancelTasks", Plugin.class);
                executeMethod.invoke(syncScheduler, plugin);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean teleportEntity(Entity entity, Location loc, PlayerTeleportEvent.TeleportCause cause) {
        if (!isFoliaServer) {
            return entity.teleport(loc, cause);
        }
        try {
            Method teleportAsyncMethod = ReflectionUtil.getMethod(Entity.class, "teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class);
            Object result = ReflectionUtil.invokeMethod(teleportAsyncMethod, entity, loc, cause);
            CompletableFuture res = (CompletableFuture)result;
            return (Boolean)res.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTaskScheduled(Object task) {
        if (task == null) {
            return false;
        }
        if (task instanceof Integer) {
            return (Integer)task != -1;
        }
        return true;
    }
}

