/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BridgeMisc {
    public static final GameMode GAME_MODE_SPECTATOR = BridgeMisc.getSpectatorGameMode();
    private static final Method Bukkit_getOnlinePlayers = ReflectionUtil.getMethodNoArgs(Bukkit.class, "getOnlinePlayers", new Class[0]);
    private static final boolean hasIsFrozen = ReflectionUtil.getMethodNoArgs(LivingEntity.class, "isFrozen", Boolean.TYPE) != null;
    private static final boolean hasGravityMethod = ReflectionUtil.getMethodNoArgs(LivingEntity.class, "hasGravity", Boolean.TYPE) != null;
    private static final boolean hasIsHandRaisedMethod = ReflectionUtil.getMethodNoArgs(HumanEntity.class, "isHandRaised", Boolean.TYPE) != null;
    private static final boolean hasGetItemInUseMethod = ReflectionUtil.getMethodNoArgs(HumanEntity.class, "getItemInUse", ItemStack.class) != null;
    private static final boolean hasEntityChangePoseEvent = ReflectionUtil.getClass("org.bukkit.event.entity.EntityPoseChangeEvent") != null;
    private static final boolean hasPlayerInputEvent = ReflectionUtil.getClass("org.bukkit.event.player.PlayerInputEvent") != null;
    private static final boolean hasInputGetterMethod = ReflectionUtil.getMethodNoArgs(Player.class, "getCurrentInput", new Class[0]) != null;
    public static final PlayerTeleportEvent.TeleportCause TELEPORT_CAUSE_CORRECTION_OF_POSITION = PlayerTeleportEvent.TeleportCause.UNKNOWN;

    private static GameMode getSpectatorGameMode() {
        try {
            return GameMode.SPECTATOR;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final boolean hasInputGetterMethod() {
        return hasInputGetterMethod;
    }

    public static boolean hasPlayerInputEvent() {
        return hasPlayerInputEvent;
    }

    public static boolean hasEntityChangePoseEvent() {
        return hasEntityChangePoseEvent;
    }

    public static boolean hasGetItemInUseMethod() {
        return hasGetItemInUseMethod;
    }

    public static boolean hasIsHandRaisedMethod() {
        return hasIsHandRaisedMethod;
    }

    public static boolean hasAnyUsingItemMethod() {
        return hasGetItemInUseMethod || hasIsHandRaisedMethod;
    }

    public static boolean isWASDImpulseKnown(Player player) {
        if (!hasInputGetterMethod) {
            return false;
        }
        return DataManager.getPlayerData(player).getClientVersion().isAtLeast(ClientVersion.V_1_21_2);
    }

    public static boolean isSpaceBarImpulseKnown(Player player) {
        if (!hasInputGetterMethod) {
            return false;
        }
        if (DataManager.getPlayerData(player).getClientVersion().isAtLeast(ClientVersion.V_1_21_2)) {
            return true;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        return data.getOrUseVerticalVelocity(data.playerMoves.getCurrentMove().yDistance) != null;
    }

    public static boolean isRipgliding(Player player) {
        return Bridge1_9.isGliding((LivingEntity)player) && Bridge1_13.isRiptiding((LivingEntity)player);
    }

    public static boolean isVisuallyCrawling(Player player) {
        if (!BridgeMisc.hasEntityChangePoseEvent()) {
            return false;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_14)) {
            return false;
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        return player.getPose().equals((Object)Pose.SWIMMING) && !BlockProperties.isInWater(player, player.getLocation(), cc.yOnGround);
    }

    public static boolean isUsingItem(Player player) {
        if (player.isBlocking()) {
            return true;
        }
        if (BridgeMisc.hasGetItemInUseMethod()) {
            return player.getItemInUse() != null;
        }
        if (BridgeMisc.hasIsHandRaisedMethod()) {
            return player.isHandRaised();
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        return pData.getItemInUse() != null;
    }

    public static Material getItemInUse(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        return BridgeMisc.hasGetItemInUseMethod() ? player.getItemInUse().getType() : pData.getItemInUse();
    }

    public static boolean hasGravity(LivingEntity entity) {
        return !hasGravityMethod || entity.hasGravity();
    }

    public static boolean hasIsFrozen() {
        return hasIsFrozen;
    }

    public static float getPercentFrozen(Player player) {
        if (!BridgeMisc.hasIsFrozen()) {
            return 0.0f;
        }
        if (!BridgeMisc.canFreeze(player)) {
            return 0.0f;
        }
        int MAX_TICKS = player.getMaxFreezeTicks();
        return (float)Math.min(player.getFreezeTicks(), MAX_TICKS) / (float)MAX_TICKS;
    }

    public static float getPowderSnowSlowdown(Player player) {
        return -0.05f * BridgeMisc.getPercentFrozen(player);
    }

    public static boolean isFullyFrozen(Player player) {
        return player.getFreezeTicks() >= player.getMaxFreezeTicks();
    }

    public static boolean canFreeze(Player player) {
        ItemStack[] contents;
        if (!BridgeMisc.hasIsFrozen()) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        for (ItemStack armor : contents = inv.getArmorContents()) {
            if (armor == null || !armor.getType().toString().startsWith("LEATHER")) continue;
            return false;
        }
        return true;
    }

    public static boolean canStandOnPowderSnow(Player player) {
        if (!BridgeMisc.hasIsFrozen()) {
            return false;
        }
        if (DataManager.getPlayerData(player).getClientVersion().isLowerThan(ClientVersion.V_1_17)) {
            return false;
        }
        if (!player.isValid()) {
            return false;
        }
        ItemStack boots = player.getInventory().getBoots();
        return boots != null && boots.getType() == Material.LEATHER_BOOTS;
    }

    public static Player getShooterPlayer(Projectile projectile) {
        Object source;
        try {
            source = projectile.getClass().getMethod("getShooter", new Class[0]).invoke((Object)projectile, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ignored) {
            return null;
        }
        if (source instanceof Player) {
            return (Player)source;
        }
        return null;
    }

    public static Player getAttackingPlayer(Entity damager) {
        if (damager instanceof Player) {
            return (Player)damager;
        }
        if (damager instanceof Projectile) {
            return BridgeMisc.getShooterPlayer((Projectile)damager);
        }
        return null;
    }

    public static Player[] getOnlinePlayers() {
        try {
            Collection players = Bukkit.getOnlinePlayers();
            return players.isEmpty() ? new Player[]{} : players.toArray(new Player[players.size()]);
        }
        catch (NoSuchMethodError players) {
            Object obj;
            if (Bukkit_getOnlinePlayers != null && (obj = ReflectionUtil.invokeMethodNoArgs(Bukkit_getOnlinePlayers, null)) != null && obj instanceof Player[]) {
                return (Player[])obj;
            }
            return new Player[0];
        }
    }

    public static boolean maybeElytraBoost(Player player, Material materialInHand) {
        return DataManager.getPlayerData(player).getClientVersion().isAtLeast(ClientVersion.V_1_11_1) && BridgeMaterial.FIREWORK_ROCKET != null && materialInHand == BridgeMaterial.FIREWORK_ROCKET && Bridge1_9.isGlidingWithElytra(player);
    }

    public static int getFireworksPower(ItemStack item) {
        if (item == null || item.getType() != BridgeMaterial.FIREWORK_ROCKET) {
            return -1;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof FireworkMeta)) {
            return -1;
        }
        FireworkMeta fwMeta = (FireworkMeta)meta;
        return fwMeta.getPower();
    }
}

