/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.testing.stopwatch;

import fr.neatmonster.nocheatplus.command.testing.stopwatch.StopWatch;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class StopWatchRegistry {
    public static final String TAG = ChatColor.GRAY + "" + ChatColor.BOLD + "[" + ChatColor.RED + "NC+" + ChatColor.GRAY + "" + ChatColor.BOLD + "] " + ChatColor.GRAY;
    private Map<String, StopWatch> clocks = new LinkedHashMap<String, StopWatch>(20);
    private final OnDemandTickListener tickListener = new OnDemandTickListener(){

        @Override
        public boolean delegateTick(int tick, long timeLast) {
            return StopWatchRegistry.this.tickClocks();
        }
    };

    protected void setup(Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.MONITOR)
            public void onPlayerQuit(PlayerQuitEvent event) {
                StopWatchRegistry.this.removeClocks(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerKick(PlayerKickEvent event) {
                StopWatchRegistry.this.removeClocks(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public void onWorldChange(PlayerChangedWorldEvent event) {
                StopWatchRegistry.this.checkWorldChange(event.getPlayer());
            }
        }, plugin);
    }

    public StopWatch getClock(Player player) {
        return this.clocks.get(player.getName());
    }

    protected void removeClocks(Player player) {
        this.clocks.remove(player.getName());
    }

    protected void checkWorldChange(Player player) {
        StopWatch sw = this.getClock(player);
        try {
            if (sw != null && !sw.isFinished() && sw.checkStop()) {
                sw.sendStatus();
            }
        }
        catch (RuntimeException e) {
            this.timeBackwards(player);
        }
    }

    protected void timeBackwards(Player player) {
        this.removeClocks(player);
        player.sendMessage(TAG + "Stopwatch finished due to system time running backwards.");
    }

    protected boolean tickClocks() {
        if (this.clocks.isEmpty()) {
            return false;
        }
        boolean needsTick = false;
        Iterator<Map.Entry<String, StopWatch>> it = this.clocks.entrySet().iterator();
        while (it.hasNext()) {
            StopWatch sw = it.next().getValue();
            try {
                if (!sw.needsTick() || sw.isFinished()) continue;
                if (sw.checkStop()) {
                    sw.sendStatus();
                    continue;
                }
                needsTick = true;
            }
            catch (RuntimeException e) {
                it.remove();
                this.timeBackwards(sw.player);
            }
        }
        return needsTick;
    }

    public void setClock(Player player, StopWatch clock) {
        StopWatch oldClock = this.getClock(player);
        if (oldClock != null && !oldClock.isFinished()) {
            oldClock.stop();
            oldClock.sendStatus();
        }
        this.clocks.put(player.getName(), clock);
        if (clock.needsTick()) {
            this.tickListener.register();
        }
    }

    public boolean stopClock(Player player) {
        StopWatch oldClock = this.getClock(player);
        boolean wasRunning = false;
        if (oldClock != null) {
            wasRunning = !oldClock.isFinished();
            oldClock.stop();
            oldClock.sendStatus();
        }
        return wasRunning;
    }

    public void tellClock(Player player) {
        StopWatch oldClock = this.getClock(player);
        if (oldClock != null) {
            oldClock.sendStatus();
        }
    }
}

