/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.testing.stopwatch;

import fr.neatmonster.nocheatplus.utilities.Misc;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public abstract class StopWatch {
    public static final String TAG = ChatColor.GRAY + "" + ChatColor.BOLD + "[" + ChatColor.RED + "NC+" + ChatColor.GRAY + "" + ChatColor.BOLD + "] " + ChatColor.GRAY;
    public final long start = System.currentTimeMillis();
    protected boolean finished = false;
    private long duration = 0L;
    public final Player player;
    protected String clockDetails = "";

    public StopWatch(Player player) {
        this.player = player;
    }

    public String getClockDetails() {
        return this.clockDetails;
    }

    public long getTime() {
        if (this.isFinished()) {
            return this.duration;
        }
        long time = System.currentTimeMillis();
        if (time < this.start) {
            throw new RuntimeException("Time ran backwards.");
        }
        return time - this.start;
    }

    public long stop() {
        if (!this.finished) {
            this.duration = this.getTime();
            this.finished = true;
        }
        return this.duration;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sendStatus() {
        long duration = this.getTime();
        long tenths = duration % 1000L / 100L;
        this.player.sendMessage(TAG + "Stopwatch " + ChatColor.GOLD + this.clockDetails + ChatColor.GRAY + ": " + (this.finished ? ChatColor.RED : ChatColor.GREEN) + Misc.millisToShortDHMS(duration) + "." + tenths);
    }

    public abstract boolean checkStop();

    public abstract boolean needsTick();
}

