/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.top;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import fr.neatmonster.nocheatplus.utilities.FCFSComparator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TopCommand
extends BaseCommand {
    private static final String[][] comparatorArgs = new String[][]{{"-sumvl", "-sum", "-vl"}, {"-n", "-number", "-num", "-nvl"}, {"-avgvl", "-avg", "-avl", "-av", "-average", "-averagevl", "-avvl"}, {"-maxvl", "-max", "-maximum", "-maximumvl"}, {"-time", "-"}};

    public TopCommand(JavaPlugin plugin) {
        super(plugin, "top", Permissions.COMMAND_TOP);
        this.usage = TAG + "Optional: Specify number of entries to show (once).\nObligatory: Specify check types (multiple possible).\nOptional: Specify what to sort by (multiple possible: -sumvl, -avgvl, -maxvl, -nvl, -name, -time).\nThis is a heavy operation, use with care.";
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length < 2) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Bad setup.\nOptional: Specify number of entries to show (once).\nObligatory: Specify check types (multiple possible).\nOptional: Specify what to sort by (multiple possible: -sumvl, -avgvl, -maxvl, -nvl, -name, -time).\nThis is a heavy operation, use with care.");
            return true;
        }
        int startIndex = 1;
        int n = 10;
        try {
            n = Integer.parseInt(args[1].trim());
            startIndex = 2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n <= 0) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Setting number of entries to 10");
            n = 1;
        } else if (sender instanceof Player && n > 300) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Capping number of entries at 300.");
            n = 300;
        } else if (n > 10000) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Capping number of entries at 10000.");
            n = 10000;
        }
        LinkedHashSet<CheckType> checkTypes = new LinkedHashSet<CheckType>();
        for (int i = startIndex; i < args.length; ++i) {
            CheckType type = null;
            try {
                type = CheckType.valueOf(args[i].trim().toUpperCase().replace('-', '_').replace('.', '_'));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (type == null) continue;
            checkTypes.addAll(CheckTypeUtil.getWithDescendants(type));
        }
        if (checkTypes.isEmpty()) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "No check types specified.");
            return false;
        }
        Comparator<ViolationHistory.VLView> comparator = ViolationHistory.VLView.parseMixedComparator(args, startIndex);
        if (comparator == null) {
            comparator = new FCFSComparator<ViolationHistory.VLView>(Arrays.asList(ViolationHistory.VLView.CmpnVL, ViolationHistory.VLView.CmpSumVL), true);
        }
        Comparator<ViolationHistory.VLView> fcomparator = comparator;
        int fn = n;
        SchedulerHelper.runSyncTask((Plugin)this.access, arg -> new PrimaryThreadWorker(sender, checkTypes, fcomparator, fn, (Plugin)this.access).run());
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String arg = args[args.length - 1];
        if (arg.startsWith("-")) {
            while (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            arg = "-" + arg;
            return CommandUtil.getTabMatches(arg.toLowerCase(), comparatorArgs);
        }
        return CommandUtil.getCheckTypeTabMatches(arg);
    }

    protected static class PrimaryThreadWorker
    implements Runnable {
        private final Collection<CheckType> checkTypes;
        private final CommandSender sender;
        private final Comparator<ViolationHistory.VLView> comparator;
        private final int n;
        private final Plugin plugin;

        public PrimaryThreadWorker(CommandSender sender, Collection<CheckType> checkTypes, Comparator<ViolationHistory.VLView> comparator, int n, Plugin plugin) {
            this.checkTypes = new LinkedHashSet<CheckType>(checkTypes);
            this.sender = sender;
            this.comparator = comparator;
            this.n = n;
            this.plugin = plugin;
        }

        @Override
        public void run() {
            Iterator<CheckType> it = this.checkTypes.iterator();
            List<ViolationHistory.VLView> views = null;
            CheckType type = null;
            while (it.hasNext()) {
                type = it.next();
                it.remove();
                views = ViolationHistory.getView(type);
                if (!views.isEmpty()) break;
                views = null;
            }
            if (views == null) {
                this.sender.sendMessage(BaseCommand.TAG + "No history to process.");
            } else {
                CheckType ct = type;
                List<ViolationHistory.VLView> vlviews = views;
                SchedulerHelper.runTaskAsync(this.plugin, arg -> new AsynchronousWorker(this.sender, ct, vlviews, this.checkTypes, this.comparator, this.n, this.plugin).run());
            }
        }
    }

    protected static class AsynchronousWorker
    implements Runnable {
        private final CommandSender sender;
        private final CheckType checkType;
        private final List<ViolationHistory.VLView> views;
        private final Collection<CheckType> checkTypes;
        private final Comparator<ViolationHistory.VLView> comparator;
        private final int n;
        private final Plugin plugin;

        public AsynchronousWorker(CommandSender sender, CheckType checkType, List<ViolationHistory.VLView> views, Collection<CheckType> checkTypes, Comparator<ViolationHistory.VLView> comparator, int n, Plugin plugin) {
            this.sender = sender;
            this.checkType = checkType;
            this.views = views;
            this.checkTypes = checkTypes;
            this.comparator = comparator;
            this.n = n;
            this.plugin = plugin;
        }

        @Override
        public void run() {
            String it;
            String bo;
            String c3;
            String c2;
            String c1;
            DecimalFormat format = new DecimalFormat("#.#");
            if (this.sender instanceof Player) {
                c1 = ChatColor.GRAY.toString();
                c2 = ChatColor.RED.toString();
                c3 = ChatColor.GOLD.toString();
                bo = ChatColor.BOLD.toString();
                it = ChatColor.ITALIC.toString();
            } else {
                it = "";
                bo = "";
                c3 = "";
                c2 = "";
                c1 = "";
            }
            Collections.sort(this.views, this.comparator);
            StringBuilder builder = new StringBuilder(100 + 32 * this.views.size());
            builder.append((this.sender instanceof Player ? BaseCommand.TAG : "[NoCheatPlus] ") + "Top results for check: " + c3 + bo + "" + it + this.checkType.toString().toLowerCase());
            int done = 0;
            for (ViolationHistory.VLView view : this.views) {
                builder.append(c1 + "\n\u2022 " + c1 + "Player with top results: " + c2 + view.name);
                builder.append(c1 + "\n\u2022 " + c1 + "Sum: " + c2 + format.format(view.sumVL) + c1 + " VLs.");
                builder.append(c1 + "\n\u2022 " + c1 + "Triggered: " + c2 + view.nVL + c1 + " times.");
                builder.append(c1 + "\n\u2022 " + c1 + "Average: " + c2 + format.format(view.sumVL / (double)view.nVL) + c1 + " VL.");
                builder.append(c1 + "\n\u2022 " + c1 + "Max: " + c2 + format.format(view.maxVL) + c1 + " VL.");
                if (++done < this.n) continue;
                break;
            }
            if (this.views.isEmpty()) {
                builder.append((this.sender instanceof Player ? BaseCommand.TAG : "[NoCheatPlus] ") + "Nothing to display.");
            }
            String message = builder.toString();
            SchedulerHelper.runSyncTask(this.plugin, arg -> this.sender.sendMessage(message));
            if (!this.checkTypes.isEmpty()) {
                SchedulerHelper.runSyncTask(this.plugin, arg -> new PrimaryThreadWorker(this.sender, this.checkTypes, this.comparator, this.n, this.plugin).run());
            }
        }
    }
}

